/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccWaitOnShelfRollbackAbilityService;
import com.tydic.commodity.estore.ability.bo.UccWaitOnShelfRollbackAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccWaitOnShelfRollbackAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccWaitOnShelfRollbackBusiService;
import com.tydic.commodity.estore.busi.bo.UccWaitOnShelfRollbackBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccWaitOnShelfRollbackBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccWaitOnShelfRollbackAbilityService"})
public class UccWaitOnShelfRollbackAbilityServiceImpl
implements UccWaitOnShelfRollbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccWaitOnShelfRollbackAbilityServiceImpl.class);
    @Autowired
    private UccWaitOnShelfRollbackBusiService uccWaitOnShelfRollbackBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealWaitOnShelfRollback"})
    public UccWaitOnShelfRollbackAbilityRspBO dealWaitOnShelfRollback(@RequestBody UccWaitOnShelfRollbackAbilityReqBO reqBO) {
        UccWaitOnShelfRollbackAbilityRspBO rspBO = new UccWaitOnShelfRollbackAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56de\u9000\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List pos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        ArrayList<Long> failSkuIds = new ArrayList<Long>();
        for (UccSkuPo po : pos) {
            if (po.getApprovalStatus() == null || po.getApprovalStatus().equals(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_REJECT)) continue;
            failSkuIds.add(po.getSkuId());
        }
        if (!CollectionUtils.isEmpty(failSkuIds)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53ea\u80fd\u662f\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de\u548c\u672a\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6279\u7684\u53ef\u4ee5\u56de\u9000");
            return rspBO;
        }
        UccWaitOnShelfRollbackBusiReqBO busiReqBO = (UccWaitOnShelfRollbackBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccWaitOnShelfRollbackBusiReqBO.class));
        UccWaitOnShelfRollbackBusiRspBO busiRspBO = this.uccWaitOnShelfRollbackBusiService.dealWaitOnShelfRollback(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        if ("0000".equals(rspBO.getRespCode())) {
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
            Map<Long, List<UccSkuPo>> mapSku = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : mapSku.keySet()) {
                List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

