/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.estore.atom.api.UccUpdateSkuPropAtomService;
import com.tydic.commodity.estore.atom.bo.UccSkuAttrBO;
import com.tydic.commodity.estore.atom.bo.UccUpdateSkuPropAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccUpdateSkuPropAtomRspBO;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUpdateSkuPropAtomServiceImpl
implements UccUpdateSkuPropAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateSkuPropAtomServiceImpl.class);
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccUpdateSkuPropAtomRspBO updateSkuProp(UccUpdateSkuPropAtomReqBO reqBO) {
        UccUpdateSkuPropAtomRspBO rspBO = new UccUpdateSkuPropAtomRspBO();
        rspBO.setRespCode("0000");
        UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(reqBO.getSkuId().toString());
        if (uccSkuPo.getCommodityTypeId() == null) {
            log.info("\u5546\u54c1\u7c7b\u578bID\u4e3a\u7a7a");
            return rspBO;
        }
        List uccCommodityPropGrpPos = this.uccCommodityPropGrpMapper.queryGroupByCommodityTypeIdType(uccSkuPo.getCommodityTypeId());
        if (CollectionUtils.isEmpty((Collection)uccCommodityPropGrpPos)) {
            log.info("\u5546\u54c1\u7c7b\u578b\u672a\u5173\u8054\u5c5e\u6027\u7ec4");
            return rspBO;
        }
        Long commodityPropGrpId = ((UccCommodityPropGrpPo)uccCommodityPropGrpPos.get(0)).getCommodityPropGrpId();
        String commodityPropGrpName = ((UccCommodityPropGrpPo)uccCommodityPropGrpPos.get(0)).getCommodityPropGrpName();
        ArrayList<UccSkuAttrBO> addUccSkuAttrBos = new ArrayList<UccSkuAttrBO>();
        boolean isChange = this.isChange(uccSkuPo, addUccSkuAttrBos, reqBO, commodityPropGrpId, commodityPropGrpName);
        if (!CollectionUtils.isEmpty(addUccSkuAttrBos)) {
            ArrayList<UccSkuSpecPo> uccSkuSpecPos = new ArrayList<UccSkuSpecPo>();
            for (UccSkuAttrBO uccSpuSpecPo : addUccSkuAttrBos) {
                UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
                uccSkuSpecPo.setCommodityPropGrpId(commodityPropGrpId);
                uccSkuSpecPo.setCommodityPropGrpName(commodityPropGrpName);
                uccSkuSpecPo.setPropName(uccSpuSpecPo.getAttrName());
                uccSkuSpecPo.setPropShowName(uccSpuSpecPo.getAttrName());
                uccSkuSpecPo.setPropValue(uccSpuSpecPo.getAttrValue());
                uccSkuSpecPo.setCommodityId(uccSkuPo.getCommodityId());
                uccSkuSpecPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                uccSkuSpecPo.setSkuId(uccSkuPo.getSkuId());
                uccSkuSpecPo.setSkuSpecId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuSpecPo.setCreateOperId("sys");
                uccSkuSpecPo.setCreateTime(new Date());
                uccSkuSpecPo.setRemark("" + uccSkuPo.getCommodityTypeId());
                uccSkuSpecPo.setCommodityPropDefId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuSpecPo.setPropValueListId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuSpecPos.add(uccSkuSpecPo);
            }
            this.uccSkuSpecMapper.insertBatch(uccSkuSpecPos);
        }
        rspBO.setIsChange(isChange);
        return rspBO;
    }

    private boolean isChange(UccSkuPo uccSkuPo, List<UccSkuAttrBO> addUccSkuAttrBos, UccUpdateSkuPropAtomReqBO reqBO, Long commodityPropGrpId, String commodityPropGrpName) {
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(uccSkuPo.getSkuId());
        List uccSkuSpecPos = this.uccSkuSpecMapper.querySpecInfos(uccSkuSpecPo);
        boolean isChange = false;
        List<UccSkuAttrBO> uccSkuAttrBos = reqBO.getUccSkuAttrBos();
        if (CollectionUtils.isEmpty(uccSkuAttrBos)) {
            if (!CollectionUtils.isEmpty((Collection)uccSkuSpecPos)) {
                isChange = true;
                UccSkuSpecPo delUccSkuSpecPo = new UccSkuSpecPo();
                delUccSkuSpecPo.setSkuId(uccSkuPo.getSkuId());
                this.uccSkuSpecMapper.deleteSkuSpec(delUccSkuSpecPo);
            }
        } else if (CollectionUtils.isEmpty((Collection)uccSkuSpecPos)) {
            isChange = true;
            addUccSkuAttrBos.addAll(uccSkuAttrBos);
        } else {
            Map<String, List<UccSkuAttrBO>> stringListMap = uccSkuAttrBos.stream().collect(Collectors.groupingBy(UccSkuAttrBO::getAttrName));
            for (UccSkuSpecPo each : uccSkuSpecPos) {
                List<UccSkuAttrBO> skuParamList = stringListMap.get(each.getPropName());
                if (CollectionUtils.isEmpty(skuParamList)) {
                    isChange = true;
                    UccSkuSpecPo delUccSkuSpecPo = new UccSkuSpecPo();
                    delUccSkuSpecPo.setSkuSpecId(each.getSkuSpecId());
                    delUccSkuSpecPo.setSkuId(uccSkuPo.getSkuId());
                    this.uccSkuSpecMapper.deleteSkuSpec(delUccSkuSpecPo);
                    continue;
                }
                if (skuParamList.get(0).getAttrValue().equals(each.getPropValue())) continue;
                isChange = true;
                UccSkuSpecPo updateUccSkuSpecPo = new UccSkuSpecPo();
                updateUccSkuSpecPo.setSkuSpecId(each.getSkuSpecId());
                updateUccSkuSpecPo.setCommodityPropGrpId(commodityPropGrpId);
                updateUccSkuSpecPo.setCommodityPropGrpName(commodityPropGrpName);
                updateUccSkuSpecPo.setPropValue(skuParamList.get(0).getAttrValue());
                updateUccSkuSpecPo.setUpdateTime(new Date());
                updateUccSkuSpecPo.setUpdateOperId("\u7cfb\u7edf");
                updateUccSkuSpecPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                this.uccSkuSpecMapper.updateSkuSpec(updateUccSkuSpecPo);
            }
            Map<String, List<UccSkuSpecPo>> uccSkuSpecMap = uccSkuSpecPos.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getPropName));
            for (UccSkuAttrBO each : uccSkuAttrBos) {
                List<UccSkuSpecPo> uccSkuSpecList = uccSkuSpecMap.get(each.getAttrName());
                if (!CollectionUtils.isEmpty(uccSkuSpecList)) continue;
                isChange = true;
                addUccSkuAttrBos.add(each);
            }
        }
        return isChange;
    }
}

