/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuExtEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccSkuExtMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccSkuRejectVendorAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccSkuRejectVendorAbilityRspBo;
import com.tydic.commodity.estore.busi.api.UccSkuRejectVendorBusiService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuRejectVendorBusiServiceImpl
implements UccSkuRejectVendorBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuRejectVendorBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuExtMapper uccSkuExtMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @Override
    public UccSkuRejectVendorAbilityRspBo dealSkuRejectVendor(UccSkuRejectVendorAbilityReqBo reqBo) {
        UccSkuRejectVendorAbilityRspBo rspBo = new UccSkuRejectVendorAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1\u96c6\u5408");
            return rspBo;
        }
        List uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            for (Object uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getSkuStatus() == 2 || uccSkuPo.getApprovalStatus() == null || uccSkuPo.getApprovalStatus() != 21) continue;
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u53ea\u80fd\u5bf9\u672a\u63d0\u4ea4\u5546\u54c1\u4e0a\u67b6\u6216\u8005\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u7684\u5546\u54c1\u8fdb\u884c\u9a73\u56de\u81f3\u4f9b\u5e94\u5546\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                return rspBo;
            }
            Map<Long, List<UccSkuPo>> skuMap = uccSkuPos.stream().collect(Collectors.groupingBy(a -> a.getSupplierShopId()));
            for (Map.Entry entry : skuMap.entrySet()) {
                List<Long> skuIds = ((List)entry.getValue()).stream().map(a -> a.getSkuId()).distinct().collect(Collectors.toList());
                this.updateSkuStatus(SkuStatusEnum.INVALID_STATUS.getStatus(), "", "", skuIds, (Long)entry.getKey(), reqBo);
            }
            try {
                List skuIdList = reqBo.getSkuIds();
                String string = reqBo.getRemarks();
                this.uccSkuExtMapper.deleteBySkuIds(skuIdList);
                if (!CollectionUtils.isEmpty((Collection)skuIdList)) {
                    this.uccSkuExtMapper.batchInsertBySkuIds(skuIdList, SkuExtEnum.REJECTED_TO_SUPPLIER_REMARKS.getCode(), string, reqBo.getName());
                }
            }
            catch (Exception e) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u66f4\u65b0\u9a73\u56de\u81f3\u4f9b\u5e94\u5546\u5907\u6ce8\u62a5\u9519:" + e.getMessage());
                return rspBo;
            }
            ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                logRecordAbilityBO.setCreateOperId(reqBo.getName());
                logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                logRecordAbilityBO.setCreateTime(new Date());
                logRecordAbilityBO.setOperationType(Integer.valueOf(14));
                logRecordAbilityBO.setRemark("\u9a73\u56de\u81f3\u4f9b\u5e94\u5546");
                logRecordAbilityBO.setExtField1(reqBo.getUserId().toString());
                logRecordAbilityBO.setSkuExtValue(reqBo.getRemarks());
                recordAbilityBOS.add(logRecordAbilityBO);
            }
            try {
                if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                    UccSkuOperationLogRecordAbilityReqBO uccSkuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                    uccSkuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                    this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(uccSkuOperationLogRecordAbilityReqBO);
                }
            }
            catch (Exception exception) {
                log.error("\u8bb0\u5f55\u5355\u54c1\u64cd\u4f5c\u65e5\u5fd7\u62a5\u9519" + exception.getMessage());
            }
        }
        try {
            this.cancelTodoWait(reqBo);
        }
        catch (Exception e) {
            log.error("\u9a73\u56de\u6210\u529f\u53d6\u6d88\u5ba1\u6279\u5f85\u529e\uff0c\u53d1\u9001\u6d88\u606f\u65f6\u8bb0\u5f55\u7684\u62a5\u9519\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5931\u8d25");
        return rspBo;
    }

    private void cancelTodoWait(UccSkuRejectVendorAbilityReqBo reqBO) {
        List skuIds = reqBO.getSkuIds();
        for (Long skuId : skuIds) {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(Integer.valueOf(1));
            reqStationBO.setOrderId(skuId);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode()) || uacQryAuditLogRspBO.getLogInfo() == null) {
                log.error("\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a!");
                continue;
            }
            TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
            todoUccWaitAbilityReqBO.setBusiCode("2012");
            todoUccWaitAbilityReqBO.setBusiName("\u7533\u8bf7\u4e0a\u67b6\u5f85\u5ba1\u6279");
            todoUccWaitAbilityReqBO.setCenterCode("commodity");
            todoUccWaitAbilityReqBO.setOperatorType("2");
            todoUccWaitAbilityReqBO.setObjId(skuId);
            todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
            log.error("\u5f53\u524d\u53d6\u6d88\u4ee3\u529e\u5f97\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
            UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
            uccDealHandlerReqBO.setHandleName("productApplyHandler");
            this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
        }
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccSkuRejectVendorAbilityReqBo reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        uccStatusChangeUpdateSpuAtomReqBO.setName(reqBO.getName());
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

