/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.estore.ability.api.SkuDataGovernAbilityService;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuDataGovernBusiService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SkuDataGovernAbilityService"})
public class SkuDataGovernAbilityServiceImpl
implements SkuDataGovernAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SkuDataGovernAbilityServiceImpl.class);
    private UccSkuDataGovernBusiService uccSkuDataGovernBusiService;
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    public final int count = 100;

    @PostMapping(value={"skuDataGovernReceive"})
    public SkuDataGovernRspBO skuDataGovernReceive(@RequestBody SkuDataGovernReqBO reqBO) {
        SkuDataGovernRspBO rspBO;
        if (reqBO.getSkuInfos().size() == 0 || reqBO.getSkuInfos().size() > 100) {
            rspBO = new SkuDataGovernRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6cbb\u7406\u63a8\u9001\u6570\u636e\u5355\u54c1\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a\u6216\u8d85\u8fc7100\u6761\uff01");
        } else {
            rspBO = this.uccSkuDataGovernBusiService.dealSkuDataGovernReceive(reqBO);
            List skuIds = reqBO.getSkuInfos().stream().filter(a -> !StringUtils.isEmpty((Object)a.getSkuId())).map(a -> Long.valueOf(a.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(skuIds)) {
                try {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBo.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBo);
                }
                catch (Exception e) {
                    log.info("----------\u6570\u636e\u6cbb\u7406\u7ed3\u679c\u63a8\u9001\u5546\u54c1\u540c\u6b65ES\u62a5\u9519" + e);
                }
            }
        }
        return rspBO;
    }

    @Autowired
    public void setUccSkuDataGovernBusiService(UccSkuDataGovernBusiService uccSkuDataGovernBusiService) {
        this.uccSkuDataGovernBusiService = uccSkuDataGovernBusiService;
    }

    @Autowired
    public void setSyncSceneCommodityToEsAtomService(SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService) {
        this.syncSceneCommodityToEsAtomService = syncSceneCommodityToEsAtomService;
    }
}

