/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccJudgeSkuSurpassVptAtomService;
import com.tydic.commodity.common.ability.bo.UccJudgeSkuSurpassVptAtomReqBo;
import com.tydic.commodity.estore.ability.api.SkuPriceGovernAbilityService;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuPriceGovernBusiService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SkuPriceGovernAbilityService"})
public class SkuPriceGovernAbilityServiceImpl
implements SkuPriceGovernAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SkuPriceGovernAbilityServiceImpl.class);
    private UccSkuPriceGovernBusiService uccSkuPriceGovernBusiService;
    private UccJudgeSkuSurpassVptAtomService uccJudgeSkuSurpassVptAtomService;
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"skuPriceGovernReceive"})
    public SkuPriceGovernRspBO skuPriceGovernReceive(@RequestBody SkuPriceGovernReqBO reqBO) {
        SkuPriceGovernRspBO rspBO;
        if (reqBO.getSkuInfos().size() == 0) {
            rspBO = new SkuPriceGovernRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6cbb\u7406\u63a8\u9001\u6570\u636e\u5355\u54c1\u4ef7\u683c\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
        } else {
            List skuIds;
            rspBO = this.uccSkuPriceGovernBusiService.dealSkuPriceGovernBusi(reqBO);
            try {
                skuIds = reqBO.getSkuInfos().stream().map(a -> Long.valueOf(a.getSkuId())).distinct().collect(Collectors.toList());
                UccJudgeSkuSurpassVptAtomReqBo uccJudgeSkuSurpassVptAtomReqBo = new UccJudgeSkuSurpassVptAtomReqBo();
                uccJudgeSkuSurpassVptAtomReqBo.setSkuIds(skuIds);
                this.uccJudgeSkuSurpassVptAtomService.dealSkuSurpassVpt(uccJudgeSkuSurpassVptAtomReqBo);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u662f\u5426\u8d85\u8fc7\u9608\u503c\u5f02\u5e38\uff1a" + e.getMessage());
            }
            skuIds = reqBO.getSkuInfos().stream().filter(a -> !StringUtils.isEmpty((Object)a.getSkuId())).map(a -> Long.valueOf(a.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(skuIds)) {
                try {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBo.setSkuIds(skuIds);
                    syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBo);
                }
                catch (Exception e) {
                    log.info("----------\u6570\u636e\u6cbb\u7406\u7ed3\u679c\u63a8\u9001\u5546\u54c1\u540c\u6b65ES\u62a5\u9519" + e);
                }
            }
        }
        return rspBO;
    }

    @Autowired
    public void setUccSkuPriceGovernBusiService(UccSkuPriceGovernBusiService uccSkuPriceGovernBusiService) {
        this.uccSkuPriceGovernBusiService = uccSkuPriceGovernBusiService;
    }

    @Autowired
    public void setUccJudgeSkuSurpassVptAtomService(UccJudgeSkuSurpassVptAtomService uccJudgeSkuSurpassVptAtomService) {
        this.uccJudgeSkuSurpassVptAtomService = uccJudgeSkuSurpassVptAtomService;
    }

    @Autowired
    public void setSyncSceneCommodityToEsAtomService(SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService) {
        this.syncSceneCommodityToEsAtomService = syncSceneCommodityToEsAtomService;
    }
}

