/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccItemassociatedmaterialsAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccItemassociatedmaterialsAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccItemassociatedmaterialsBusiService;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccItemassociatedmaterialsBusiServiceImpl
implements UccItemassociatedmaterialsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccItemassociatedmaterialsBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;

    @Override
    public UccItemassociatedmaterialsAbilityRspBO dealUccItemassociatedmaterials(UccItemassociatedmaterialsAbilityReqBO reqBO) {
        UccItemassociatedmaterialsAbilityRspBO rspBO = new UccItemassociatedmaterialsAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList()) || reqBO.getMaterialId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5173\u8054\u4fe1\u606f");
            return rspBO;
        }
        UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(reqBO.getMaterialId());
        if (uccEMdmMaterialPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7269\u6599\u4fe1\u606f");
            return rspBO;
        }
        List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5355\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setMaterialId(uccEMdmMaterialPO.getMaterialId().toString());
        skuPo.setMaterialName(uccEMdmMaterialPO.getMaterialName());
        skuPo.setIsprofess(reqBO.getIsprofess());
        skuPo.setMaterialType(Integer.valueOf(1));
        try {
            this.uccSkuMapper.batchUpdateById(skus, skuPo);
        }
        catch (Exception e) {
            log.error("\u5355\u54c1\u7269\u6599\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1\u7269\u6599\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
            return rspBO;
        }
        ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        for (UccSkuPo uccSkuPo : uccSkuPoList) {
            UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
            logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
            logRecordAbilityBO.setCreateOperId(reqBO.getName());
            logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
            logRecordAbilityBO.setCreateTime(new Date());
            logRecordAbilityBO.setOperationType(Integer.valueOf(3));
            logRecordAbilityBO.setRemark("\u5173\u8054\u7269\u6599\u7f16\u7801");
            recordAbilityBOS.add(logRecordAbilityBO);
        }
        try {
            if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u5355\u54c1\u64cd\u4f5c\u65e5\u5fd7\u62a5\u9519" + e.getMessage());
        }
        ArrayList preOnShlef = new ArrayList();
        uccSkuPoList.stream().forEach(a -> {
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(a.getSkuSource()) && ModelRuleConstant.SKU_STATUS_APPROVAL.equals(a.getSkuStatus())) {
                UccBatchSkuBO bo = new UccBatchSkuBO();
                bo.setSkuId(a.getSkuId());
                bo.setSupplierShopId(a.getSupplierShopId());
                preOnShlef.add(bo);
            }
        });
        if (!CollectionUtils.isEmpty(preOnShlef)) {
            Map<Long, List<UccBatchSkuBO>> skuMap = preOnShlef.stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
            for (Long shopId : skuMap.keySet()) {
                List<Long> skuBOS = skuMap.get(shopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                try {
                    this.updateSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF, skuBOS, shopId, reqBO.getUserId());
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5355\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
                }
            }
        }
        rspBO.setBatchSkuList(preOnShlef);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, List<Long> skus, Long supplierShopId, Long userId) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(userId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

