/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.utils.BeanUtils;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.SkuDataGovernPropMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernRspBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernSkuInfo;
import com.tydic.commodity.estore.busi.api.UccSkuDataGovernBusiService;
import com.tydic.commodity.po.SkuDataGovernPO;
import com.tydic.commodity.po.SkuDataGovernPropPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSkuDataGovernBusiServiceImpl
implements UccSkuDataGovernBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuDataGovernBusiServiceImpl.class);
    private SkuDataGovernMapper skuDataGovernMapper;
    private SkuDataGovernPropMapper skuDataGovernPropMapper;
    private UccEMdmMaterialMapper uccMaterialMapper;
    private UccSkuMapper uccSkuMapper;

    @Override
    public SkuDataGovernRspBO dealSkuDataGovernReceive(SkuDataGovernReqBO reqBO) {
        SkuDataGovernRspBO rspBO = new SkuDataGovernRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List skuIds = reqBO.getSkuInfos().stream().map(e -> Long.valueOf(e.getSkuId())).distinct().collect(Collectors.toList());
        SkuDataGovernPO skuDeletePo = new SkuDataGovernPO();
        skuDeletePo.setSkuIds(skuIds);
        this.skuDataGovernMapper.deleteBy(skuDeletePo);
        SkuDataGovernPropPO skuDataGovernPropPo = new SkuDataGovernPropPO();
        skuDataGovernPropPo.setSkuIds(skuIds);
        this.skuDataGovernPropMapper.deleteBy(skuDataGovernPropPo);
        ArrayList<SkuDataGovernPO> list = new ArrayList<SkuDataGovernPO>();
        ArrayList<Long> syncEsSkuIds = new ArrayList<Long>();
        ArrayList<String> wrongSkuIds = new ArrayList<String>();
        for (SkuDataGovernSkuInfo skuInfo : reqBO.getSkuInfos()) {
            if (skuInfo.getResult() == 1) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(Long.valueOf(skuInfo.getSkuId()));
                if (CheckUtil.isBlank((Object)skuInfo.getMaterialStatus())) {
                    wrongSkuIds.add(skuInfo.getSkuId());
                    continue;
                }
                if (skuInfo.getMaterialStatus() == 1) {
                    if (CheckUtil.isNotBlank((String)skuInfo.getMaterialCode())) {
                        UccEMdmMaterialPO uccMdmMaterialPo = this.uccMaterialMapper.selectByMaterialCode(skuInfo.getMaterialCode());
                        if (uccMdmMaterialPo != null) {
                            uccSkuPo.setMaterialId(uccMdmMaterialPo.getMaterialId().toString());
                            uccSkuPo.setMaterialName(uccMdmMaterialPo.getMaterialName());
                        }
                    } else {
                        uccSkuPo.setMaterialId("");
                        uccSkuPo.setMaterialName("");
                    }
                    uccSkuPo.setMaterialType(Integer.valueOf(2));
                    this.uccSkuMapper.updateGovernInfo(uccSkuPo);
                }
                syncEsSkuIds.add(Long.valueOf(skuInfo.getSkuId()));
            }
            SkuDataGovernPO skuDataGovernPo = new SkuDataGovernPO();
            skuDataGovernPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            skuDataGovernPo.setSkuId(Long.valueOf(skuInfo.getSkuId()));
            skuDataGovernPo.setResult(skuInfo.getResult());
            skuDataGovernPo.setRemark(skuInfo.getRemark());
            skuDataGovernPo.setMaterialStatus(Integer.valueOf(skuInfo.getMaterialStatus() == null ? 0 : skuInfo.getMaterialStatus()));
            skuDataGovernPo.setMaterialCode(skuInfo.getMaterialCode() == null ? "" : skuInfo.getMaterialCode());
            skuDataGovernPo.setCreateTime(new Date());
            list.add(skuDataGovernPo);
            List propList = skuInfo.getSpecs().stream().map(e -> {
                SkuDataGovernPropPO skuDataGovernProp = new SkuDataGovernPropPO();
                BeanUtils.copyProperties((Object)e, (Object)skuDataGovernProp);
                skuDataGovernProp.setSkuId(Long.valueOf(skuInfo.getSkuId()));
                skuDataGovernProp.setCreateTime(new Date());
                return skuDataGovernProp;
            }).collect(Collectors.toList());
            if (propList.size() <= 0) continue;
            this.skuDataGovernPropMapper.insertBatch(propList);
            propList.clear();
        }
        this.skuDataGovernMapper.insertBatch(list);
        if (syncEsSkuIds.size() > 0) {
            rspBO.setSkuIds(syncEsSkuIds);
        }
        if (wrongSkuIds.size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(String.join((CharSequence)",", wrongSkuIds) + "\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8d4b\u7801\u72b6\u6001\u4e3a\u7a7a\uff01");
        }
        return rspBO;
    }

    @Autowired
    public void setSkuDataGovernMapper(SkuDataGovernMapper skuDataGovernMapper) {
        this.skuDataGovernMapper = skuDataGovernMapper;
    }

    @Autowired
    public void setSkuDataGovernPropMapper(SkuDataGovernPropMapper skuDataGovernPropMapper) {
        this.skuDataGovernPropMapper = skuDataGovernPropMapper;
    }

    @Autowired
    public void setUccMaterialMapper(UccEMdmMaterialMapper uccMaterialMapper) {
        this.uccMaterialMapper = uccMaterialMapper;
    }

    @Autowired
    public void setUccSkuMapper(UccSkuMapper uccSkuMapper) {
        this.uccSkuMapper = uccSkuMapper;
    }
}

