/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.PCodeConstant;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.api.SkuPriceDetailAbilityService;
import com.tydic.commodity.estore.ability.bo.SkuPriceDetailInfo;
import com.tydic.commodity.estore.ability.bo.SkuPriceDetailReqBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceDetailRspBO;
import com.tydic.commodity.estore.atom.api.UccEstoreDictionaryAtomService;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SkuPriceDetailAbilityService"})
public class SkuPriceDetailAbilityServiceImpl
implements SkuPriceDetailAbilityService {
    private UccSkuMapper uccSkuMapper;
    private UccCommodityMapper uccCommodityMapper;
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private SkuDataGovernPriceMapper skuDataGovernPriceMapper;
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    private UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService;
    private UccVendorMapper uccVendorMapper;
    @Autowired
    UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    UccSaleNumMapper uccSaleNumMapper;

    @PostMapping(value={"skuPriceDetail"})
    public SkuPriceDetailRspBO skuPriceDetail(@RequestBody SkuPriceDetailReqBO reqBO) {
        SkuPriceDetailRspBO rspBO = new SkuPriceDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CheckUtil.isBlank((Object)reqBO.getSkuId()) || CheckUtil.isBlank((Object)reqBO.getType())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SkuDataGovernPricePO governPricePo = new SkuDataGovernPricePO();
        governPricePo.setSkuId(reqBO.getSkuId());
        SkuDataGovernPricePO modelBy = this.skuDataGovernPriceMapper.getModelBy(governPricePo);
        if (CheckUtil.isNotBlank((Object)modelBy)) {
            rspBO.setRegulationPrice(modelBy.getRegularPrice());
            rspBO.setLowestPrice(modelBy.getLowestPrice());
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        SkuDataGovernSamePricePO pricePo = new SkuDataGovernSamePricePO();
        BeanUtil.copyProperties((Object)reqBO, (Object)pricePo);
        List listPage = this.skuDataGovernSamePriceMapper.getListPage(pricePo, page);
        ArrayList<SkuPriceDetailInfo> rows = new ArrayList<SkuPriceDetailInfo>();
        if (listPage.size() > 0) {
            Map<String, String> skuStatusMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap(PCodeConstant.SKU_STATUS.getCode());
            for (SkuDataGovernSamePricePO p : listPage) {
                SkuPriceDetailInfo row = new SkuPriceDetailInfo();
                row.setPrice(p.getPrice());
                BigDecimal skuPriceBigimal = new BigDecimal("0.00");
                UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(p.getSkuId().toString());
                if (CheckUtil.isNotBlank((Object)uccSkuPo)) {
                    UccCommodityTypePo uccCommodityTypePo;
                    UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                    uccSkuPricePo.setSkuId(p.getSkuId());
                    UccSkuPricePo uccSkuPrice = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
                    if (null != uccSkuPrice.getSalePrice()) {
                        skuPriceBigimal = MoneyUtils.haoToYuan((Long)uccSkuPrice.getSalePrice());
                    }
                    UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
                    uccSaleNumPo.setSkuId(p.getSkuId());
                    UccSaleNumPo saleNumPo = this.uccSaleNumMapper.querySaleNum(uccSaleNumPo);
                    row.setSalePrice(skuPriceBigimal);
                    if (null != saleNumPo.getSoldNumber()) {
                        row.setSoldNumber(saleNumPo.getSoldNumber());
                    }
                    row.setSkuCode(uccSkuPo.getSkuCode());
                    row.setSkuName(uccSkuPo.getSkuName());
                    row.setExtSkuId(uccSkuPo.getExtSkuId());
                    row.setSkuStatus(uccSkuPo.getSkuStatus());
                    row.setBrandName(uccSkuPo.getBrandName());
                    if (uccSkuPo.getSkuStatus() != null && skuStatusMap != null && skuStatusMap.containsKey(uccSkuPo.getSkuStatus().toString())) {
                        row.setSkuStatusDesc(skuStatusMap.get(uccSkuPo.getSkuStatus().toString()));
                    }
                    row.setMaterialId(uccSkuPo.getMaterialId());
                    UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(uccSkuPo.getCommodityId());
                    if (CheckUtil.isNotBlank((Object)commodityById)) {
                        row.setCommodityCode(commodityById.getCommodityCode());
                        row.setCommodityName(commodityById.getCommodityName());
                        row.setExtSpuId(commodityById.getExtSpuId());
                        UccVendorPo uccVendorPo = this.uccVendorMapper.queryVendorByVendorId(commodityById.getVendorId());
                        if (CheckUtil.isNotBlank((Object)uccVendorPo)) {
                            row.setVendorCode(uccVendorPo.getVendorCode());
                            row.setVendorName(uccVendorPo.getVendorName());
                        }
                    }
                    if (CheckUtil.isNotBlank((Object)(uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPo.getCommodityTypeId())))) {
                        row.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                    }
                }
                rows.add(row);
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    @Autowired
    public void setUccSkuMapper(UccSkuMapper uccSkuMapper) {
        this.uccSkuMapper = uccSkuMapper;
    }

    @Autowired
    public void setUccCommodityMapper(UccCommodityMapper uccCommodityMapper) {
        this.uccCommodityMapper = uccCommodityMapper;
    }

    @Autowired
    public void setUccCommodityTypeMapper(UccCommodityTypeMapper uccCommodityTypeMapper) {
        this.uccCommodityTypeMapper = uccCommodityTypeMapper;
    }

    @Autowired
    public void setSkuDataGovernPriceMapper(SkuDataGovernPriceMapper skuDataGovernPriceMapper) {
        this.skuDataGovernPriceMapper = skuDataGovernPriceMapper;
    }

    @Autowired
    public void setSkuDataGovernSamePriceMapper(SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper) {
        this.skuDataGovernSamePriceMapper = skuDataGovernSamePriceMapper;
    }

    @Autowired
    public void setUccEstoreDictionaryAtomService(UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService) {
        this.uccEstoreDictionaryAtomService = uccEstoreDictionaryAtomService;
    }

    @Autowired
    public void setUccVendorMapper(UccVendorMapper uccVendorMapper) {
        this.uccVendorMapper = uccVendorMapper;
    }
}

