/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApprovalBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccBrandSkuOnCheckAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccEstoreItemonShlefApprovalAbilityService;
import com.tydic.commodity.estore.ability.bo.UccEstoreItemonShlefApprovalAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEstoreItemonShlefApprovalAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccWaitOnShelfRollbackBusiService;
import com.tydic.commodity.estore.busi.bo.UccWaitOnShelfRollbackBusiReqBO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccEstoreItemonShlefApprovalAbilityService"})
public class UccEstoreItemonShlefApprovalAbilityServiceImpl
implements UccEstoreItemonShlefApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreItemonShlefApprovalAbilityServiceImpl.class);
    @Autowired
    private UccUpAndOffApprovalBusiService uccUpAndOffApprovalBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccWaitOnShelfRollbackBusiService uccWaitOnShelfRollbackBusiService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccBrandSkuOnCheckAbilityService uccBrandSkuOnCheckAbilityService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"dealonShlefApproval"})
    public UccEstoreItemonShlefApprovalAbilityRspBO dealonShlefApproval(@RequestBody UccEstoreItemonShlefApprovalAbilityReqBO reqBO) {
        UccEstoreItemonShlefApprovalAbilityRspBO rspBO;
        block16: {
            Iterator<Long> iterator;
            Map<Long, List<UccBatchSkuBO>> skuMap;
            block18: {
                List skuIds;
                block19: {
                    block17: {
                        rspBO = new UccEstoreItemonShlefApprovalAbilityRspBO();
                        UccBrandSkuOnCheckAbilityReqBo uccBrandSkuOnCheckAbilityReqBo = new UccBrandSkuOnCheckAbilityReqBo();
                        uccBrandSkuOnCheckAbilityReqBo.setSkuIds(reqBO.getBatchSkuList().stream().map(a -> a.getSkuId()).collect(Collectors.toList()));
                        UccBrandSkuOnCheckAbilityRspBo uccBrandSkuOnCheckAbilityRspBo = this.uccBrandSkuOnCheckAbilityService.checkSkuOn(uccBrandSkuOnCheckAbilityReqBo);
                        if (!"0000".equals(uccBrandSkuOnCheckAbilityRspBo.getRespCode())) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc(uccBrandSkuOnCheckAbilityRspBo.getRespDesc());
                            return rspBO;
                        }
                        UccUpAndOffApprovalAbilityReqBO busiReqBO = new UccUpAndOffApprovalAbilityReqBO();
                        UccUpAndOffApprovalAbilityRspBO busiRspBO = new UccUpAndOffApprovalAbilityRspBO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
                        busiReqBO.setBatchSkuList(reqBO.getBatchSkuList());
                        ExtReqBO extReqBO = new ExtReqBO();
                        extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        ArrayList<Integer> oldStatus = new ArrayList<Integer>();
                        oldStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
                        extReqBO.setStatusOld(oldStatus);
                        extReqBO.setNoChangeStatus(true);
                        extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                        extReqBO.setAuditStatusReject(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_REJECT.toString());
                        extReqBO.setAuditStatusCheck(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.toString());
                        extReqBO.setAuditStatusConsent(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_CONSENT.toString());
                        extReqBO.setRemark("\u624b\u5de5\u4e0a\u67b6");
                        try {
                            busiRspBO = this.uccUpAndOffApprovalBusiService.dealUpAndOffApproval(busiReqBO, extReqBO);
                            BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
                        }
                        catch (Exception e) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc(e.getMessage());
                            return rspBO;
                        }
                        if (!"0000".equals(rspBO.getRespCode())) {
                            return rspBO;
                        }
                        if (reqBO.getRejectWay() == null || reqBO.getRejectWay() != 2) break block17;
                        List preOnShlef = reqBO.getBatchSkuList();
                        if (CollectionUtils.isEmpty((Collection)preOnShlef)) break block16;
                        skuMap = preOnShlef.stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
                        iterator = skuMap.keySet().iterator();
                        break block18;
                    }
                    if (reqBO.getRejectWay() == null || reqBO.getRejectWay() != 1) break block19;
                    if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u8bf7\u4f20\u5165\u8981\u9a73\u56de\u7684\u5546\u54c1");
                        return rspBO;
                    }
                    UccWaitOnShelfRollbackBusiReqBO rollBusiReqBO = (UccWaitOnShelfRollbackBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccWaitOnShelfRollbackBusiReqBO.class));
                    rollBusiReqBO.setNoRollbackFlag(1);
                    List<Long> skuIds2 = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                    rollBusiReqBO.setSkuIds(skuIds2);
                    this.uccWaitOnShelfRollbackBusiService.dealWaitOnShelfRollback(rollBusiReqBO);
                    break block16;
                }
                if (reqBO.getAuditResult() == 0 && !CollectionUtils.isEmpty(skuIds = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList()))) {
                    List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
                    ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
                    for (UccSkuPo uccSkuPo : uccSkuPoList) {
                        UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                        logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                        logRecordAbilityBO.setCreateOperId(reqBO.getName());
                        logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                        logRecordAbilityBO.setCreateTime(new Date());
                        logRecordAbilityBO.setOperationType(Integer.valueOf(0));
                        logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0a\u67b6");
                        logRecordAbilityBO.setExtField1(reqBO.getUserId().toString());
                        recordAbilityBOS.add(logRecordAbilityBO);
                    }
                    try {
                        if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                            UccSkuOperationLogRecordAbilityReqBO uccSkuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                            uccSkuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                            this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(uccSkuOperationLogRecordAbilityReqBO);
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        log.error("\u8bb0\u5f55\u5355\u54c1\u64cd\u4f5c\u65e5\u5fd7\u62a5\u9519" + exception.getMessage());
                    }
                }
                break block16;
            }
            while (iterator.hasNext()) {
                Long l = iterator.next();
                List<Long> skuBOS = skuMap.get(l).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                try {
                    this.updateSkuStatus(ModelRuleConstant.SKU_STATUS_INVALID, skuBOS, l, reqBO.getUserId());
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5355\u54c1\u4fe1\u606f\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
                }
            }
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        Iterator<Long> iteratorSpu = mapSku.keySet().iterator();
        while (iteratorSpu.hasNext()) {
            Long supplierShopId = iteratorSpu.next();
            List list = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(list));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            if (reqBO.getRejectWay() != null && reqBO.getRejectWay() == 1) {
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            }
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, List<Long> skus, Long supplierShopId, Long userId) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(userId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

