/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuOperationLogMapper;
import com.tydic.commodity.estore.busi.api.UccEstoreFailureOfGoodsBusiService;
import com.tydic.commodity.estore.busi.bo.UccEstoreFailureOfGoodsBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccEstoreFailureOfGoodsBusiRspBO;
import com.tydic.commodity.po.UccSkuOperationLogPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccEstoreFailureOfGoodsBusiServiceImpl
implements UccEstoreFailureOfGoodsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreFailureOfGoodsBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuOperationLogMapper uccSkuOperationLogMapper;
    private static final Integer SKU_STATUS = 6;
    private static final Integer OPERATION_TYPE = 14;

    @Override
    public UccEstoreFailureOfGoodsBusiRspBO dealEstoreFailureOfGoods(UccEstoreFailureOfGoodsBusiReqBO reqBO) {
        UccEstoreFailureOfGoodsBusiRspBO rspBO = new UccEstoreFailureOfGoodsBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        int batchUpdateRow = this.uccSkuMapper.batchUpdateSkuStatusByIds(reqBO.getSkuIds(), SKU_STATUS, null);
        if (batchUpdateRow != reqBO.getSkuIds().size()) {
            throw new BusinessException("8888", "\u5546\u54c1\u5931\u6548\u64cd\u4f5c\u5931\u8d25");
        }
        ArrayList<UccSkuOperationLogPO> uccSkuOperationLogPOList = new ArrayList<UccSkuOperationLogPO>();
        for (Long skuId : reqBO.getSkuIds()) {
            UccSkuOperationLogPO uccSkuOperationLogPO = new UccSkuOperationLogPO();
            uccSkuOperationLogPO.setBatchId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuOperationLogPO.setSkuId(skuId);
            uccSkuOperationLogPO.setOperationType(OPERATION_TYPE);
            uccSkuOperationLogPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uccSkuOperationLogPO.setCreateTime(new Date());
            uccSkuOperationLogPO.setRemark("\u9a73\u56de\u81f3\u4f9b\u5e94\u5546");
            uccSkuOperationLogPOList.add(uccSkuOperationLogPO);
        }
        this.uccSkuOperationLogMapper.batchInsert(uccSkuOperationLogPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

