/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.estore.atom.api.UccDealApprovalAtomService;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomRspBO;
import com.tydic.commodity.estore.busi.api.UccApplyShelvesFormAuditBusiService;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesFormAuditBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesFormAuditBusiRspBO;
import com.tydic.commodity.po.ApplyShelvesFormPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccApplyShelvesFormAuditBusiServiceImpl
implements UccApplyShelvesFormAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyShelvesFormAuditBusiServiceImpl.class);
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private UccDealApprovalAtomService uccDealApprovalAtomService;

    @Override
    public UccApplyShelvesFormAuditBusiRspBO auditApplyShelvesForm(UccApplyShelvesFormAuditBusiReqBO reqBO) {
        UccApplyShelvesFormAuditBusiRspBO rspBO = new UccApplyShelvesFormAuditBusiRspBO();
        ArrayList<ApplyShelvesFormPO> list = new ArrayList<ApplyShelvesFormPO>();
        for (Long applyId : reqBO.getApplyIds()) {
            ApplyShelvesFormPO applyShelvesFormPo = new ApplyShelvesFormPO();
            applyShelvesFormPo.setApplyId(applyId);
            ApplyShelvesFormPO modelBy = this.applyShelvesFormMapper.getModelBy(applyShelvesFormPo);
            if (modelBy == null || !modelBy.getApplyStatus().equals(1)) continue;
            list.add(modelBy);
        }
        if (list.size() < reqBO.getApplyIds().size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u7533\u8bf7\u5355id\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
            return rspBO;
        }
        for (ApplyShelvesFormPO po : list) {
            UccDealApprovalAtomReqBO bo = new UccDealApprovalAtomReqBO();
            bo.setAuditAdvice(reqBO.getAuditAdvice());
            bo.setAuditResult(reqBO.getAuditType());
            bo.setStepId(po.getStepId());
            bo.setUserId(reqBO.getUserId());
            bo.setUserName(reqBO.getName());
            bo.setObjType(1);
            bo.setObjId(po.getApplyId());
            bo.setOrgName(reqBO.getOrgName());
            UccDealApprovalAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAtomService.dealApproval(bo);
            if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(dealApprovalAtomRspBO.getRespDesc());
                return rspBO;
            }
            po.setStepId(dealApprovalAtomRspBO.getStepId());
            if (reqBO.getAuditType() == 0 && dealApprovalAtomRspBO.getFinish().booleanValue()) {
                po.setApplyStatus(Integer.valueOf(2));
                po.setAuditCommitTimeEnd(new Date());
                po.setAcceptStatus(Integer.valueOf(1));
            }
            if (reqBO.getAuditType() == 1) {
                po.setApplyStatus(Integer.valueOf(3));
                po.setAuditCommitTimeEnd(new Date());
                po.setAcceptStatus(Integer.valueOf(0));
            }
            this.applyShelvesFormMapper.updateByApplyId(po);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

