/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.UccExtSkuAddPriceService;
import com.tydic.commodity.estore.busi.bo.UccExtSkuAddPriceItmePO;
import com.tydic.commodity.estore.busi.bo.UccExtSkuAddPriceReqBO;
import com.tydic.commodity.estore.busi.bo.UccExtSkuAddPriceRspBO;
import com.tydic.commodity.estore.utils.ExcelUtils;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UccExtSkuAddPriceServiceImpl
implements UccExtSkuAddPriceService {
    private static final Logger log = LoggerFactory.getLogger(UccExtSkuAddPriceServiceImpl.class);
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    public static String importType = "UCC_EXTSKU_ADD_PRICE_IMPORT";

    @Override
    public UccExtSkuAddPriceRspBO dealExtSkuAddPriceImport(UccExtSkuAddPriceReqBO reqBO) {
        UccExtSkuAddPriceRspBO rspBO = new UccExtSkuAddPriceRspBO();
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            String dateString = DateUtils.dateToStrAsFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + dateString + "ccExtSkuAddPrice.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getImportUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateTitle(title);
        ArrayList<UccExtSkuAddPriceItmePO> uccExtSkuAddPriceItmePOS = new ArrayList<UccExtSkuAddPriceItmePO>();
        this.getItemImport(uccExtSkuAddPriceItmePOS, data);
        if (uccExtSkuAddPriceItmePOS.isEmpty()) {
            throw new BusinessException("8888", "\u6a21\u677f\u89e3\u6790\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS = new ArrayList<UccSkuAddCoefficientPO>();
        this.dealItemImport(uccSkuAddCoefficientPOS, uccExtSkuAddPriceItmePOS, reqBO);
        if (uccSkuAddCoefficientPOS.size() > 0) {
            this.uccSkuAddCoefficientMapper.batchInsert(uccSkuAddCoefficientPOS);
            ArrayList<UccSkuAddCoefficientLogPO> uccSkuAddCoefficientLogPOS = new ArrayList<UccSkuAddCoefficientLogPO>();
            for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
                UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
                BeanCopier beanCopier = BeanCopier.create(UccSkuAddCoefficientPO.class, UccSkuAddCoefficientLogPO.class, (boolean)false);
                beanCopier.copy((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO, null);
                uccSkuAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccSkuAddCoefficientLogPO.setSkuPriceId(uccSkuAddCoefficientPO.getSkuId());
                uccSkuAddCoefficientLogPO.setCreateTime(new Date());
                if (!ObjectUtils.isEmpty((Object)reqBO.getUserId())) {
                    uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUserId().toString());
                }
                uccSkuAddCoefficientLogPOS.add(uccSkuAddCoefficientLogPO);
            }
            this.uccSkuAddCoefficientLogMapper.batchInsert(uccSkuAddCoefficientLogPOS);
            try {
                List skuIds = uccSkuAddCoefficientPOS.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBo.setSkuIds(skuIds);
                syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBo);
            }
            catch (Exception e) {
                log.info("----------\u5355\u54c1\u52a0\u4ef7\u540c\u6b65ES\u62a5\u9519" + e);
            }
        }
        List<Map<String, Object>> exportData = this.exportImportResults(uccExtSkuAddPriceItmePOS);
        log.info("------\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString(exportData));
        Long sucessImportCounts = uccSkuAddCoefficientPOS.size();
        Long failedImportCounts = (long)uccExtSkuAddPriceItmePOS.size() - sucessImportCounts;
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(exportData, reqBO, sucessImportCounts, failedImportCounts);
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        rspBO.setImpType(importType);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, UccExtSkuAddPriceReqBO reqBO, Long sucessImportCounts, Long failedImportCounts) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType(importType);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    private List<Map<String, Object>> exportImportResults(List<UccExtSkuAddPriceItmePO> uccExtSkuAddPriceItmePOS) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (UccExtSkuAddPriceItmePO uccExtSkuAddPriceItmePO : uccExtSkuAddPriceItmePOS) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u5916\u90e8\u5355\u54c1\u7f16\u7801 *", uccExtSkuAddPriceItmePO.getExtSkuId() != null ? uccExtSkuAddPriceItmePO.getExtSkuId() : "");
            item.put("\u6765\u6e90\u7535\u5546 *", uccExtSkuAddPriceItmePO.getVendorName() != null ? uccExtSkuAddPriceItmePO.getVendorName() : "");
            item.put("\u52a0\u4ef7\u7cfb\u6570 \uff08%\uff09 *", uccExtSkuAddPriceItmePO.getSkuAddCoefficient() != null ? uccExtSkuAddPriceItmePO.getSkuAddCoefficient() : "");
            if (uccExtSkuAddPriceItmePO.getAllowMarketPrice() != null) {
                item.put("\u4e0a\u7ebf\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7  *", uccExtSkuAddPriceItmePO.getAllowMarketPrice() == 1 ? "\u662f" : "\u5426");
            }
            if (uccExtSkuAddPriceItmePO.getImpResult() != null && uccExtSkuAddPriceItmePO.getImpResult() == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (uccExtSkuAddPriceItmePO.getImpResult() != null && uccExtSkuAddPriceItmePO.getImpResult() == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", uccExtSkuAddPriceItmePO.getImpRemark());
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    public void dealItemImport(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, List<UccExtSkuAddPriceItmePO> uccExtSkuAddPriceItmePOS, UccExtSkuAddPriceReqBO reqBO) {
        List vendorList = this.uccDictionaryAtomService.queryBypCodeBackPo("ec_vendor_id");
        Map<String, DicDictionaryPo> collect = vendorList.stream().collect(Collectors.toMap(DicDictionaryPo::getTitle, a -> a, (k1, k2) -> k1));
        uccExtSkuAddPriceItmePOS.forEach(u -> {
            if (u.getImpResult() == 1) {
                return;
            }
            if (u.getExtSkuId() == null || "".equals(u.getExtSkuId())) {
                return;
            }
            DicDictionaryPo dicDictionaryPo = (DicDictionaryPo)collect.get(u.getVendorName());
            if (dicDictionaryPo == null) {
                u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\u6709\u8bef");
                u.setImpResult(1);
                return;
            }
            u.setVendorId(dicDictionaryPo.getCode());
            u.setImpResult(0);
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setExtSkuId(u.getExtSkuId());
            skuPo.setSupplierShopId(Long.valueOf(u.getVendorId()));
            List uccSkuPos = this.uccSkuMapper.qerySku(skuPo);
            log.info("\u6839\u636e\u5916\u90e8\u7f16\u7801\u548c\u4f9b\u5e94\u5546ID\u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)uccSkuPos));
            if (uccSkuPos == null || uccSkuPos.size() == 0) {
                u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u6b64\u5916\u90e8\u5355\u54c1\u7f16\u7801");
                u.setImpResult(1);
                return;
            }
            u.setImpResult(0);
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO1 = this.uccSkuAddCoefficientMapper.selectBySkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId());
            if (uccSkuAddCoefficientPO1 != null) {
                u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u6b64\u5355\u54c1\u5df2\u6dfb\u52a0\u52a0\u4ef7\u7cfb\u6570");
                u.setImpResult(1);
                return;
            }
            u.setImpResult(0);
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            BeanUtils.copyProperties(uccSkuPos.get(0), (Object)uccSkuAddCoefficientPO);
            uccSkuAddCoefficientPO.setAddCoefficient(u.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(u.getAllowMarketPrice());
            uccSkuAddCoefficientPO.setShopName(u.getVendorName());
            uccSkuAddCoefficientPO.setVendorId(Long.valueOf(u.getVendorId()));
            uccSkuAddCoefficientPO.setVendorName(u.getVendorName());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setCatelogId(((UccSkuPo)uccSkuPos.get(0)).getCommodityTypeId());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPOS.add(uccSkuAddCoefficientPO);
        });
    }

    List<UccExtSkuAddPriceItmePO> getItemImport(List<UccExtSkuAddPriceItmePO> uccExtSkuAddPriceItmePOS, JSONObject data) {
        JSONArray excelJSON = data.getJSONArray("excelJSON");
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            UccExtSkuAddPriceItmePO itemPO = new UccExtSkuAddPriceItmePO();
            JSONObject next = (JSONObject)iterator.next();
            itemPO.setExtSkuId(next.getString("\u5916\u90e8\u5355\u54c1\u7f16\u7801 *"));
            itemPO.setVendorName(next.getString("\u6765\u6e90\u7535\u5546 *"));
            itemPO.setSkuAddCoefficient(next.getBigDecimal("\u52a0\u4ef7\u7cfb\u6570 \uff08%\uff09 *"));
            String allowMarketPrice = next.getString("\u4e0a\u7ebf\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7  *");
            if (StringUtils.isBlank((CharSequence)allowMarketPrice)) {
                itemPO.setImpResult(1);
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u4e0a\u7ebf\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (allowMarketPrice.equals("\u662f")) {
                itemPO.setAllowMarketPrice(1);
                itemPO.setImpResult(0);
            } else if (allowMarketPrice.equals("\u5426")) {
                itemPO.setAllowMarketPrice(0);
                itemPO.setImpResult(0);
            } else {
                itemPO.setImpResult(1);
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u4e0a\u7ebf\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u8bf7\u8f93\u5165'\u662f'\u6216'\u5426'");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getExtSkuId())) {
                itemPO.setImpResult(1);
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5916\u90e8\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                itemPO.setImpResult(0);
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getVendorName())) {
                itemPO.setImpResult(1);
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u6765\u6e90\u7535\u5546\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                itemPO.setImpResult(0);
            }
            if (itemPO.getSkuAddCoefficient() == null || itemPO.getSkuAddCoefficient().compareTo(BigDecimal.ZERO) == 0) {
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u52a0\u4ef7\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                itemPO.setImpResult(1);
            } else {
                itemPO.setImpResult(0);
            }
            uccExtSkuAddPriceItmePOS.add(itemPO);
        }
        return uccExtSkuAddPriceItmePOS;
    }

    private void validateTitle(List<String> title) {
        String titleTemplate = "\u5916\u90e8\u5355\u54c1\u7f16\u7801 *|\u6765\u6e90\u7535\u5546 *|\u52a0\u4ef7\u7cfb\u6570 \uff08%\uff09 *|\u4e0a\u7ebf\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7  *|";
        String currentTitile = "";
        for (String s : title) {
            currentTitile = currentTitile + s.trim() + "|";
        }
        if (!titleTemplate.equals(currentTitile)) {
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(7);
            int rowLength = sheet.getLastRowNum();
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                title.add(cell.toString().trim());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 0; i <= rowLength && (row = sheet.getRow(i + 9)) != null; ++i) {
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)UccExtSkuAddPriceServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
            log.info("\u5bfc\u5165sku\u52a0\u4ef7\u8868\u5934" + JSON.toJSONString(title));
            log.info("\u5bfc\u5165sku\u52a0\u4ef7\u6570\u636e" + JSON.toJSONString((Object)jsonArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = new BigDecimal(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    @Autowired
    public void setSyncSceneCommodityToEsAtomService(SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService) {
        this.syncSceneCommodityToEsAtomService = syncSceneCommodityToEsAtomService;
    }
}

