/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.utils.BeanUtils;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.SkuDataGovernPropMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernRspBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernSkuInfo;
import com.tydic.commodity.estore.busi.api.UccSkuDataGovernBusiService;
import com.tydic.commodity.po.SkuDataGovernPO;
import com.tydic.commodity.po.SkuDataGovernPropPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuDataGovernBusiServiceImpl
implements UccSkuDataGovernBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuDataGovernBusiServiceImpl.class);
    private SkuDataGovernMapper skuDataGovernMapper;
    private SkuDataGovernPropMapper skuDataGovernPropMapper;
    private UccEMdmMaterialMapper uccMaterialMapper;
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @Override
    public SkuDataGovernRspBO dealSkuDataGovernReceive(SkuDataGovernReqBO reqBO) {
        List uccEMdmMaterialPOS;
        SkuDataGovernRspBO rspBO = new SkuDataGovernRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<Long> skuIds = reqBO.getSkuInfos().stream().map(e -> Long.valueOf(e.getSkuId())).distinct().collect(Collectors.toList());
        SkuDataGovernPropPO skuDataGovernPropPo = new SkuDataGovernPropPO();
        skuDataGovernPropPo.setSkuIds(skuIds);
        this.skuDataGovernPropMapper.deleteBy(skuDataGovernPropPo);
        ArrayList<SkuDataGovernPO> list = new ArrayList<SkuDataGovernPO>();
        ArrayList<Long> syncEsSkuIds = new ArrayList<Long>();
        ArrayList<String> wrongSkuIds = new ArrayList<String>();
        ArrayList propList = new ArrayList();
        ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        List materialCods = reqBO.getSkuInfos().stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterialCode())).map(a -> a.getMaterialCode()).distinct().collect(Collectors.toList());
        Map<Object, Object> materialPOMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialCods) && !CollectionUtils.isEmpty((Collection)(uccEMdmMaterialPOS = this.uccMaterialMapper.queryListByCodesPage(materialCods)))) {
            materialPOMap = uccEMdmMaterialPOS.stream().collect(Collectors.toMap(a -> a.getMaterialCode(), a -> a, (first, second) -> first));
        }
        List<Long> BrandCheckPassSkuIds = this.checkBrandResult(skuIds);
        for (SkuDataGovernSkuInfo skuInfo : reqBO.getSkuInfos()) {
            UccSkuPo uccSkuPo;
            if (skuInfo.getResult() == 1) {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(Long.valueOf(skuInfo.getSkuId()));
                if (CheckUtil.isBlank((Object)skuInfo.getMaterialStatus())) {
                    wrongSkuIds.add(skuInfo.getSkuId());
                    continue;
                }
                if (skuInfo.getMaterialStatus() == 1) {
                    if (CheckUtil.isNotBlank((String)skuInfo.getMaterialCode())) {
                        UccEMdmMaterialPO uccMdmMaterialPo = (UccEMdmMaterialPO)materialPOMap.get(skuInfo.getMaterialCode());
                        if (uccMdmMaterialPo != null) {
                            uccSkuPo.setMaterialId(uccMdmMaterialPo.getMaterialId().toString());
                            uccSkuPo.setMaterialName(uccMdmMaterialPo.getMaterialName());
                        }
                    } else {
                        uccSkuPo.setMaterialId("");
                        uccSkuPo.setMaterialName("");
                    }
                    uccSkuPo.setMaterialType(Integer.valueOf(2));
                }
                if (BrandCheckPassSkuIds.contains(uccSkuPo.getSkuId())) {
                    uccSkuPo.setSkuStatus(Integer.valueOf(2));
                } else {
                    uccSkuPo.setSkuStatus(Integer.valueOf(17));
                }
                this.uccSkuMapper.updateGovernInfo(uccSkuPo);
                syncEsSkuIds.add(Long.valueOf(skuInfo.getSkuId()));
            } else {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(Long.valueOf(skuInfo.getSkuId()));
                uccSkuPo.setSkuStatus(Integer.valueOf(6));
                this.uccSkuMapper.updateGovernInfo(uccSkuPo);
                UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                logRecordAbilityBO.setCreateOperId("\u6570\u636e\u6cbb\u7406");
                logRecordAbilityBO.setCreateTime(new Date());
                logRecordAbilityBO.setOperationType(Integer.valueOf(15));
                logRecordAbilityBO.setRemark("\u5931\u6548\uff08\u6570\u636e\u6cbb\u7406\u5ba1\u6279\u62d2\u7edd\uff09");
                recordAbilityBOS.add(logRecordAbilityBO);
            }
            SkuDataGovernPO skuDataGovernPo = new SkuDataGovernPO();
            skuDataGovernPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            skuDataGovernPo.setSkuId(Long.valueOf(skuInfo.getSkuId()));
            skuDataGovernPo.setResult(skuInfo.getResult());
            skuDataGovernPo.setRemark(skuInfo.getRemark());
            skuDataGovernPo.setMaterialStatus(Integer.valueOf(skuInfo.getMaterialStatus() == null ? 0 : skuInfo.getMaterialStatus()));
            skuDataGovernPo.setMaterialCode(skuInfo.getMaterialCode() == null ? "" : skuInfo.getMaterialCode());
            skuDataGovernPo.setCreateTime(new Date());
            skuDataGovernPo.setStatus(Integer.valueOf(1));
            list.add(skuDataGovernPo);
            if (CollectionUtils.isEmpty((Collection)skuInfo.getSpecs())) continue;
            propList.addAll(skuInfo.getSpecs().stream().map(e -> {
                SkuDataGovernPropPO skuDataGovernProp = new SkuDataGovernPropPO();
                BeanUtils.copyProperties((Object)e, (Object)skuDataGovernProp);
                skuDataGovernProp.setSkuId(Long.valueOf(skuInfo.getSkuId()));
                skuDataGovernProp.setCreateTime(new Date());
                return skuDataGovernProp;
            }).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
            UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
            skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
            this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
        }
        if (!CollectionUtils.isEmpty(propList)) {
            this.skuDataGovernPropMapper.insertBatch(propList);
            propList.clear();
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.skuDataGovernMapper.insertBatch(list);
        }
        if (syncEsSkuIds.size() > 0) {
            rspBO.setSkuIds(syncEsSkuIds);
        }
        if (wrongSkuIds.size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(String.join((CharSequence)",", wrongSkuIds) + "\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8d4b\u7801\u72b6\u6001\u4e3a\u7a7a\uff01");
        }
        return rspBO;
    }

    private List<Long> checkBrandResult(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> skuBrandSucces = new ArrayList<Long>();
        List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrandExt(skuIds);
        if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
            for (UccSkuBrandPo uccSkuBrandPo : uccSkuBrandPos) {
                if (uccSkuBrandPo.getBrandVerify() != null && uccSkuBrandPo.getBrandVerify() == 1) {
                    if (uccSkuBrandPo.getBrandId() == null || uccSkuBrandPo.getBrandStatus() == null || uccSkuBrandPo.getBrandStatus() != 1 || uccSkuBrandPo.getAppRange() == null || uccSkuBrandPo.getAppRange() == 2) continue;
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                    uccRelCatalogBrandVendorPO.setCatalogId(uccSkuBrandPo.getCatalogId());
                    uccRelCatalogBrandVendorPO.setBrandId(uccSkuBrandPo.getBrandId());
                    uccRelCatalogBrandVendorPO.setVendorId(uccSkuBrandPo.getSupplierShopId());
                    uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
                    List uccRelCatalogBrandVendorPOS = this.uccBrandDealMapper.getRelCatalogBrandVendor(uccRelCatalogBrandVendorPO);
                    if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS) || ((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() == null || ((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() != 1) continue;
                    skuBrandSucces.add(uccSkuBrandPo.getSkuId());
                    continue;
                }
                skuBrandSucces.add(uccSkuBrandPo.getSkuId());
            }
        }
        return skuBrandSucces;
    }

    @Autowired
    public void setSkuDataGovernMapper(SkuDataGovernMapper skuDataGovernMapper) {
        this.skuDataGovernMapper = skuDataGovernMapper;
    }

    @Autowired
    public void setSkuDataGovernPropMapper(SkuDataGovernPropMapper skuDataGovernPropMapper) {
        this.skuDataGovernPropMapper = skuDataGovernPropMapper;
    }

    @Autowired
    public void setUccMaterialMapper(UccEMdmMaterialMapper uccMaterialMapper) {
        this.uccMaterialMapper = uccMaterialMapper;
    }

    @Autowired
    public void setUccSkuMapper(UccSkuMapper uccSkuMapper) {
        this.uccSkuMapper = uccSkuMapper;
    }
}

