/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccRelCatalogVendorDiscountMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccTimeDealDiscountLimitAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccTimeDealDiscountLimitAbilityRspBo;
import com.tydic.commodity.estore.busi.api.UccTimeDealDiscountLimitBusiService;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccRelCatalogVendorDiscountPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccTimeDealDiscountLimitBusiServiceImpl
implements UccTimeDealDiscountLimitBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelCatalogVendorDiscountMapper uccRelCatalogVendorDiscountMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @Override
    public UccTimeDealDiscountLimitAbilityRspBo dealTimeDiscountLimit(UccTimeDealDiscountLimitAbilityReqBo reqBo) {
        UccTimeDealDiscountLimitAbilityRspBo rspBo = new UccTimeDealDiscountLimitAbilityRspBo();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            List skuIds = reqBo.getSkuIds();
            this.dealSku(skuIds);
        } else if (!CollectionUtils.isEmpty((Collection)reqBo.getCatalogIds())) {
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, 1000);
                List syncSkus = this.uccSkuMapper.getSkuBrandVerfy(reqBo.getCatalogIds(), page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (CollectionUtils.isEmpty((Collection)syncSkus)) continue;
                List<Long> skuIds = syncSkus.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                this.dealSku(skuIds);
            } while (++num <= total);
        } else {
            Calendar c = Calendar.getInstance();
            c.add(5, -reqBo.getDateNum().intValue());
            Date time = c.getTime();
            List uccRelCatalogVendorDiscountPOS = this.uccRelCatalogVendorDiscountMapper.qryModifyRecordsByTime(time, new Date());
            if (!CollectionUtils.isEmpty((Collection)uccRelCatalogVendorDiscountPOS)) {
                for (UccRelCatalogVendorDiscountPO uccRelCatalogVendorDiscountPO : uccRelCatalogVendorDiscountPOS) {
                    if (uccRelCatalogVendorDiscountPO.getCatalogId() == null || uccRelCatalogVendorDiscountPO.getVendorId() == null) continue;
                    int num = 1;
                    int total = 0;
                    do {
                        Page page = new Page(num, 1000);
                        List syncSkus = this.uccSkuMapper.getSkuBrandVerfyDetail(uccRelCatalogVendorDiscountPO.getCatalogId(), null, uccRelCatalogVendorDiscountPO.getVendorId(), page);
                        if (total == 0) {
                            total = page.getTotalPages();
                        }
                        if (CollectionUtils.isEmpty((Collection)syncSkus)) continue;
                        List skuIds = syncSkus.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                        this.dealSku(skuIds);
                    } while (++num <= total);
                }
            }
            UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
            uccRelCatalogBrandVendorPO.setUpdateTimeStart(time);
            uccRelCatalogBrandVendorPO.setUpdateTimeEnd(new Date());
            uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(1));
            List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
            ArrayList<UccRelCatalogBrandVendorPO> checkPoList = new ArrayList<UccRelCatalogBrandVendorPO>();
            if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                if (!CollectionUtils.isEmpty((Collection)uccRelCatalogVendorDiscountPOS)) {
                    for (UccRelCatalogBrandVendorPO relCatalogBrandVendorPO : uccRelCatalogBrandVendorPOS) {
                        boolean addFlag = true;
                        for (UccRelCatalogVendorDiscountPO uccRelCatalogVendorDiscountPO : uccRelCatalogVendorDiscountPOS) {
                            if (uccRelCatalogVendorDiscountPO.getCatalogId() == null || !uccRelCatalogVendorDiscountPO.getCatalogId().equals(relCatalogBrandVendorPO.getCatalogId()) || uccRelCatalogVendorDiscountPO.getVendorId() == null || !uccRelCatalogVendorDiscountPO.getVendorId().equals(relCatalogBrandVendorPO.getVendorId())) continue;
                            addFlag = false;
                            break;
                        }
                        if (!addFlag) continue;
                        checkPoList.add(relCatalogBrandVendorPO);
                    }
                } else {
                    checkPoList.addAll(uccRelCatalogBrandVendorPOS);
                }
            }
            if (!CollectionUtils.isEmpty(checkPoList)) {
                for (UccRelCatalogBrandVendorPO relCatalogBrandVendorPO : checkPoList) {
                    if (relCatalogBrandVendorPO.getCatalogId() == null || relCatalogBrandVendorPO.getVendorId() == null || relCatalogBrandVendorPO.getBrandId() == null) continue;
                    int num = 1;
                    int total = 0;
                    do {
                        Page page = new Page(num, 1000);
                        List syncSkus = this.uccSkuMapper.getSkuBrandVerfyDetail(relCatalogBrandVendorPO.getCatalogId(), relCatalogBrandVendorPO.getBrandId(), relCatalogBrandVendorPO.getVendorId(), page);
                        if (total == 0) {
                            total = page.getTotalPages();
                        }
                        if (CollectionUtils.isEmpty((Collection)syncSkus)) continue;
                        List<Long> skuIds = syncSkus.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
                        this.dealSku(skuIds);
                    } while (++num <= total);
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealSku(List<Long> skuIds) {
        if (!CollectionUtils.isEmpty(skuIds)) {
            List secondDiscountLimitSkuIds;
            ArrayList<Long> checkSecond = new ArrayList<Long>();
            List surpassDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSurpassDiscountLimitSku(skuIds);
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                skuIds.forEach(each -> {
                    if (!surpassDiscountLimitSkuIds.contains(each)) {
                        checkSecond.add((Long)each);
                    }
                });
            } else {
                checkSecond.addAll(skuIds);
            }
            if (!CollectionUtils.isEmpty(checkSecond) && !CollectionUtils.isEmpty((Collection)(secondDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSecondDiscountLimitSku(checkSecond)))) {
                surpassDiscountLimitSkuIds.addAll(secondDiscountLimitSkuIds);
            }
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(surpassDiscountLimitSkuIds, Integer.valueOf(1), Integer.valueOf(1));
                List notDiscountLimitSkuIds = skuIds.stream().filter(a -> !surpassDiscountLimitSkuIds.contains(a)).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(notDiscountLimitSkuIds)) {
                    this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(notDiscountLimitSkuIds, Integer.valueOf(0), Integer.valueOf(0));
                }
            } else {
                this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(skuIds, Integer.valueOf(0), Integer.valueOf(0));
            }
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_DISCOUNT_LIMIT);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
    }
}

