/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityRspBo;
import com.tydic.commodity.estore.atom.api.UccDealApprovalAtomService;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomRspBO;
import com.tydic.commodity.estore.busi.api.CceUccBrandApplyAuditBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CceUccBrandApplyAuditBusiServiceImpl
implements CceUccBrandApplyAuditBusiService {
    @Autowired
    private UccDealApprovalAtomService uccDealApprovalAtomService;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;

    @Override
    public CceUccBrandApplyAuditAbilityRspBo dealBrandApplyAudit(CceUccBrandApplyAuditAbilityReqBo reqBo) {
        CceUccBrandApplyAuditAbilityRspBo rspBo = new CceUccBrandApplyAuditAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u5355\u636e\u4e3b\u952eID");
            return rspBo;
        }
        if (reqBo.getAuditType() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u7ed3\u679c");
            return rspBo;
        }
        Map<Long, Boolean> finishMap = this.dealAudit(reqBo);
        this.dealMainInfo(reqBo, finishMap);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @DuplicateCommitLimit
    private Map<Long, Boolean> dealAudit(CceUccBrandApplyAuditAbilityReqBo reqBo) {
        HashMap<Long, Boolean> finishMap = new HashMap<Long, Boolean>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            UccDealApprovalAtomReqBO bo = new UccDealApprovalAtomReqBO();
            bo.setAuditAdvice(reqBo.getAuditAdvice());
            bo.setAuditResult(reqBo.getAuditType());
            bo.setUserId(reqBo.getUserId());
            bo.setUserName(reqBo.getName());
            bo.setObjType(1);
            bo.setOrgName(reqBo.getOrgName());
            for (Long id : reqBo.getIds()) {
                bo.setObjId(id);
                UccDealApprovalAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAtomService.dealApproval(bo);
                if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25\uff1a" + dealApprovalAtomRspBO.getRespDesc());
                }
                finishMap.put(id, dealApprovalAtomRspBO.getFinish());
            }
        }
        return finishMap;
    }

    private void dealMainInfo(CceUccBrandApplyAuditAbilityReqBo reqBo, Map<Long, Boolean> finishMap) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            if (reqBo.getAuditType() == 0) {
                List<Long> finistList = reqBo.getIds().stream().filter(a -> finishMap.containsKey(a) && (Boolean)finishMap.get(a) != false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(finistList)) {
                    BrandApplyPO set = new BrandApplyPO();
                    set.setAuditTime(new Date());
                    set.setAuditUserCode(reqBo.getOccupation());
                    set.setAuditUserName(reqBo.getName());
                    set.setApplyStatus(Integer.valueOf(5));
                    BrandApplyPO where = new BrandApplyPO();
                    where.setIds(finistList);
                    this.brandApplyMapper.updateBy(set, where);
                    this.syncRel(finistList, reqBo);
                }
            } else {
                BrandApplyPO set = new BrandApplyPO();
                set.setApplyStatus(Integer.valueOf(4));
                BrandApplyPO where = new BrandApplyPO();
                where.setIds(reqBo.getIds());
                this.brandApplyMapper.updateBy(set, where);
            }
        }
    }

    private void syncRel(List<Long> ids, CceUccBrandApplyAuditAbilityReqBo reqBo) {
        if (!CollectionUtils.isEmpty(ids)) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(ids);
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                for (BrandApplyPO applyPO : brandApplyPOS) {
                    if (applyPO.getBrandId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
                    }
                    if (applyPO.getVendorId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u4f9b\u5e94\u5546");
                    }
                    if (applyPO.getCatalogId() != null) continue;
                    throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u5206\u7c7b");
                }
                ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
                for (BrandApplyPO applyPO : brandApplyPOS) {
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                    uccRelCatalogBrandVendorPO.setVendorId(applyPO.getVendorId());
                    uccRelCatalogBrandVendorPO.setBrandId(applyPO.getBrandId());
                    uccRelCatalogBrandVendorPO.setCatalogId(applyPO.getCatalogId());
                    List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                    if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                        UccRelCatalogBrandVendorPO checkPo = (UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0);
                        UccRelCatalogBrandVendorPO set = new UccRelCatalogBrandVendorPO();
                        set.setDiscountFlag(Integer.valueOf(0));
                        set.setDiscount(applyPO.getDiscount());
                        set.setCreateOperId(reqBo.getOccupation());
                        set.setCreateOperName(reqBo.getName());
                        set.setCreateTime(new Date());
                        UccRelCatalogBrandVendorPO where = new UccRelCatalogBrandVendorPO();
                        where.setCatalogId(checkPo.getCatalogId());
                        where.setVendorId(checkPo.getVendorId());
                        where.setBrandId(checkPo.getBrandId());
                        this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                        continue;
                    }
                    Date date = new Date();
                    UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                    insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                    insertPo.setVendorId(applyPO.getVendorId());
                    insertPo.setBrandId(applyPO.getBrandId());
                    insertPo.setCatalogId(applyPO.getCatalogId());
                    insertPo.setStatus(Integer.valueOf(1));
                    insertPo.setCreateOperId(reqBo.getUsername() != null ? reqBo.getUsername() : "");
                    insertPo.setCreateOperName(reqBo.getName());
                    insertPo.setCreateTime(date);
                    insertPo.setUpdateOperId(reqBo.getUsername() != null ? reqBo.getUsername() : "");
                    insertPo.setUpdateOperName(reqBo.getName());
                    insertPo.setUpdateTime(date);
                    insertPo.setDiscountFlag(Integer.valueOf(0));
                    insertPo.setDiscount(applyPO.getDiscount());
                    insertList.add(insertPo);
                }
                if (!CollectionUtils.isEmpty(insertList)) {
                    this.uccRelCatalogBrandVendorMapper.insertBatch(insertList);
                }
            }
        }
    }
}

