/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.OtherAccessoryMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.api.CceUccBrandApplyDetailQryAbilityService;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyDetailQryAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyDetailQryAbilityRspBo;
import com.tydic.commodity.estore.ability.bo.CceUccOtherAccessoryBO;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.OtherAccessoryPO;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmCatalogQryListPO;
import com.tydic.commodity.po.UccVendorPo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.CceUccBrandApplyDetailQryAbilityService"})
public class CceUccBrandApplyDetailQryAbilityServiceImpl
implements CceUccBrandApplyDetailQryAbilityService {
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private OtherAccessoryMapper otherAccessoryMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @PostMapping(value={"qryBrandApplyDetail"})
    public CceUccBrandApplyDetailQryAbilityRspBo qryBrandApplyDetail(@RequestBody CceUccBrandApplyDetailQryAbilityReqBo reqBo) {
        CceUccBrandApplyDetailQryAbilityRspBo rspBo = new CceUccBrandApplyDetailQryAbilityRspBo();
        if (reqBo.getId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u4e3b\u952eID");
            return rspBo;
        }
        rspBo = this.getMainInfo(reqBo);
        this.getBrandInfo(rspBo);
        this.getVendorInfo(rspBo);
        this.getCatalogInfo(rspBo);
        this.translate(rspBo);
        this.getAccessoryInfo(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private CceUccBrandApplyDetailQryAbilityRspBo getMainInfo(CceUccBrandApplyDetailQryAbilityReqBo reqBo) {
        CceUccBrandApplyDetailQryAbilityRspBo rspBo = new CceUccBrandApplyDetailQryAbilityRspBo();
        BrandApplyPO brandApplyPO = new BrandApplyPO();
        brandApplyPO.setId(reqBo.getId());
        BrandApplyPO brandApplyInfo = this.brandApplyMapper.getModelBy(brandApplyPO);
        if (brandApplyInfo != null) {
            rspBo = (CceUccBrandApplyDetailQryAbilityRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)brandApplyInfo), CceUccBrandApplyDetailQryAbilityRspBo.class);
        }
        return rspBo;
    }

    private void getBrandInfo(CceUccBrandApplyDetailQryAbilityRspBo rspBo) {
        if (rspBo.getBrandId() != null) {
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(rspBo.getBrandId());
            UccBrandDealPO brandInfo = this.uccBrandDealMapper.selectById(uccBrandDealPO);
            if (brandInfo != null) {
                rspBo.setBrandName(brandInfo.getBrandName());
                rspBo.setBelongOrg(brandInfo.getBelongOrg());
            }
        }
    }

    private void getVendorInfo(CceUccBrandApplyDetailQryAbilityRspBo rspBo) {
        UccVendorPo uccVendorPo;
        if (rspBo.getVendorId() != null && (uccVendorPo = this.uccVendorMapper.queryVendorByVendorId(rspBo.getVendorId())) != null) {
            rspBo.setVendorName(uccVendorPo.getVendorName());
        }
    }

    private void getCatalogInfo(CceUccBrandApplyDetailQryAbilityRspBo rspBo) {
        if (rspBo.getCatalogId() != null) {
            UccEMdmCatalogQryListPO uccEMdmCatalogQryListPO1;
            UccEMdmCatalogQryListPO uccEMdmCatalogQryListPO = new UccEMdmCatalogQryListPO();
            uccEMdmCatalogQryListPO.setCatalogIdList3((List)Lists.newArrayList((Object[])new Long[]{rspBo.getCatalogId()}));
            List uccEMdmCatalogQryListPOS = this.uccEMdmCatalogMapper.qryCatalogWelfare(uccEMdmCatalogQryListPO);
            Map<Object, Object> catalogMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogQryListPOS)) {
                catalogMap = uccEMdmCatalogQryListPOS.stream().filter(a -> a.getCatalogId3() != null).collect(Collectors.toMap(a -> a.getCatalogId3(), a -> a, (first, secod) -> first));
            }
            if ((uccEMdmCatalogQryListPO1 = (UccEMdmCatalogQryListPO)catalogMap.get("" + rspBo.getCatalogId())) != null) {
                String catalogName = uccEMdmCatalogQryListPO1.getCatalogName1() + "/" + uccEMdmCatalogQryListPO1.getCatalogName2() + "/" + uccEMdmCatalogQryListPO1.getCatalogName3();
                rspBo.setCatalogName(catalogName);
                rspBo.setCatalogCode(uccEMdmCatalogQryListPO1.getCatalogCode3());
            }
        }
    }

    private void translate(CceUccBrandApplyDetailQryAbilityRspBo rspBo) {
        DicDictionaryPo dicDictionaryPo;
        if (rspBo.getApplyStatus() != null && (dicDictionaryPo = this.uccBaseDictionaryAtomService.queryByCodeAndPcode("" + rspBo.getApplyStatus(), "BRAND_APPLY_STATUS")) != null) {
            rspBo.setApplyStatusStr(dicDictionaryPo.getTitle());
        }
        if (rspBo.getSource() != null && (dicDictionaryPo = this.uccBaseDictionaryAtomService.queryByCodeAndPcode("" + rspBo.getSource(), "BRAND_APPLY_SOURCE")) != null) {
            rspBo.setSourceStr(dicDictionaryPo.getTitle());
        }
        if (rspBo.getConfirmResult() != null) {
            rspBo.setConfirmResultStr(rspBo.getConfirmResult() == 0 ? "\u62d2\u7edd" : "\u901a\u8fc7");
        }
    }

    private void getAccessoryInfo(CceUccBrandApplyDetailQryAbilityRspBo rspBo) {
        if (rspBo.getId() != null) {
            OtherAccessoryPO otherAccessoryPO = new OtherAccessoryPO();
            otherAccessoryPO.setRelId(rspBo.getId());
            List otherAccessoryPOS = this.otherAccessoryMapper.getList(otherAccessoryPO);
            if (!CollectionUtils.isEmpty((Collection)otherAccessoryPOS)) {
                rspBo.setAccessoryInfo(JSONObject.parseArray((String)JSONObject.toJSONString((Object)otherAccessoryPOS), CceUccOtherAccessoryBO.class));
            }
        }
    }
}

