/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.OtherAccessoryMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityRspBo;
import com.tydic.commodity.estore.busi.api.CceUccCreateBrandApplyBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.OtherAccessoryPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccVendorPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CceUccCreateBrandApplyBusiServiceImpl
implements CceUccCreateBrandApplyBusiService {
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private OtherAccessoryMapper otherAccessoryMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;

    @Override
    public CceUccCreateBrandApplyAbilityRspBo createBrandApply(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        CceUccCreateBrandApplyAbilityRspBo rspBo = new CceUccCreateBrandApplyAbilityRspBo();
        String checkMsg = this.checkReq(reqBo);
        if (!StringUtils.isEmpty((Object)checkMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(checkMsg);
            return rspBo;
        }
        if (reqBo.getBrandApplyOperType() == 3 && reqBo.getConfirmResult() == 1) {
            String stepId = this.startAudit(reqBo);
            reqBo.setExtField2(stepId);
        }
        if (reqBo.getBrandApplyOperType() == 6) {
            this.syncRel(reqBo.getIds(), reqBo);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        this.dealMainInfo(reqBo);
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2 || reqBo.getBrandApplyOperType() == 3) {
            this.dealAccessory(reqBo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealMainInfo(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        BrandApplyPO brandApplyPO = new BrandApplyPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)brandApplyPO);
        if (reqBo.getBrandApplyOperType() == 1) {
            BrandApplyPO checkDupPo = new BrandApplyPO();
            checkDupPo.setApplyCode(reqBo.getApplyCode());
            List checkDupList = this.brandApplyMapper.getList(checkDupPo);
            if (!CollectionUtils.isEmpty((Collection)checkDupList)) {
                throw new ZTBusinessException("\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
            }
            brandApplyPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            reqBo.setId(brandApplyPO.getId());
            if ("0".equals(reqBo.getIsprofess())) {
                brandApplyPO.setSource(Integer.valueOf(1));
                brandApplyPO.setCreateUserCode(reqBo.getOccupation());
                brandApplyPO.setCreateUserName(reqBo.getName());
            } else {
                brandApplyPO.setSource(Integer.valueOf(0));
                if (reqBo.getSupId() != null) {
                    UccVendorPo uccVendorPo = this.uccVendorMapper.queryVendorByVendorId(reqBo.getSupId());
                    if (uccVendorPo != null) {
                        brandApplyPO.setCreateUserCode(uccVendorPo.getSupplierCode());
                        brandApplyPO.setCreateUserName(uccVendorPo.getVendorName());
                    }
                } else {
                    throw new ZTBusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef");
                }
            }
            brandApplyPO.setCreateUserId("" + reqBo.getUserId());
            brandApplyPO.setCreateCompanyId("" + reqBo.getOrgId());
            brandApplyPO.setCreateCompanyCode(reqBo.getOrgCodeIn());
            brandApplyPO.setCreateCompanyName(reqBo.getOrgName());
            brandApplyPO.setCreateTime(new Date());
        } else if (reqBo.getBrandApplyOperType() == 3) {
            brandApplyPO.setConfirmUserCode(reqBo.getOccupation());
            brandApplyPO.setConfirmUserName(reqBo.getName());
            brandApplyPO.setConfirmTime(new Date());
            if (StringUtils.isEmpty((Object)reqBo.getConfirmRemark())) {
                reqBo.setConfirmRemark(" ");
            }
        }
        brandApplyPO.setUpdateUserId("" + reqBo.getUserId());
        brandApplyPO.setUpdateUserCode(reqBo.getOccupation());
        brandApplyPO.setUpdateUserName(reqBo.getName());
        brandApplyPO.setUpdateTime(new Date());
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2) {
            if (reqBo.getSaveOrSubmit() == 1 && reqBo.getBrandApplyOperType() == 1) {
                brandApplyPO.setApplyStatus(Integer.valueOf(0));
            } else if (reqBo.getSaveOrSubmit() == 2) {
                brandApplyPO.setApplyStatus(Integer.valueOf(1));
            }
        } else if (reqBo.getBrandApplyOperType() == 3) {
            if (reqBo.getConfirmResult() == 1) {
                brandApplyPO.setApplyStatus(Integer.valueOf(3));
            } else {
                brandApplyPO.setApplyStatus(Integer.valueOf(2));
            }
        } else if (reqBo.getBrandApplyOperType() == 4) {
            brandApplyPO.setApplyStatus(Integer.valueOf(6));
        } else if (reqBo.getBrandApplyOperType() == 5) {
            brandApplyPO.setApplyStatus(Integer.valueOf(7));
        }
        if (reqBo.getBrandApplyOperType() == 1) {
            this.brandApplyMapper.insert(brandApplyPO);
        } else {
            BrandApplyPO where = new BrandApplyPO();
            where.setId(reqBo.getId());
            if (where.getId() == null) {
                throw new ZTBusinessException("\u672a\u4f20\u5165\u4e3b\u952eID");
            }
            this.brandApplyMapper.updateBy(brandApplyPO, where);
        }
    }

    private void dealAccessory(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        if (reqBo.getId() != null) {
            OtherAccessoryPO otherAccessoryPO = new OtherAccessoryPO();
            otherAccessoryPO.setRelId(reqBo.getId());
            this.otherAccessoryMapper.deleteBy(otherAccessoryPO);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getAccessoryInfo())) {
                List insertAccessoryList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBo.getAccessoryInfo()), OtherAccessoryPO.class);
                insertAccessoryList.forEach(each -> {
                    each.setRelId(reqBo.getId());
                    each.setId(Long.valueOf(Sequence.getInstance().nextId()));
                });
                this.otherAccessoryMapper.insertBatch(insertAccessoryList);
            }
        }
    }

    @DuplicateCommitLimit
    private String startAudit(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        UccApproveCreationAtomReqBO uccApproveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
        uccApproveCreationAtomReqBO.setOrgIdIn(reqBo.getOrgId());
        uccApproveCreationAtomReqBO.setAuditAdvice("\u53d1\u8d77\u5ba1\u6279");
        uccApproveCreationAtomReqBO.setProcDefKey(reqBo.getProcDefKey());
        uccApproveCreationAtomReqBO.setOrderId(reqBo.getId());
        uccApproveCreationAtomReqBO.setObjType(Integer.valueOf(1));
        uccApproveCreationAtomReqBO.setObjId((List)Lists.newArrayList((Object[])new Long[]{reqBo.getId()}));
        uccApproveCreationAtomReqBO.setUserId(reqBo.getUserId());
        uccApproveCreationAtomReqBO.setOrgId(reqBo.getOrgId());
        uccApproveCreationAtomReqBO.setName(reqBo.getName());
        uccApproveCreationAtomReqBO.setOrgName(reqBo.getOrgName());
        uccApproveCreationAtomReqBO.setCheckOnAudit(Boolean.valueOf(true));
        UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(uccApproveCreationAtomReqBO);
        if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(uccApproveCreationAtomRspBO.getRespDesc());
        }
        if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue()) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u5ba1\u6279\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)uccApproveCreationAtomRspBO.getStepId())) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u4e0b\u4e00\u6b65\u9aa4\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
        }
        return uccApproveCreationAtomRspBO.getStepId();
    }

    private String checkReq(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        String msg = "";
        if (reqBo.getBrandApplyOperType() == null) {
            msg = "\u8bf7\u4f20\u5165\u64cd\u4f5c\u7c7b\u578b";
            return msg;
        }
        if (reqBo.getBrandApplyOperType() != 1 && reqBo.getId() == null && CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            msg = "\u8bf7\u4f20\u5165\u54c1\u724c\u7533\u8bf7\u4e3b\u952eID";
            return msg;
        }
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2) {
            if (reqBo.getSaveOrSubmit() == null) {
                msg = "\u8bf7\u4f20\u5165\u64cd\u4f5c\u662f\u4fdd\u5b58\u8fd8\u662f\u63d0\u4ea4";
                return msg;
            }
            if (reqBo.getBrandApplyOperType() == 1 && StringUtils.isEmpty((Object)reqBo.getApplyCode())) {
                msg = "\u8bf7\u4f20\u5165\u7533\u8bf7\u7f16\u7801";
                return msg;
            }
            if (reqBo.getBrandId() == null) {
                msg = "\u8bf7\u9009\u62e9\u54c1\u724c";
                return msg;
            }
            if (reqBo.getBrandId() == -1L) {
                if (StringUtils.isEmpty((Object)reqBo.getBrandRemark())) {
                    msg = "\u8bf7\u586b\u5199\u54c1\u724c\u5907\u6ce8";
                    return msg;
                }
                if (StringUtils.isEmpty((Object)reqBo.getBelongOrg())) {
                    msg = "\u8bf7\u586b\u5199\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a";
                    return msg;
                }
            }
            if (reqBo.getVendorId() == null) {
                msg = "\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546";
                return msg;
            }
            if (reqBo.getCatalogId() == null) {
                msg = "\u8bf7\u9009\u62e9\u5206\u7c7b";
                return msg;
            }
            if (reqBo.getDiscount() == null) {
                msg = "\u8bf7\u586b\u5199\u6298\u6263\u7387\u6700\u5927\u9650\u503c";
                return msg;
            }
        }
        if (reqBo.getBrandApplyOperType() == 3) {
            if (reqBo.getConfirmResult() == null) {
                msg = "\u8bf7\u4f20\u5165\u786e\u8ba4\u7ed3\u679c";
                return msg;
            }
            if (reqBo.getConfirmResult() == 1) {
                if (StringUtils.isEmpty((Object)reqBo.getProcDefKey())) {
                    msg = "\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49Key";
                    return msg;
                }
            } else if (StringUtils.isEmpty((Object)reqBo.getConfirmRemark())) {
                msg = "\u8bf7\u586b\u5199\u786e\u8ba4\u610f\u89c1\uff01";
                return msg;
            }
        }
        return msg;
    }

    private void syncRel(List<Long> ids, CceUccCreateBrandApplyAbilityReqBo reqBo) {
        if (!CollectionUtils.isEmpty(ids)) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(ids);
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                HashMap<String, Date> checkDup = new HashMap<String, Date>();
                for (Object applyPO : brandApplyPOS) {
                    if (applyPO.getBrandId() == null || applyPO.getBrandId() == -1L) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
                    }
                    if (applyPO.getVendorId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u4f9b\u5e94\u5546");
                    }
                    if (applyPO.getCatalogId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u5206\u7c7b");
                    }
                    if (applyPO.getConfirmTime() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u6ca1\u6709\u901a\u8fc7\u8fd0\u8425\u786e\u8ba4\uff0c\u8bf7\u6838\u67e5\u6570\u636e");
                    }
                    if (checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())) {
                        if (applyPO.getConfirmTime().getTime() <= ((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).getTime()) continue;
                        checkDup.replace("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                        continue;
                    }
                    checkDup.put("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                }
                ArrayList<BrandApplyPO> syncList = new ArrayList<BrandApplyPO>();
                for (BrandApplyPO applyPO : brandApplyPOS) {
                    if (!checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId()) || !((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).equals(applyPO.getConfirmTime())) continue;
                    syncList.add(applyPO);
                }
                if (!CollectionUtils.isEmpty(syncList)) {
                    ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
                    for (BrandApplyPO applyPO : syncList) {
                        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                        uccRelCatalogBrandVendorPO.setVendorId(applyPO.getVendorId());
                        uccRelCatalogBrandVendorPO.setBrandId(applyPO.getBrandId());
                        uccRelCatalogBrandVendorPO.setCatalogId(applyPO.getCatalogId());
                        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                        if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                            UccRelCatalogBrandVendorPO checkPo = (UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0);
                            UccRelCatalogBrandVendorPO set = new UccRelCatalogBrandVendorPO();
                            set.setDiscountFlag(Integer.valueOf(0));
                            set.setDiscount(applyPO.getDiscount());
                            set.setCreateOperId(applyPO.getConfirmUserCode());
                            set.setCreateOperName(applyPO.getConfirmUserName());
                            set.setCreateTime(new Date());
                            set.setUpdateOperId(applyPO.getConfirmUserCode());
                            set.setUpdateOperName(applyPO.getConfirmUserName());
                            set.setUpdateTime(new Date());
                            set.setBrandApplyId(applyPO.getId());
                            set.setApplyCode(applyPO.getApplyCode());
                            UccRelCatalogBrandVendorPO where = new UccRelCatalogBrandVendorPO();
                            where.setCatalogId(checkPo.getCatalogId());
                            where.setVendorId(checkPo.getVendorId());
                            where.setBrandId(checkPo.getBrandId());
                            this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                            continue;
                        }
                        UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                        insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        insertPo.setVendorId(applyPO.getVendorId());
                        insertPo.setBrandId(applyPO.getBrandId());
                        insertPo.setCatalogId(applyPO.getCatalogId());
                        insertPo.setStatus(Integer.valueOf(1));
                        insertPo.setCreateOperId(applyPO.getConfirmUserCode());
                        insertPo.setCreateOperName(applyPO.getConfirmUserName());
                        insertPo.setCreateTime(new Date());
                        insertPo.setUpdateOperId(applyPO.getConfirmUserCode());
                        insertPo.setUpdateOperName(applyPO.getConfirmUserName());
                        insertPo.setUpdateTime(new Date());
                        insertPo.setDiscountFlag(Integer.valueOf(0));
                        insertPo.setDiscount(applyPO.getDiscount());
                        insertPo.setBrandApplyId(applyPO.getId());
                        insertPo.setApplyCode(applyPO.getApplyCode());
                        insertList.add(insertPo);
                    }
                    if (!CollectionUtils.isEmpty(insertList)) {
                        this.uccRelCatalogBrandVendorMapper.insertBatch(insertList);
                    }
                }
            }
        }
    }
}

