/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl.mq.consumer;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSendNotificationExtAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.dao.ApplyShelvesFormItemMapper;
import com.tydic.commodity.dao.ApplyShelvesFormItemSkuMapper;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.dao.ApplyShelvesFormVendorMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesFormAcceptItemQryListBO;
import com.tydic.commodity.po.ApplyShelvesFormItemPO;
import com.tydic.commodity.po.ApplyShelvesFormItemSkuPO;
import com.tydic.commodity.po.ApplyShelvesFormPO;
import com.tydic.commodity.po.ApplyShelvesFormVendorPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UocApprovalObjPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UccSendNotificationServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccSendNotificationServiceConsumer.class);
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UccSendNotificationExtAtomService uccSendNotificationExtAtomService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private ApplyShelvesFormVendorMapper applyShelvesFormVendorMapper;
    @Autowired
    private ApplyShelvesFormItemMapper applyShelvesFormItemMapper;
    @Autowired
    private ApplyShelvesFormItemSkuMapper applyShelvesFormItemSkuMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.debug("\u5546\u54c1\u53d1\u9001\u901a\u77e5\u5f85\u529e\u6d88\u8d39\u8005\u5165\u53c2\uff1a" + message.getContent());
        try {
            UccSendNotificationExtAtomReqBO reqBO = (UccSendNotificationExtAtomReqBO)JSONObject.parseObject((String)message.getContent(), UccSendNotificationExtAtomReqBO.class);
            if (reqBO.getIsDealApplyShelvesFormFeedBack() != null && reqBO.getIsDealApplyShelvesFormFeedBack() == 1) {
                try {
                    if (reqBO.getOperUserId() == null) {
                        reqBO.setOperUserId(Long.valueOf(1L));
                    }
                    if (reqBO.getApplyId() != null) {
                        ApplyShelvesFormPO queryFormReqBO = new ApplyShelvesFormPO();
                        queryFormReqBO.setApplyId(reqBO.getApplyId());
                        ApplyShelvesFormPO queryApplyShelvesFormBO = this.applyShelvesFormMapper.getModelBy(queryFormReqBO);
                        String applyCode = queryApplyShelvesFormBO.getApplyCode();
                        if (reqBO.getFeedBackType() == 1) {
                            List rows = new ArrayList();
                            ApplyShelvesFormItemPO applyShelvesFormItemPO = new ApplyShelvesFormItemPO();
                            applyShelvesFormItemPO.setApplyId(reqBO.getApplyId());
                            Page page = new Page(-1, -1);
                            List applyShelvesFormItemPOS = this.applyShelvesFormItemMapper.getListPage(applyShelvesFormItemPO, page);
                            if (!CollectionUtils.isEmpty((Collection)applyShelvesFormItemPOS)) {
                                Set vendorNameSet;
                                rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)applyShelvesFormItemPOS), UccApplyShelvesFormAcceptItemQryListBO.class);
                                List items = rows.stream().map(a -> a.getApplyItemId()).collect(Collectors.toList());
                                ApplyShelvesFormItemSkuPO applyShelvesFormItemSkuPO = new ApplyShelvesFormItemSkuPO();
                                applyShelvesFormItemSkuPO.setApplyItemIds(items);
                                applyShelvesFormItemSkuPO.setType(Integer.valueOf(0));
                                List applyShelvesFormItemSkuPOS = this.applyShelvesFormItemSkuMapper.getList(applyShelvesFormItemSkuPO);
                                if (!CollectionUtils.isEmpty((Collection)applyShelvesFormItemSkuPOS) && !CollectionUtils.isEmpty(vendorNameSet = applyShelvesFormItemSkuPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getVendorName())).map(ApplyShelvesFormItemSkuPO::getVendorName).collect(Collectors.toSet()))) {
                                    for (String vendorName : vendorNameSet) {
                                        String titel = applyCode + "\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6_" + vendorName + "\u5df2\u53cd\u9988";
                                        String text = "\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7" + applyCode + "\u5df2\u6709\u53cd\u9988\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002";
                                        ArrayList<Long> userIds = new ArrayList<Long>();
                                        if (StringUtils.isEmpty((Object)queryApplyShelvesFormBO.getCreateUserId())) continue;
                                        userIds.add(Long.valueOf(queryApplyShelvesFormBO.getCreateUserId()));
                                        this.sendNotification(text, titel, userIds, reqBO.getOperUserId());
                                    }
                                }
                            }
                        } else if (reqBO.getFeedBackType() == 2) {
                            ApplyShelvesFormVendorPO queryVendor = new ApplyShelvesFormVendorPO();
                            queryVendor.setApplyId(reqBO.getApplyId());
                            queryVendor.setType(Integer.valueOf(1));
                            queryVendor.setVendorId(reqBO.getVendorId());
                            List applyShelvesFormVendorPushRspBO = this.applyShelvesFormVendorMapper.getList(queryVendor);
                            if (!CollectionUtils.isEmpty((Collection)applyShelvesFormVendorPushRspBO)) {
                                for (ApplyShelvesFormVendorPO applyShelvesFormVendorPO : applyShelvesFormVendorPushRspBO) {
                                    if (StringUtils.isEmpty((Object)applyShelvesFormVendorPO.getCreateUserId())) continue;
                                    String titel = applyCode + "\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6_" + applyShelvesFormVendorPO.getVendorName() + "\u5df2\u53cd\u9988";
                                    String text = "\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u63d0\u4ea4\u7684\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7" + applyCode + "\u5df2\u6709\u53cd\u9988\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002";
                                    ArrayList<Long> userIds = new ArrayList<Long>();
                                    if (StringUtils.isEmpty((Object)applyShelvesFormVendorPO.getCreateUserId())) continue;
                                    userIds.add(Long.valueOf(applyShelvesFormVendorPO.getCreateUserId()));
                                    this.sendNotification(text, titel, userIds, reqBO.getOperUserId());
                                }
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    log.error("\u5904\u7406\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u5f85\u529e\u6d88\u606f\u5f02\u5e38" + e2.getMessage());
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (reqBO.getFinish().booleanValue()) {
                if (0 != reqBO.getAuditResult()) {
                    String oper = null;
                    if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(reqBO.getObjType())) {
                        oper = "\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de";
                        this.dealEcomCommodityReject(reqBO, oper);
                    } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(reqBO.getObjType())) {
                        oper = "\u4e0b\u67b6\u5ba1\u6279\u9a73\u56de";
                        this.dealEcomCommodityReject(reqBO, oper);
                    } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER.equals(reqBO.getObjType())) {
                        oper = "\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u9a73\u56de";
                        this.dealEcomCommodityReject(reqBO, oper);
                    } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT.equals(reqBO.getObjType())) {
                        this.dealXyCommodityReject(reqBO);
                    }
                }
            } else {
                String oper = null;
                if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(reqBO.getObjType())) {
                    oper = "\u4e0a\u67b6\u5f85\u5ba1\u6279";
                    this.dealEcomCommodityUp(reqBO, oper);
                } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(reqBO.getObjType())) {
                    oper = "\u4e0b\u67b6\u5f85\u5ba1\u6279";
                    this.dealEcomCommodityUp(reqBO, oper);
                } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER.equals(reqBO.getObjType())) {
                    oper = "\u6062\u590d\u4e0a\u67b6\u5f85\u5ba1\u6279";
                    this.dealEcomCommodityUp(reqBO, oper);
                } else if (ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT.equals(reqBO.getObjType())) {
                    this.dealXyCommodityUpdate(reqBO);
                }
            }
        }
        catch (Exception e3) {
            log.error("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u6d88\u8d39\u5931\u8d25\uff01" + e3);
            e3.printStackTrace();
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void dealEcomCommodityReject(UccSendNotificationExtAtomReqBO reqBO, String oper) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjIds())) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), "\u5165\u53c2[objIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List skuList = this.uccSkuMapper.qryBySkuIds(reqBO.getObjIds());
        List spuList = skuList.stream().map(UccSkuPo::getCommodityId).filter(Objects::nonNull).collect(Collectors.toList());
        Map commodityPoMap = null;
        if (!CollectionUtils.isEmpty(spuList)) {
            List commodityPoList = this.uccCommodityMapper.qeryBatchCommdity(spuList);
            commodityPoMap = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, Function.identity(), (e1, e2) -> e1));
        }
        Map<Long, UocApprovalObjPO> objPOMap = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAuditOrderIds())) {
            objPOMap = reqBO.getAuditOrderIds().stream().filter(Objects::nonNull).collect(Collectors.toMap(UocApprovalObjPO::getObjId, Function.identity(), (e1, e2) -> e1));
        }
        for (UccSkuPo uccSkuPo : skuList) {
            reqBO.setObjId(uccSkuPo.getSkuId());
            if (null == commodityPoMap) continue;
            UccCommodityPo po = (UccCommodityPo)commodityPoMap.get(uccSkuPo.getCommodityId());
            if (ObjectUtils.isEmpty((Object)uccSkuPo.getSkuSource())) {
                return;
            }
            if (null == po) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)uccSkuPo.getCreateOperId())) continue;
            String tittle = this.getTittle(uccSkuPo, po);
            log.debug("title{}", (Object)tittle);
            ArrayList<Long> receives = new ArrayList<Long>();
            receives.add(this.qryRejectReceiveIds(reqBO, objPOMap));
            if (StringUtils.isEmpty((Object)tittle)) continue;
            reqBO.setTitel(tittle + uccSkuPo.getSkuCode() + "_" + uccSkuPo.getSkuName() + oper);
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709" + tittle + uccSkuPo.getSkuCode() + oper + "\u3002");
            reqBO.setReceiveIds(receives);
            this.uccSendNotificationExtAtomService.sendNotification(reqBO);
        }
    }

    private void sendNotification(String text, String titel, List<Long> receiveIds, Long userId) {
        UccSendNotificationExtAtomReqBO extAtomReqBO = new UccSendNotificationExtAtomReqBO();
        extAtomReqBO.setText(text);
        extAtomReqBO.setReceiveIds(receiveIds);
        extAtomReqBO.setTitel(titel);
        extAtomReqBO.setUserId(userId);
        this.uccSendNotificationExtAtomService.sendNotification(extAtomReqBO);
    }

    private void dealEcomCommodityUp(UccSendNotificationExtAtomReqBO reqBO, String oper) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjIds())) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), "\u5165\u53c2[objIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List skuList = this.uccSkuMapper.qryBySkuIds(reqBO.getObjIds());
        List spuList = skuList.stream().map(UccSkuPo::getCommodityId).filter(Objects::nonNull).collect(Collectors.toList());
        Map commodityPoMap = null;
        if (!CollectionUtils.isEmpty(spuList)) {
            List commodityPoList = this.uccCommodityMapper.qeryBatchCommdity(spuList);
            commodityPoMap = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, Function.identity(), (e1, e2) -> e1));
        }
        for (UccSkuPo uccSkuPo : skuList) {
            String tittle;
            reqBO.setObjId(uccSkuPo.getSkuId());
            List<Long> receiveIds = this.qryReceiveIds(reqBO);
            if (null == commodityPoMap) continue;
            UccCommodityPo po = (UccCommodityPo)commodityPoMap.get(uccSkuPo.getCommodityId());
            if (ObjectUtils.isEmpty((Object)uccSkuPo.getSkuSource())) {
                return;
            }
            if (null == po) {
                return;
            }
            if (CollectionUtils.isEmpty(receiveIds) || StringUtils.isEmpty((Object)(tittle = this.getTittle(uccSkuPo, po)))) continue;
            reqBO.setTitel(tittle + uccSkuPo.getSkuCode() + "_" + uccSkuPo.getSkuName() + oper);
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709" + tittle + uccSkuPo.getSkuCode() + oper + "\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            this.uccSendNotificationExtAtomService.sendNotification(reqBO);
        }
    }

    private void dealXyCommodityReject(UccSendNotificationExtAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjIds())) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), "\u5165\u53c2[objIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List skuList = this.uccCommodityMapper.qeryBatchCommdity(reqBO.getObjIds());
        Map<Long, UocApprovalObjPO> objPOMap = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAuditOrderIds())) {
            objPOMap = reqBO.getAuditOrderIds().stream().filter(Objects::nonNull).collect(Collectors.toMap(UocApprovalObjPO::getObjId, Function.identity(), (e1, e2) -> e1));
        }
        for (UccCommodityPo po : skuList) {
            reqBO.setObjId(po.getCommodityId());
            ArrayList<Long> receiveIds = new ArrayList<Long>();
            receiveIds.add(this.qryRejectReceiveIds(reqBO, objPOMap));
            if (CollectionUtils.isEmpty(receiveIds)) continue;
            if (!ObjectUtils.isEmpty((Object)po.getCommoditySource()) && 3 == po.getCommoditySource()) {
                if (!ObjectUtils.isEmpty((Object)po.getIsSupermarketStaff()) && 1 == po.getIsSupermarketStaff()) {
                    reqBO.setTitel("\u5458\u5de5\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de");
                    reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5458\u5de5\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de\u3002");
                    reqBO.setReceiveIds(receiveIds);
                    this.uccSendNotificationExtAtomService.sendNotification(reqBO);
                    continue;
                }
                reqBO.setTitel("\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de");
                reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de\u3002");
                reqBO.setReceiveIds(receiveIds);
                this.uccSendNotificationExtAtomService.sendNotification(reqBO);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)po.getCommoditySource()) || 1 != po.getCommoditySource()) continue;
            reqBO.setTitel("\u65e0\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u65e0\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5ba1\u6279\u9a73\u56de\u3002");
            reqBO.setReceiveIds(receiveIds);
            this.uccSendNotificationExtAtomService.sendNotification(reqBO);
        }
    }

    private void dealXyCommodityUpdate(UccSendNotificationExtAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjIds())) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), "\u5165\u53c2[objIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List skuList = this.uccCommodityMapper.qeryBatchCommdity(reqBO.getObjIds());
        for (UccCommodityPo po : skuList) {
            reqBO.setObjId(po.getCommodityId());
            List<Long> receiveIds = this.qryReceiveIds(reqBO);
            if (CollectionUtils.isEmpty(receiveIds)) continue;
            if (!ObjectUtils.isEmpty((Object)po.getCommoditySource()) && 3 == po.getCommoditySource()) {
                if (!ObjectUtils.isEmpty((Object)po.getIsSupermarketStaff()) && 1 == po.getIsSupermarketStaff()) {
                    reqBO.setTitel("\u5458\u5de5\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5f85\u5ba1\u6279");
                    reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5458\u5de5\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    reqBO.setReceiveIds(receiveIds);
                    this.uccSendNotificationExtAtomService.sendNotification(reqBO);
                    continue;
                }
                reqBO.setTitel("\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5f85\u5ba1\u6279");
                reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                reqBO.setReceiveIds(receiveIds);
                this.uccSendNotificationExtAtomService.sendNotification(reqBO);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)po.getCommoditySource()) || 1 != po.getCommoditySource()) continue;
            reqBO.setTitel("\u65e0\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "_" + po.getCommodityName() + "\u7f16\u8f91\u5f85\u5ba1\u6279");
            reqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u65e0\u534f\u8bae\u5546\u54c1" + po.getCommodityCode() + "\u7f16\u8f91\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            reqBO.setReceiveIds(receiveIds);
            this.uccSendNotificationExtAtomService.sendNotification(reqBO);
        }
    }

    private List<Long> qryReceiveIds(UccSendNotificationExtAtomReqBO reqBO) {
        UocApprovalObjPO approvalObjPO = new UocApprovalObjPO();
        approvalObjPO.setObjId(reqBO.getObjId());
        approvalObjPO.setObjType(reqBO.getObjType());
        List taskOperIdList = this.uocApprovalObjMapper.getTaskOperIdList(approvalObjPO);
        if (!CollectionUtils.isEmpty((Collection)taskOperIdList)) {
            DycStationOrgSelectUserNameReqBO selectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            selectUserNameReqBO.setStationId(((UocApprovalObjPO)taskOperIdList.get(0)).getObjId());
            DycStationOrgSelectUserNameRspBO selectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(selectUserNameReqBO);
            if (selectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)selectUserNameRspBO.getUserList())) {
                return selectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList());
            }
            log.error("\u901a\u8fc7\u5c97\u4f4d\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)selectUserNameRspBO));
        }
        return null;
    }

    private Long qryRejectReceiveIds(UccSendNotificationExtAtomReqBO reqBO, Map<Long, UocApprovalObjPO> objPOMap) {
        UocApprovalObjPO approvalObjPO = new UocApprovalObjPO();
        if (null != objPOMap && null != objPOMap.get(reqBO.getObjId())) {
            Long auditOrderId = objPOMap.get(reqBO.getObjId()).getAuditOrderId();
            if (ObjectUtils.isEmpty((Object)auditOrderId)) {
                return null;
            }
            approvalObjPO.setAuditOrderId(auditOrderId);
        }
        approvalObjPO.setObjId(reqBO.getObjId());
        approvalObjPO.setObjType(reqBO.getObjType());
        UocApprovalObjPO tjOperId = this.uocApprovalObjMapper.getTjOperId(approvalObjPO);
        return tjOperId.getObjId();
    }

    private String getTittle(UccSkuPo uccSkuPo, UccCommodityPo po) {
        if (uccSkuPo.getSkuSource().equals(2) && "1".equals(Convert.toStr((Object)po.getIsSupermarketStaff()))) {
            return "\u5458\u5de5\u7535\u5546\u5546\u54c1";
        }
        if (uccSkuPo.getSkuSource().equals(2) && (ObjectUtils.isEmpty((Object)po.getIsSupermarketStaff()) || "0".equals(Convert.toStr((Object)po.getIsSupermarketStaff())))) {
            return "\u7535\u5546\u5546\u54c1";
        }
        if (uccSkuPo.getSkuSource().equals(3) && "1".equals(Convert.toStr((Object)po.getIsSupermarketStaff()))) {
            return "\u5458\u5de5\u534f\u8bae\u5546\u54c1";
        }
        if (uccSkuPo.getSkuSource().equals(3) && (ObjectUtils.isEmpty((Object)po.getIsSupermarketStaff()) || "0".equals(Convert.toStr((Object)po.getIsSupermarketStaff())))) {
            return "\u534f\u8bae\u5546\u54c1";
        }
        if (uccSkuPo.getSkuSource().equals(1)) {
            return "\u65e0\u534f\u8bae\u5546\u54c1";
        }
        return null;
    }
}

