/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityRspBo;
import com.tydic.commodity.estore.atom.api.UccDealApprovalAtomService;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomRspBO;
import com.tydic.commodity.estore.busi.api.CceUccBrandApplyAuditBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CceUccBrandApplyAuditBusiServiceImpl
implements CceUccBrandApplyAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(CceUccBrandApplyAuditBusiServiceImpl.class);
    @Autowired
    private UccDealApprovalAtomService uccDealApprovalAtomService;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @Override
    @DuplicateCommitLimit
    public CceUccBrandApplyAuditAbilityRspBo dealBrandApplyAudit(CceUccBrandApplyAuditAbilityReqBo reqBo) {
        CceUccBrandApplyAuditAbilityRspBo rspBo = new CceUccBrandApplyAuditAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u5355\u636e\u4e3b\u952eID");
            return rspBo;
        }
        if (reqBo.getAuditType() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u7ed3\u679c");
            return rspBo;
        }
        if (reqBo.getAuditType() == 1 && StringUtils.isEmpty((Object)reqBo.getAuditAdvice())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u610f\u89c1");
            return rspBo;
        }
        ArrayList<UocApprovalLogPO> uocApprovalLogPOs = new ArrayList<UocApprovalLogPO>();
        try {
            reqBo.getIds().forEach($ -> uocApprovalLogPOs.add(this.taskTodoWaitService.listApproval($)));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u5ba1\u6279\u5f85\u529e\u524d\u7f6e\u83b7\u53d6\u673a\u6784\u4fe1\u606f get stationId error:{}", (Throwable)e);
        }
        Map<Long, Boolean> finishMap = this.dealAudit(reqBo, uocApprovalLogPOs);
        this.dealMainInfo(reqBo, finishMap);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @DuplicateCommitLimit
    private Map<Long, Boolean> dealAudit(CceUccBrandApplyAuditAbilityReqBo reqBo, List<UocApprovalLogPO> uocApprovalLogPOs) {
        HashMap<Long, Boolean> finishMap = new HashMap<Long, Boolean>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(reqBo.getIds());
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            Map<Object, Object> stepMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                stepMap = brandApplyPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getExtField2())).collect(Collectors.toMap(a -> a.getId(), a -> a.getExtField2()));
            }
            UccDealApprovalAtomReqBO bo = new UccDealApprovalAtomReqBO();
            bo.setAuditAdvice(reqBo.getAuditAdvice());
            bo.setAuditResult(reqBo.getAuditType());
            bo.setUserId(reqBo.getUserId());
            bo.setUserName(reqBo.getName());
            bo.setObjType(1);
            bo.setOrgName(reqBo.getOrgName());
            for (Long id : reqBo.getIds()) {
                bo.setStepId((String)stepMap.get(id));
                bo.setObjId(id);
                UccDealApprovalAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAtomService.dealApproval(bo);
                if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25\uff1a" + dealApprovalAtomRspBO.getRespDesc());
                }
                if (!StringUtils.isEmpty((Object)dealApprovalAtomRspBO.getStepId())) {
                    BrandApplyPO set = new BrandApplyPO();
                    set.setExtField2(dealApprovalAtomRspBO.getStepId());
                    BrandApplyPO where = new BrandApplyPO();
                    where.setId(id);
                    this.brandApplyMapper.updateBy(set, where);
                }
                finishMap.put(id, dealApprovalAtomRspBO.getFinish());
            }
            try {
                Map<Long, List<UocApprovalLogPO>> collect = uocApprovalLogPOs.stream().collect(Collectors.groupingBy(UocApprovalLogPO::getObjId));
                reqBo.getIds().forEach($ -> {
                    TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                    todoUccWaitAbilityReqBO.setObjId($);
                    todoUccWaitAbilityReqBO.setBusiCode("2017");
                    todoUccWaitAbilityReqBO.setBusiName("\u54c1\u724c\u7533\u8bf7\u4e0a\u67b6\u5ba1\u6279");
                    todoUccWaitAbilityReqBO.setCenterCode("commodity");
                    todoUccWaitAbilityReqBO.setOperatorType("1");
                    Long nextStationId = ((UocApprovalLogPO)((List)collect.get($)).get(0)).getNextStationId();
                    todoUccWaitAbilityReqBO.setStationId(nextStationId.toString());
                    this.taskTodoWaitService.brandHandler(todoUccWaitAbilityReqBO);
                });
            }
            catch (Exception e) {
                log.error("\u901a\u77e5\u5f85\u529e - \u54c1\u724c\u7533\u8bf7\u5ba1\u6279 error:{}", (Throwable)e);
            }
        }
        return finishMap;
    }

    private void dealMainInfo(CceUccBrandApplyAuditAbilityReqBo reqBo, Map<Long, Boolean> finishMap) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            if (reqBo.getAuditType() == 0) {
                List<Long> finistList = reqBo.getIds().stream().filter(a -> finishMap.containsKey(a) && (Boolean)finishMap.get(a) != false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(finistList)) {
                    BrandApplyPO set = new BrandApplyPO();
                    set.setAuditTime(new Date());
                    set.setAuditUserCode(reqBo.getOccupation());
                    set.setAuditUserName(reqBo.getName());
                    set.setApplyStatus(Integer.valueOf(5));
                    set.setExtField1(reqBo.getAuditAdvice());
                    BrandApplyPO where = new BrandApplyPO();
                    where.setIds(finistList);
                    this.brandApplyMapper.updateBy(set, where);
                    this.syncRel(finistList, reqBo);
                }
            } else {
                BrandApplyPO set = new BrandApplyPO();
                set.setApplyStatus(Integer.valueOf(4));
                set.setExtField1(reqBo.getAuditAdvice());
                BrandApplyPO where = new BrandApplyPO();
                where.setIds(reqBo.getIds());
                this.brandApplyMapper.updateBy(set, where);
            }
        }
    }

    private void syncRel(List<Long> ids, CceUccBrandApplyAuditAbilityReqBo reqBo) {
        if (!CollectionUtils.isEmpty(ids)) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(ids);
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                HashMap<String, Date> checkDup = new HashMap<String, Date>();
                for (Object applyPO : brandApplyPOS) {
                    if (applyPO.getBrandId() == null || applyPO.getBrandId() == -1L) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
                    }
                    if (applyPO.getVendorId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u4f9b\u5e94\u5546");
                    }
                    if (applyPO.getCatalogId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u5206\u7c7b");
                    }
                    if (applyPO.getConfirmTime() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u6ca1\u6709\u901a\u8fc7\u8fd0\u8425\u786e\u8ba4\uff0c\u8bf7\u6838\u67e5\u6570\u636e");
                    }
                    if (checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())) {
                        if (applyPO.getConfirmTime().getTime() <= ((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).getTime()) continue;
                        checkDup.replace("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                        continue;
                    }
                    checkDup.put("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                }
                ArrayList<BrandApplyPO> syncList = new ArrayList<BrandApplyPO>();
                for (BrandApplyPO applyPO : brandApplyPOS) {
                    if (!checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId()) || !((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).equals(applyPO.getConfirmTime())) continue;
                    syncList.add(applyPO);
                }
                if (!CollectionUtils.isEmpty(syncList)) {
                    ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
                    for (BrandApplyPO applyPO : syncList) {
                        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                        uccRelCatalogBrandVendorPO.setVendorId(applyPO.getVendorId());
                        uccRelCatalogBrandVendorPO.setBrandId(applyPO.getBrandId());
                        uccRelCatalogBrandVendorPO.setCatalogId(applyPO.getCatalogId());
                        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                        if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                            UccRelCatalogBrandVendorPO checkPo = (UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0);
                            UccRelCatalogBrandVendorPO set = new UccRelCatalogBrandVendorPO();
                            set.setDiscountFlag(Integer.valueOf(0));
                            set.setDiscount(applyPO.getDiscount());
                            set.setCreateOperId(applyPO.getConfirmUserCode());
                            set.setCreateOperName(applyPO.getConfirmUserName());
                            set.setCreateTime(new Date());
                            set.setUpdateOperId(applyPO.getConfirmUserCode());
                            set.setUpdateOperName(applyPO.getConfirmUserName());
                            set.setUpdateTime(new Date());
                            set.setBrandApplyId(applyPO.getId());
                            set.setApplyCode(applyPO.getApplyCode());
                            UccRelCatalogBrandVendorPO where = new UccRelCatalogBrandVendorPO();
                            where.setCatalogId(checkPo.getCatalogId());
                            where.setVendorId(checkPo.getVendorId());
                            where.setBrandId(checkPo.getBrandId());
                            this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                            continue;
                        }
                        UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                        insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        insertPo.setVendorId(applyPO.getVendorId());
                        insertPo.setBrandId(applyPO.getBrandId());
                        insertPo.setCatalogId(applyPO.getCatalogId());
                        insertPo.setStatus(Integer.valueOf(1));
                        insertPo.setCreateOperId(applyPO.getConfirmUserCode());
                        insertPo.setCreateOperName(applyPO.getConfirmUserName());
                        insertPo.setCreateTime(new Date());
                        insertPo.setUpdateOperId(applyPO.getConfirmUserCode());
                        insertPo.setUpdateOperName(applyPO.getConfirmUserName());
                        insertPo.setUpdateTime(new Date());
                        insertPo.setDiscountFlag(Integer.valueOf(0));
                        insertPo.setDiscount(applyPO.getDiscount());
                        insertPo.setBrandApplyId(applyPO.getId());
                        insertPo.setApplyCode(applyPO.getApplyCode());
                        insertList.add(insertPo);
                    }
                    if (!CollectionUtils.isEmpty(insertList)) {
                        this.uccRelCatalogBrandVendorMapper.insertBatch(insertList);
                    }
                }
            }
        }
    }
}

