/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.busibase.atom.bo.SkuForEsBO;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.busibase.comb.bo.SearchEsReqBO;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCatalogBrandVerifyEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccProductInfoRefreshJobParam;
import com.tydic.commodity.estore.busi.api.UccProductInfoRefreshJobInService;
import com.tydic.commodity.estore.busi.impl.UccProductInfoRefreshJobInServiceImpl2;
import com.tydic.commodity.estore.utils.UccDateUtil;
import com.tydic.commodity.po.SkuForEsPO;
import com.tydic.commodity.po.SkuSurPassVptPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmCatalogQryConditionPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccProductInfoRefreshJobInServiceImpl
implements UccProductInfoRefreshJobInService {
    private static final Logger log = LoggerFactory.getLogger(UccProductInfoRefreshJobInServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccProductInfoRefreshJobInServiceImpl2.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccCatalogBrandVerifyEditMapper uccCatalogBrandVerifyEditMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private static final int PAGE_SIZE = 500;

    @Override
    public RspUccBo freshProductInfo(UccProductInfoRefreshJobParam param) {
        LOGGER.info("===============\u5546\u54c1\u5237\u65b0\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1start================");
        ArrayList brandIds = new ArrayList();
        try {
            Date date = DateUtils.addDays((Date)UccDateUtil.getToday(), (int)(-param.getOldDay().intValue()));
            this.uccRelCatalogBrandVendor(date);
            this.uccEMdmCatalog(date);
        }
        catch (Exception e) {
            LOGGER.error("UccProductInfoRefreshJobInServiceImpl exception:{}", (Throwable)e);
            return new RspUccBo("8888", "\u7cfb\u7edf\u5f02\u5e38");
        }
        return new RspUccBo("0000", "\u6210\u529f");
    }

    private void uccEMdmCatalog(Date date) {
        UccEMdmCatalogQryConditionPO uccEMdmCatalogQryConditionPO = new UccEMdmCatalogQryConditionPO();
        uccEMdmCatalogQryConditionPO.setUpdateTime(date);
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qureyByParam(uccEMdmCatalogQryConditionPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogPOS)) {
            List collect = uccEMdmCatalogPOS.stream().map(UccEMdmCatalogPO::getCatalogId).collect(Collectors.toList());
            List longs = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(collect);
            Integer count = this.uccSkuMapper.queryAllcount(longs);
            long totalPage = count % 500 == 0 ? (long)(count / 500) : (long)(count / 500 + 1);
            Page pageBO = new Page();
            pageBO.setPageSize(500);
            int page = 1;
            while ((long)page <= totalPage) {
                pageBO.setPageNo(page);
                List uccSkuPos = this.uccSkuMapper.queryAllByLimit(longs, pageBO);
                LOGGER.info("defaultHandler uccEMdmCatalog size:{}", (Object)uccSkuPos.size());
                this.updateEsBySku(uccSkuPos);
                ++page;
            }
        }
    }

    private void updateEsBySku(List<UccSkuPo> list) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return;
        }
        List commodityIds = list.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        List brandIds = list.stream().map(UccSkuPo::getBrandId).collect(Collectors.toList());
        List skuForEsPOS = this.uccSkuMapper.qrySkuAndLowPriceList(null, commodityIds);
        UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
        uccMallBrandRelPo.setBrandIds(brandIds);
        List list1 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
        Map<Long, UccMallBrandRelPO> collect = list1.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
        List collect3 = skuForEsPOS.stream().map(SkuForEsPO::getMgCatalogId).collect(Collectors.toList());
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(collect3);
        Map<Long, List<UccEMdmCatalogPO>> collect4 = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
        List<SkuForEsBO> skuForEsBOS = this.potoBo(skuForEsPOS, collect, collect4);
        this.checkMallBrand(skuForEsBOS);
        LOGGER.info("skuForEsBOS model:{}", (Object)JSON.toJSONString(skuForEsBOS));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuForEsBOS)) {
            return;
        }
        LOGGER.info("updateEsByBrandName \u672c\u6b21\u4efb\u52a1\u63d0\u4ea4\u5546\u54c1\u6761\u6570:{}", (Object)skuForEsBOS.size());
        for (int i = 0; i < skuForEsBOS.size(); ++i) {
            SkuForEsBO skuForEsBO = skuForEsBOS.get(i);
            JSONObject object = new JSONObject();
            object.put("brand_verify", (Object)skuForEsBO.getBrandVerify());
            object.put("govern_result", (Object)skuForEsBO.getDataGovernFlag());
            object.put("brandVerifyResult", (Object)skuForEsBO.getBrandVerifyResult());
            object.put("brandVerifyFailReason", (Object)skuForEsBO.getBrandVerifyFailReason());
            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuForEsBO.getSkuId().toString(), object);
        }
    }

    private List<Long> uccRelCatalogBrandVendor(Date date) {
        ArrayList models = new ArrayList();
        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
        uccRelCatalogBrandVendorPo.setUpdateTimeStart(date);
        List listByParam = this.uccRelCatalogBrandVendorMapper.getListByParam(uccRelCatalogBrandVendorPo);
        LOGGER.info("defaultHandler listByParam size:{}", (Object)listByParam.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listByParam)) {
            List brandIds = listByParam.stream().map(UccRelCatalogBrandVendorPO::getBrandId).collect(Collectors.toList());
            UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
            uccMallBrandRelPo.setMallBrandIds(brandIds);
            List list1 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
            List collect = list1.stream().map($ -> {
                UccBrandDealPO po = new UccBrandDealPO();
                po.setBrandName($.getMallBrandName());
                po.setBrandId($.getBrandId());
                return po;
            }).collect(Collectors.toList());
            models.addAll(collect);
            LOGGER.info("defaultHandler uccBrandDealPOS models:{}", (Object)JSON.toJSONString(models));
            UccBrandDealPO reqBO1 = new UccBrandDealPO();
            reqBO1.setUpdateTime(date);
            List uccBrandDealPOS1 = this.uccBrandDealMapper.selectBy(reqBO1);
            models.addAll(uccBrandDealPOS1);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(models)) {
                List brandIds1 = models.stream().distinct().map(UccBrandDealPO::getBrandId).collect(Collectors.toList());
                Integer count = this.uccSkuMapper.queryBrandIdsCount(brandIds1);
                long totalPage = count % 500 == 0 ? (long)(count / 500) : (long)(count / 500 + 1);
                Page pageBO = new Page();
                pageBO.setPageSize(500);
                int page = 1;
                while ((long)page <= totalPage) {
                    pageBO.setPageNo(page);
                    List skuIds = this.uccSkuMapper.queryBrandIdsByLimit(brandIds1, pageBO);
                    LOGGER.info("updateEsByBrandName skuIds:{},brandIds:{}", (Object)JSON.toJSONString((Object)skuIds), (Object)JSON.toJSONString(brandIds));
                    List skuBrandVerfyBySkuIds = this.uccSkuMapper.getSkuBrandVerfyBySkuIds(skuIds);
                    List commodityIds = skuBrandVerfyBySkuIds.stream().map(SkuSurPassVptPo::getCommodityId).collect(Collectors.toList());
                    List skuForEsPOS = this.uccSkuMapper.qrySkuAndLowPriceList(null, commodityIds);
                    UccMallBrandRelPO uccMallBrandRelPo1 = new UccMallBrandRelPO();
                    uccMallBrandRelPo1.setBrandIds(brandIds1);
                    List list2 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo1);
                    Map<Long, UccMallBrandRelPO> collect1 = list2.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
                    List collect3 = skuForEsPOS.stream().map(SkuForEsPO::getMgCatalogId).collect(Collectors.toList());
                    List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(collect3);
                    Map<Long, List<UccEMdmCatalogPO>> collect4 = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
                    List<SkuForEsBO> skuForEsBOS = this.potoBo(skuForEsPOS, collect1, collect4);
                    this.checkMallBrand(skuForEsBOS);
                    LOGGER.info("skuForEsBOS model:{}", (Object)JSON.toJSONString(skuForEsBOS));
                    LOGGER.info("updateEsByBrandName \u672c\u6b21\u4efb\u52a1\u63d0\u4ea4\u5546\u54c1\u6761\u6570:{}", (Object)skuForEsBOS.size());
                    for (int i = 0; i < skuForEsBOS.size(); ++i) {
                        SkuForEsBO skuForEsBO = skuForEsBOS.get(i);
                        JSONObject object = new JSONObject();
                        object.put("brand_verify", (Object)skuForEsBO.getBrandVerify());
                        object.put("govern_result", (Object)skuForEsBO.getDataGovernFlag());
                        object.put("brandVerifyResult", (Object)skuForEsBO.getBrandVerifyResult());
                        object.put("brandVerifyFailReason", (Object)skuForEsBO.getBrandVerifyFailReason());
                        this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuForEsBO.getSkuId().toString(), object);
                    }
                    ++page;
                }
            }
        }
        return null;
    }

    private List<SkuForEsBO> potoBo(List<SkuForEsPO> skuForEsPOS, Map<Long, UccMallBrandRelPO> collect, Map<Long, List<UccEMdmCatalogPO>> collect4) {
        ArrayList<SkuForEsBO> skuForEsBOS = new ArrayList<SkuForEsBO>();
        for (int i = 0; i < skuForEsPOS.size(); ++i) {
            List<UccEMdmCatalogPO> uccEMdmCatalogPOS;
            SkuForEsPO skuForEsPO = skuForEsPOS.get(i);
            SkuForEsBO skuForEsBO = new SkuForEsBO();
            BeanUtils.copyProperties((Object)skuForEsPO, (Object)skuForEsBO);
            UccMallBrandRelPO uccMallBrandRelPOS = collect.get(skuForEsBO.getBrandId());
            if (Objects.nonNull(uccMallBrandRelPOS)) {
                skuForEsBO.setMallBrandId(uccMallBrandRelPOS.getMallBrandId());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccEMdmCatalogPOS = collect4.get(skuForEsBO.getMgCatalogId()))) {
                skuForEsBO.setBrandVerify(uccEMdmCatalogPOS.get(0).getBrandVerify());
            }
            skuForEsBOS.add(skuForEsBO);
        }
        return skuForEsBOS;
    }

    private void checkMallBrand(List<SkuForEsBO> skuForEsBOS) {
        if (CollectionUtils.isEmpty(skuForEsBOS)) {
            return;
        }
        List skuIds = skuForEsBOS.stream().filter(a -> a.getSkuSource() != null && a.getSkuSource() == 2).map(a -> a.getSkuId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List preRelMallBrandSkuIds = skuForEsBOS.stream().filter(a -> a.getSkuSource() != null && a.getSkuSource() == 2 && a.getSkuStatus() != null && a.getSkuStatus() == 17).map(a -> a.getSkuId()).collect(Collectors.toList());
        Map<Object, Object> searchSkuMap = new HashMap();
        if (!CollectionUtils.isEmpty(preRelMallBrandSkuIds)) {
            SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
            searchEsReqBO.setSkuList(preRelMallBrandSkuIds);
            searchEsReqBO.setPageNo(1);
            searchEsReqBO.setPageSize(preRelMallBrandSkuIds.size());
            SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
            if (searchEsRspBo != null && !CollectionUtils.isEmpty((Collection)searchEsRspBo.getCommodityRspBos())) {
                List commodityRspBos = searchEsRspBo.getCommodityRspBos();
                searchSkuMap = commodityRspBos.stream().collect(Collectors.toMap(a -> a.getSku_id(), a -> a.getBrandVerifyResult(), (first, second) -> first));
            }
        }
        List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrand(skuIds);
        Map<Object, Object> skuBrandMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
            skuBrandMap = uccSkuBrandPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (a, b) -> a));
        }
        List mgCatalogIds = skuForEsBOS.stream().map(SkuForEsBO::getMgCatalogId).collect(Collectors.toList());
        List supplierShopIds = skuForEsBOS.stream().map(SkuForEsBO::getSupplierShopId).collect(Collectors.toList());
        List brandIds = uccSkuBrandPos.stream().map(UccSkuBrandPo::getBrandId).collect(Collectors.toList());
        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
        uccRelCatalogBrandVendorPO.setCatalogIds(mgCatalogIds);
        uccRelCatalogBrandVendorPO.setBrandIds(brandIds);
        uccRelCatalogBrandVendorPO.setVendorIds(supplierShopIds);
        uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getListByParam(uccRelCatalogBrandVendorPO);
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            if (skuForEsBO.getSkuSource() == null || skuForEsBO.getSkuSource() != 2) continue;
            if (skuForEsBO.getBrandVerify() != null && skuForEsBO.getBrandVerify() == 1) {
                UccSkuBrandPo skuBrandPo = (UccSkuBrandPo)skuBrandMap.get(skuForEsBO.getSkuId());
                if (skuBrandPo == null || skuBrandPo.getBrandId() == null) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(3));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getBrandStatus() != 1) {
                    if (skuBrandPo.getBrandStatus() == 2) {
                        skuForEsBO.setBrandVerifyResult(Integer.valueOf(3));
                        skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                        continue;
                    }
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getAppRange() == null || skuBrandPo.getAppRange() == 2) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u5e94\u7528\u8303\u56f4\u4e3a\u975e\u7535\u5546\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u66f4\u6539\u5e94\u7528\u8303\u56f4\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS) || !uccRelCatalogBrandVendorPOS.stream().map(UccRelCatalogBrandVendorPO::getBrandId).collect(Collectors.toList()).contains(skuForEsBO.getMallBrandId())) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u8be5\u4f9b\u5e94\u5546\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u8be5\u54c1\u724c\u505a\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                List collect = uccRelCatalogBrandVendorPOS.stream().filter($ -> $.getBrandId().compareTo(skuForEsBO.getMallBrandId()) == 0).collect(Collectors.toList());
                if (((UccRelCatalogBrandVendorPO)collect.get(0)).getStatus() == null || ((UccRelCatalogBrandVendorPO)collect.get(0)).getStatus() != 1) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u4f9b\u5e94\u5546\u5546\u54c1\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u54c1\u724c\u5173\u8054\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                skuForEsBO.setBrandVerifyResult(Integer.valueOf(1));
                continue;
            }
            skuForEsBO.setBrandVerifyResult(Integer.valueOf(0));
        }
    }
}

