/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.UccWaitOnShelfRollbackBusiService;
import com.tydic.commodity.estore.busi.bo.UccWaitOnShelfRollbackBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccWaitOnShelfRollbackBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditOrderAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderReqBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccWaitOnShelfRollbackBusiServiceImpl
implements UccWaitOnShelfRollbackBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccWaitOnShelfRollbackBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UacQryAuditOrderAbilityService qryAuditOrderAbilityService;

    @Override
    public UccWaitOnShelfRollbackBusiRspBO dealWaitOnShelfRollback(UccWaitOnShelfRollbackBusiReqBO reqBO) {
        UccWaitOnShelfRollbackBusiRspBO rspBO = new UccWaitOnShelfRollbackBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56de\u9000\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u56de\u9000\u5355\u54c1\u6570\u636e");
            return rspBO;
        }
        Set editSku = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toSet());
        ArrayList editSkuAray = new ArrayList(editSku);
        if (!CollectionUtils.isEmpty(editSkuAray) && reqBO.getNoRollbackFlag() == null) {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = null;
            for (Long cancelEach : editSkuAray) {
                UacQryAuditOrderReqBO qryAuditOrderReqBO = new UacQryAuditOrderReqBO();
                qryAuditOrderReqBO.setObjId(cancelEach.toString());
                qryAuditOrderReqBO.setIsToBeAudit(Boolean.valueOf(true));
                UacQryAuditOrderRspBO qryAuditOrderRspBO = this.qryAuditOrderAbilityService.qryAuditOrders(qryAuditOrderReqBO);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)qryAuditOrderRspBO.getApprovalOrders()) || qryAuditOrderRspBO.getApprovalOrders().size() <= 1) continue;
                uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
                uacNoTaskAuditCancelReqBO.setObjId(cancelEach.toString());
                uacNoTaskAuditCancelReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                uacNoTaskAuditCancelReqBO.setOperDept(reqBO.getCompanyName());
                uacNoTaskAuditCancelReqBO.setOperId(reqBO.getUserId().toString());
                uacNoTaskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
                uacNoTaskAuditCancelReqBO.setCancelReason("\u56de\u9000\u81f3\u5f85\u5173\u8054");
                UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
                if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) continue;
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
            try {
                Set editSpu = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toSet());
                ArrayList editSpuAray = new ArrayList(editSpu);
                this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editSpuAray, null, null);
                this.uccCommodityMapper.batchUpdateStep(editSpuAray, null, null);
            }
            catch (Exception e) {
                throw new BusinessException("8888", e.getMessage());
            }
            try {
                this.uccSkuMapper.batchUpdateSpuApprovalStatusBySkuId(editSkuAray, null, null);
                this.uccSkuMapper.batchUpdateStepBySkuId(editSkuAray, null, null);
            }
            catch (Exception e) {
                throw new BusinessException("8888", e.getMessage());
            }
        }
        ArrayList preOnShlef = new ArrayList();
        uccSkuPos.stream().forEach(a -> {
            UccBatchSkuBO bo = new UccBatchSkuBO();
            bo.setSkuId(a.getSkuId());
            bo.setSupplierShopId(a.getSupplierShopId());
            preOnShlef.add(bo);
        });
        if (!CollectionUtils.isEmpty(preOnShlef)) {
            Map<Long, List<UccBatchSkuBO>> skuMap = preOnShlef.stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
            for (Long shopId : skuMap.keySet()) {
                List<Long> skuBOS = skuMap.get(shopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                try {
                    this.updateSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF, skuBOS, shopId, reqBO.getUserId());
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5355\u54c1\u4fe1\u606f\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, List<Long> skus, Long supplierShopId, Long userId) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(userId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

