/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.estore.ability.api.UccStandardPriceAddAbilityService;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceAddAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceAddAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccStandardPriceAddBO;
import com.tydic.commodity.estore.busi.api.UccStandardPriceAddBusiService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccStandardPriceAddAbilityService"})
public class UccStandardPriceAddAbilityServiceImpl
implements UccStandardPriceAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardPriceAddAbilityServiceImpl.class);
    @Autowired
    private UccStandardPriceAddBusiService uccStandardPriceAddBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"createStandardPrice"})
    public UccStandardPriceAddAbilityRspBO createStandardPrice(@RequestBody UccStandardPriceAddAbilityReqBO reqBO) {
        UccStandardPriceAddAbilityRspBO rspBO = new UccStandardPriceAddAbilityRspBO();
        try {
            this.validate(reqBO);
            rspBO = this.uccStandardPriceAddBusiService.createStandardPrice(reqBO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUccStandardPriceLists())) {
            throw new BusinessException("8888", "\u5165\u53c2uccStandardPriceLists\u4e3a\u7a7a\uff01");
        }
        List skuIds = reqBO.getUccStandardPriceLists().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
        }
        return rspBO;
    }

    private void validate(UccStandardPriceAddAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5546\u54c1\u57fa\u51c6\u4ef7\u6dfb\u52a0\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUccStandardPriceLists())) {
            throw new BusinessException("8888", "\u5546\u54c1\u57fa\u51c6\u4ef7\u6dfb\u52a0\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (UccStandardPriceAddBO uccStandardPrice : reqBO.getUccStandardPriceLists()) {
            if (uccStandardPrice == null) {
                throw new BusinessException("8888", "\u5165\u53c2\u57fa\u51c6\u4ef7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (uccStandardPrice.getSkuId() == null) {
                throw new BusinessException("8888", "skuId\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((Object)uccStandardPrice.getExtSkuId())) {
                throw new BusinessException("8888", "extSkuId\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (uccStandardPrice.getVendorId() == null) {
                throw new BusinessException("8888", "vendorId\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((Object)uccStandardPrice.getVendorName())) {
                throw new BusinessException("8888", "vendorName\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((Object)uccStandardPrice.getSkuName())) {
                throw new BusinessException("8888", "skuName\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (uccStandardPrice.getUpRatio() == null) {
                throw new BusinessException("8888", "upRatio\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (uccStandardPrice.getStandardPrice() != null) continue;
            throw new BusinessException("8888", "standardPrice\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

