/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.estore.atom.api.UccQryMsgFromInterService;
import com.tydic.commodity.estore.atom.bo.ResultOtherVO;
import com.tydic.commodity.estore.atom.bo.ResultVO;
import com.tydic.commodity.estore.atom.bo.UccBusiQryMsgReqBO;
import com.tydic.commodity.estore.atom.bo.UccBusiQryMsgRspBO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQryMsgFromInterService")
public class UccQryMsgFromInterServiceImpl
implements UccQryMsgFromInterService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);

    @Override
    public UccBusiQryMsgRspBO qryMsg(UccBusiQryMsgReqBO reqBo) {
        UccBusiQryMsgRspBO busiQryMsgRspBO = new UccBusiQryMsgRspBO();
        try {
            String reqStr = this.initReqStr(reqBo);
            String reqEsbStr = ESBParamUtil.getEsbReqStr((String)reqStr, (String)reqBo.getSupplierCode(), (String)"BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty((String)"ESB_QRY_MSG_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.toString().getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty((String)"ESB_QRY_MSG_URL") + "]"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccBusiQryMsgRspBO resolveRsp = this.resolveRsp(returnString, reqBo.getType(), reqBo.getSupplierCode());
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            if (Objects.nonNull((Object)resolveRsp)) {
                resolveRsp.setRespCode("0000");
            }
            resolveRsp.setRespDesc("\u6210\u529f");
            return resolveRsp;
        }
        catch (Exception var9) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9));
            busiQryMsgRspBO.setRespCode("8888");
            busiQryMsgRspBO.setRespDesc("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return busiQryMsgRspBO;
        }
    }

    private String initReqStr(UccBusiQryMsgReqBO busiQryMsgReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"type\":" + busiQryMsgReqBO.getType()).append("}");
        return sb.toString();
    }

    private UccBusiQryMsgRspBO resolveRsp(String returnString, Integer type, String supplierCode) {
        UccBusiQryMsgRspBO busiQryMsgRspBO = new UccBusiQryMsgRspBO();
        ArrayList<ResultVO> list = new ArrayList<ResultVO>();
        ArrayList<ResultOtherVO> listOther = new ArrayList<ResultOtherVO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            busiQryMsgRspBO.setResultCode(Integer.valueOf((String)rspJsonObject.get((Object)"resultCode")));
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    Object result = null;
                    if (!StringUtils.isEmpty((Object)jsonStr)) {
                        // empty if block
                    }
                    ResultVO jsonStringToJavaBean = null;
                    ResultOtherVO jsonStringToJavaBean1 = null;
                    if (type == 2 || type == 4) {
                        jsonStringToJavaBean = (ResultVO)JSON.parseObject((String)jsonStr, ResultVO.class);
                        if (Objects.nonNull(jsonStringToJavaBean.getResult()) && Objects.isNull(jsonStringToJavaBean.getResult().getState())) {
                            jsonStringToJavaBean.getResult().setState(1);
                        }
                        list.add(jsonStringToJavaBean);
                    }
                    if (type != 6 && type != 16) continue;
                    jsonStringToJavaBean1 = (ResultOtherVO)JSON.parseObject((String)jsonStr, ResultOtherVO.class);
                    if (Objects.nonNull(jsonStringToJavaBean1.getResult()) && Objects.isNull(jsonStringToJavaBean1.getResult().getState())) {
                        jsonStringToJavaBean1.getResult().setState(1);
                    }
                    if (!"jd".equals(supplierCode) && !"jdFl".equals(supplierCode) && type == 6 && jsonStringToJavaBean1.getResult().getState() == 1 && StringUtils.isEmpty((Object)jsonStringToJavaBean1.getResult().getSpuId())) {
                        throw new ZTBusinessException("\u5546\u54c1\u65b0\u589e\u6d88\u606fspuId\u4e3a\u7a7a");
                    }
                    listOther.add(jsonStringToJavaBean1);
                }
                busiQryMsgRspBO.setResult(list);
                busiQryMsgRspBO.setResultOther(listOther);
            }
            return busiQryMsgRspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

