/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuOnShelveWayEnum;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.SkuForEsBO;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.common.ability.bo.UccExprotCodeBo;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.config.UccThreadPoolExecutorConfig;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCatalogBrandVerifyEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccRelCatalogVendorDiscountMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccFreshProductUpDownStatusReqBO;
import com.tydic.commodity.estore.ability.bo.UccFreshProductWaitMatchParamBO;
import com.tydic.commodity.estore.ability.bo.UccProductInfoRefreshJobParam;
import com.tydic.commodity.estore.busi.api.UccProductInfoRefreshJobInService;
import com.tydic.commodity.estore.busi.bo.UccProductInfoRefreshBO;
import com.tydic.commodity.estore.common.UccProductQryEsComponent;
import com.tydic.commodity.estore.utils.UccDateUtil;
import com.tydic.commodity.po.SkuForEsPO;
import com.tydic.commodity.po.SkuSurPassVptPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmCatalogQryConditionPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccProductInfoRefreshJobInServiceImpl
implements UccProductInfoRefreshJobInService {
    private static final Logger log = LoggerFactory.getLogger(UccProductInfoRefreshJobInServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccProductInfoRefreshJobInServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccCatalogBrandVerifyEditMapper uccCatalogBrandVerifyEditMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccRelCatalogVendorDiscountMapper uccRelCatalogVendorDiscountMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccProductQryEsComponent uccProductQryEsComponent;
    private static final int PAGE_SIZE = 200;
    @Value(value="${discount_digit:4}")
    private String digit;
    private static final ThreadPoolExecutor poolExecutor = UccThreadPoolExecutorConfig.poolExecutor;

    @Override
    public RspUccBo freshProductInfo(UccProductInfoRefreshJobParam param) {
        LOGGER.info("===============\u5546\u54c1\u5237\u65b0\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1start================");
        ArrayList brandIds = new ArrayList();
        try {
            Date date = DateUtils.addDays((Date)UccDateUtil.getToday(), (int)(-param.getOldDay().intValue()));
            this.uccRelCatalogBrandVendor(date);
            this.uccEMdmCatalog(date);
            this.uccBrand(date);
        }
        catch (Exception e) {
            LOGGER.error("UccProductInfoRefreshJobInServiceImpl exception:{}", (Throwable)e);
            return new RspUccBo("8888", "\u7cfb\u7edf\u5f02\u5e38");
        }
        return new RspUccBo("0000", "\u6210\u529f");
    }

    private void uccBrand(Date date) {
        UccBrandDealPO reqBO = new UccBrandDealPO();
        reqBO.setUpdateTimeStart(date);
        List uccBrandDealPOS = this.uccBrandDealMapper.selectBy(reqBO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccBrandDealPOS)) {
            return;
        }
        List brandIds = uccBrandDealPOS.stream().map(UccBrandDealPO::getBrandId).collect(Collectors.toList());
        Integer count = this.uccSkuMapper.queryCountByBrandIds(brandIds);
        if (Objects.isNull(count) || 0 == count) {
            return;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        int page = 1;
        while ((long)page <= totalPage) {
            pageBO.setPageNo(page);
            List skuIds = this.uccSkuMapper.queryAllFromBrandIdsByLimit(brandIds, pageBO);
            CompletableFuture.runAsync(() -> this.uccBrandSyncToEs(skuIds, brandIds), poolExecutor);
            ++page;
        }
    }

    private void uccBrandSyncToEs(List<Long> skuIds, List<Long> brandIds) {
        List skuBrandVerfyBySkuIds = this.uccSkuMapper.getSkuBrandVerfyBySkuIds(skuIds);
        List commodityIds = skuBrandVerfyBySkuIds.stream().map(SkuSurPassVptPo::getCommodityId).collect(Collectors.toList());
        List skuForEsPOS = this.uccSkuMapper.qrySkuAndLowPriceList(null, commodityIds);
        UccMallBrandRelPO uccMallBrandRelPo2 = new UccMallBrandRelPO();
        uccMallBrandRelPo2.setBrandIds(brandIds);
        List list2 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo2);
        Map<Long, UccMallBrandRelPO> collect1 = list2.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
        List collect3 = skuForEsPOS.stream().map(SkuForEsPO::getMgCatalogId).collect(Collectors.toList());
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(collect3);
        Map<Long, List<UccEMdmCatalogPO>> collect4 = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
        List<SkuForEsBO> skuForEsBOS = this.potoBo(skuForEsPOS, collect1, collect4);
        this.checkMallBrand(skuForEsBOS);
        LOGGER.info("skuForEsBOS model:{}", (Object)JSON.toJSONString(skuForEsBOS));
        LOGGER.info("updateEsByBrandName \u672c\u6b21\u4efb\u52a1\u63d0\u4ea4\u5546\u54c1\u6761\u6570:{}", (Object)skuForEsBOS.size());
        for (int i = 0; i < skuForEsBOS.size(); ++i) {
            SkuForEsBO skuForEsBO = skuForEsBOS.get(i);
            JSONObject object = new JSONObject();
            object.put("brand_verify", (Object)skuForEsBO.getBrandVerify());
            object.put("govern_result", (Object)skuForEsBO.getDataGovernFlag());
            object.put("brandVerifyResult", (Object)skuForEsBO.getBrandVerifyResult());
            object.put("brandVerifyFailReason", (Object)skuForEsBO.getBrandVerifyFailReason());
            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuForEsBO.getSkuId().toString(), object);
        }
    }

    @Override
    public RspUccBo freshProductUpDownStatus(UccFreshProductUpDownStatusReqBO reqBO) {
        this.checkParam(reqBO);
        List operatorTypes = reqBO.getOperatorTypes();
        operatorTypes.forEach($ -> {
            try {
                switch ($) {
                    case "1": {
                        this.updateWaitMatchBrand();
                        break;
                    }
                    case "2": {
                        this.updateWaitDown();
                        break;
                    }
                    default: {
                        LOGGER.error("freshProductUpDownStatus operatorType error:{}", (Object)"\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("freshProductUpDownStatus error:{}", (Throwable)e);
            }
        });
        return new RspUccBo("0000", "\u6210\u529f");
    }

    @Override
    public RspUccBo freshWaitMatchBrand(UccFreshProductWaitMatchParamBO reqBO) {
        log.error("====================freshWaitMatchBrand job start===================");
        try {
            reqBO.getItems().forEach($ -> {
                int total;
                reqBO.setSkuStatus($.getSkuStatus());
                reqBO.setBrandVerifyResult($.getBrandVerifyResult());
                UccSpuCodingexportAbilityRspBO uccSpuCodingexportAbilityRspBO = this.uccProductQryEsComponent.searchProductByEs(reqBO);
                if (Objects.isNull(uccSpuCodingexportAbilityRspBO) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSpuCodingexportAbilityRspBO.getRows()) || 0 >= uccSpuCodingexportAbilityRspBO.getRows().size()) {
                    return;
                }
                int count = uccSpuCodingexportAbilityRspBO.getRecordsTotal();
                long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
                int page = total = (int)totalPage;
                while (page >= 1) {
                    int finalPage = page--;
                    CompletableFuture.runAsync(() -> {
                        reqBO.setPageNo(Integer.valueOf(finalPage));
                        UccSpuCodingexportAbilityRspBO productByEs = this.uccProductQryEsComponent.searchProductByEs(reqBO);
                        if (Objects.nonNull(productByEs) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)productByEs.getRows()) && 0 < productByEs.getRows().size()) {
                            List<Long> skuIds = productByEs.getRows().stream().map(UccExprotCodeBo::getSkuId).collect(Collectors.toList());
                            this.syncToEs(skuIds);
                        }
                    }, poolExecutor);
                }
            });
        }
        catch (Exception e) {
            log.error("freshWaitMatchBrand error:{}", (Throwable)e);
        }
        log.error("====================freshWaitMatchBrand job end===================");
        return new RspUccBo("0000", "\u6210\u529f");
    }

    private void syncToEs(List<Long> skuIds) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
        syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
        syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
        syncSceneCommodityToEsReqBO.setSingleType(0);
        this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
    }

    private void dealSku(List<Long> skuIds) {
        if (!CollectionUtils.isEmpty(skuIds)) {
            List secondDiscountLimitSkuIds;
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
            List directList = uccSkuPos.stream().filter($ -> $.getSkuSource() == 2 && Objects.nonNull($.getOnShelveWay()) && SkuOnShelveWayEnum.ON_DECRIT_WAY.getCode().equals($.getOnShelveWay()) && ModelRuleConstant.SKU_STATUS_ON_SHELF.equals($.getSkuStatus())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
            ArrayList<Long> checkSecond = new ArrayList<Long>();
            List surpassDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSurpassDiscountLimitSku(skuIds, Integer.valueOf(this.digit));
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                skuIds.forEach(each -> {
                    if (!surpassDiscountLimitSkuIds.contains(each)) {
                        checkSecond.add((Long)each);
                    }
                });
            } else {
                checkSecond.addAll(skuIds);
            }
            if (!CollectionUtils.isEmpty(checkSecond) && !CollectionUtils.isEmpty((Collection)(secondDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSecondDiscountLimitSku(checkSecond, Integer.valueOf(this.digit))))) {
                surpassDiscountLimitSkuIds.addAll(secondDiscountLimitSkuIds);
            }
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                List<Long> notDiscountLimitSkuIds;
                List<Long> failList = surpassDiscountLimitSkuIds.stream().filter($ -> directList.contains($)).collect(Collectors.toList());
                List<Long> successList = surpassDiscountLimitSkuIds.stream().filter($ -> !directList.contains($)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(failList)) {
                    failList.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(1), Integer.valueOf(0));
                    });
                }
                if (!CollectionUtils.isEmpty(successList)) {
                    successList.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(1), Integer.valueOf(1));
                    });
                }
                if (!CollectionUtils.isEmpty(notDiscountLimitSkuIds = skuIds.stream().filter(a -> !surpassDiscountLimitSkuIds.contains(a)).distinct().collect(Collectors.toList()))) {
                    notDiscountLimitSkuIds.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(0), Integer.valueOf(0));
                    });
                }
            } else {
                skuIds.forEach($ -> {
                    List<Long> ids = Collections.singletonList($);
                    this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(0), Integer.valueOf(0));
                });
            }
        }
    }

    private void updateWaitDown() {
        int total;
        log.error("================\u5f85\u4e0a\u67b6\u9875\u7b7e\u4efb\u52a1\u5f00\u59cb\u6267\u884c=====================");
        Integer count = this.uccSkuMapper.queryCountByFreshStatus(UccProductInfoRefreshBO.sku_status_wait_down);
        if (Objects.isNull(count) || 0 == count) {
            return;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        pageBO.setLimit(200);
        for (int page = total = (int)totalPage; page >= 1; --page) {
            pageBO.setPageNo(page);
            CompletableFuture.runAsync(() -> {
                List uccSkus = this.uccSkuMapper.querySkusByLimit(UccProductInfoRefreshBO.sku_status_wait_down, pageBO);
                this.waitDownSyncToEs(uccSkus);
            }, poolExecutor);
        }
        log.error("================\u5f85\u4e0a\u67b6\u9875\u7b7e\u4efb\u52a1\u6267\u884c\u5b8c\u6210=====================");
    }

    private void updateWaitMatchBrand() {
        int total;
        log.error("================\u5f85\u5173\u8054\u54c1\u724c\u9875\u7b7e\u4efb\u52a1\u5f00\u59cb\u6267\u884c=====================");
        Integer count = this.uccSkuMapper.queryCountByFreshStatus(UccProductInfoRefreshBO.sku_status_mapping);
        if (Objects.isNull(count) || 0 == count) {
            return;
        }
        long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
        Page pageBO = new Page();
        pageBO.setPageSize(200);
        pageBO.setLimit(200);
        for (int page = total = (int)totalPage; page >= 1; --page) {
            pageBO.setPageNo(page);
            CompletableFuture.runAsync(() -> {
                List uccSkus = this.uccSkuMapper.querySkusByLimit(UccProductInfoRefreshBO.sku_status_mapping, pageBO);
                this.matchBrandSyncToEs(uccSkus);
            }, poolExecutor);
        }
        log.error("================\u5f85\u5173\u8054\u54c1\u724c\u9875\u7b7e\u4efb\u52a1\u6267\u884c\u5b8c\u6210=====================");
    }

    private void waitDownSyncToEs(List<UccSkuPo> uccSkus) {
        try {
            List brandIds = uccSkus.stream().map(UccSkuPo::getBrandId).distinct().collect(Collectors.toList());
            List commodityTypeIds = uccSkus.stream().map(UccSkuPo::getCommodityTypeId).distinct().collect(Collectors.toList());
            List<Long> skuIds = uccSkus.stream().map(UccSkuPo::getSkuId).distinct().collect(Collectors.toList());
            try {
                this.dealSku(skuIds);
            }
            catch (Exception e) {
                log.error("waitDownSyncToEs dealSku error:{}", (Throwable)e);
            }
            List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrand(skuIds);
            Map<Object, Object> skuBrandMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
                skuBrandMap = uccSkuBrandPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (a, b) -> a));
            }
            UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
            uccMallBrandRelPo.setBrandIds(brandIds);
            List uccMallBrandRelPOS = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
            Map<Object, Object> uccMallBrandRelMap = new HashMap();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccMallBrandRelPOS)) {
                uccMallBrandRelMap = uccMallBrandRelPOS.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
            }
            List uccCommodityTypePos = this.uccCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds);
            Map<Long, List<UccEMdmCatalogPO>> uccEmdmCatalogsMap = null;
            Map<Object, Object> uccCommodityTypesMap = new HashMap();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
                List catalogIds = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCatalogId).collect(Collectors.toList());
                List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
                uccEmdmCatalogsMap = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
                uccCommodityTypesMap = uccCommodityTypePos.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeId));
            }
            HashMap mappingMap = new HashMap();
            HashMap finalUccCommodityTypesMap = uccCommodityTypesMap;
            Map<Object, Object> finalUccMallBrandRelMap = uccMallBrandRelMap;
            List uccRelCatalogBrandVendorPOS = uccSkus.stream().map($ -> {
                UccMallBrandRelPO uccMallBrandRelPO = (UccMallBrandRelPO)finalUccMallBrandRelMap.get($.getBrandId());
                List uccCommodityTypePoList = (List)finalUccCommodityTypesMap.get($.getCommodityTypeId());
                if (Objects.nonNull(uccMallBrandRelPO) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccCommodityTypePoList)) {
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
                    UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)uccCommodityTypePoList.get(0);
                    uccRelCatalogBrandVendorPo.setBrandId(uccMallBrandRelPO.getMallBrandId());
                    uccRelCatalogBrandVendorPo.setVendorId($.getSupplierShopId());
                    uccRelCatalogBrandVendorPo.setCatalogId(uccCommodityTypePo.getCatalogId());
                    uccRelCatalogBrandVendorPo.setDiscountFlag(Integer.valueOf(0));
                    mappingMap.put($.getSkuId(), uccMallBrandRelPO.getMallBrandId() + "-" + $.getSupplierShopId() + "-" + uccCommodityTypePo.getCatalogId());
                    return uccRelCatalogBrandVendorPo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccRelCatalogBrandVendorPOS)) {
                return;
            }
            List listByParam = this.uccRelCatalogBrandVendorMapper.qryListByParam(uccRelCatalogBrandVendorPOS);
            List mapping = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listByParam)) {
                mapping = listByParam.stream().map($ -> $.getBrandId() + "-" + $.getVendorId() + "-" + $.getCatalogId()).collect(Collectors.toList());
            }
            ArrayList<UccSkuPo> failList = new ArrayList<UccSkuPo>();
            for (int i = 0; i < uccSkus.size(); ++i) {
                UccCommodityTypePo uccCommodityTypePo;
                List<UccEMdmCatalogPO> uccEMdmCatalogPOList;
                UccSkuPo uccSkuPo = uccSkus.get(i);
                UccSkuBrandPo uccSkuBrandPo = (UccSkuBrandPo)skuBrandMap.get(uccSkuPo.getSkuId());
                List uccCommodityTypePoList = (List)uccCommodityTypesMap.get(uccSkuPo.getCommodityTypeId());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccCommodityTypePoList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(uccEMdmCatalogPOList = uccEmdmCatalogsMap.get((uccCommodityTypePo = (UccCommodityTypePo)uccCommodityTypePoList.get(0)).getCatalogId()))) {
                    UccEMdmCatalogPO uccEMdmCatalogPO = uccEMdmCatalogPOList.get(0);
                    if (!Objects.nonNull(uccEMdmCatalogPO.getBrandVerify()) || 1 != uccEMdmCatalogPO.getBrandVerify()) continue;
                    String s = (String)mappingMap.get(uccSkuPo.getSkuId());
                    if (StringUtils.isEmpty((Object)s) || org.apache.commons.collections.CollectionUtils.isEmpty(mapping) || !mapping.contains(s)) {
                        failList.add(uccSkuPo);
                        continue;
                    }
                }
                if (uccSkuBrandPo == null || uccSkuBrandPo.getBrandId() == null) {
                    failList.add(uccSkuPo);
                    continue;
                }
                if (uccSkuBrandPo.getBrandStatus() == 1) continue;
                failList.add(uccSkuPo);
            }
            this.syncToEs(failList, ModelRuleConstant.SKU_STATUS_WAIT_MAPPING_BRAND, skuIds);
        }
        catch (Exception e) {
            log.error("waitDownSyncToEs error:{}", (Throwable)e);
        }
    }

    private void matchBrandSyncToEs(List<UccSkuPo> uccSkus) {
        try {
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkus)) {
                return;
            }
            List brandIds = uccSkus.stream().map(UccSkuPo::getBrandId).distinct().collect(Collectors.toList());
            List commodityTypeIds = uccSkus.stream().map(UccSkuPo::getCommodityTypeId).distinct().collect(Collectors.toList());
            List<Long> skuIds = uccSkus.stream().map(UccSkuPo::getSkuId).distinct().collect(Collectors.toList());
            try {
                this.dealSku(skuIds);
            }
            catch (Exception e) {
                log.error("matchBrandSyncToEs dealSku error:{}", (Throwable)e);
            }
            UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
            uccMallBrandRelPo.setBrandIds(brandIds);
            List uccMallBrandRelPOS = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccMallBrandRelPOS)) {
                return;
            }
            Map uccMallBrandRelMap = uccMallBrandRelPOS.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
            List uccCommodityTypePos = this.uccCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
                return;
            }
            List catalogIds = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCatalogId).collect(Collectors.toList());
            Map<Long, List<UccCommodityTypePo>> uccCommodityTypesMap = uccCommodityTypePos.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeId));
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                return;
            }
            Map<Long, List<UccEMdmCatalogPO>> uccEmdmCatalogsMap = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
            HashMap mappingMap = new HashMap();
            List uccRelCatalogBrandVendorPOS = uccSkus.stream().map($ -> {
                UccMallBrandRelPO uccMallBrandRelPO = (UccMallBrandRelPO)uccMallBrandRelMap.get($.getBrandId());
                List uccCommodityTypePoList = (List)uccCommodityTypesMap.get($.getCommodityTypeId());
                if (Objects.nonNull(uccMallBrandRelPO) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccCommodityTypePoList)) {
                    UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
                    UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)uccCommodityTypePoList.get(0);
                    uccRelCatalogBrandVendorPo.setBrandId(uccMallBrandRelPO.getMallBrandId());
                    uccRelCatalogBrandVendorPo.setVendorId($.getSupplierShopId());
                    uccRelCatalogBrandVendorPo.setCatalogId(uccCommodityTypePo.getCatalogId());
                    uccRelCatalogBrandVendorPo.setDiscountFlag(Integer.valueOf(0));
                    mappingMap.put($.getSkuId(), uccMallBrandRelPO.getMallBrandId() + "-" + $.getSupplierShopId() + "-" + uccCommodityTypePo.getCatalogId());
                    return uccRelCatalogBrandVendorPo;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccRelCatalogBrandVendorPOS)) {
                return;
            }
            List listByParam = this.uccRelCatalogBrandVendorMapper.qryListByParam(uccRelCatalogBrandVendorPOS);
            List mapping = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listByParam)) {
                mapping = listByParam.stream().map($ -> $.getBrandId() + "-" + $.getVendorId() + "-" + $.getCatalogId()).collect(Collectors.toList());
            }
            ArrayList<UccSkuPo> successList = new ArrayList<UccSkuPo>();
            for (int i = 0; i < uccSkus.size(); ++i) {
                UccEMdmCatalogPO uccEMdmCatalogPO;
                UccSkuPo uccSkuPo = uccSkus.get(i);
                List<UccCommodityTypePo> uccCommodityTypePoList = uccCommodityTypesMap.get(uccSkuPo.getCommodityTypeId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty(uccCommodityTypePoList)) continue;
                UccCommodityTypePo uccCommodityTypePo = uccCommodityTypePoList.get(0);
                List<UccEMdmCatalogPO> uccEMdmCatalogPOList = uccEmdmCatalogsMap.get(uccCommodityTypePo.getCatalogId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccEMdmCatalogPOList) && (Objects.isNull((uccEMdmCatalogPO = uccEMdmCatalogPOList.get(0)).getBrandVerify()) || 0 == uccEMdmCatalogPO.getBrandVerify())) {
                    successList.add(uccSkuPo);
                    continue;
                }
                String s = (String)mappingMap.get(uccSkuPo.getSkuId());
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(mapping) || StringUtils.isEmpty((Object)s) || !mapping.contains(s)) continue;
                successList.add(uccSkuPo);
            }
            this.syncToEs(successList, ModelRuleConstant.SKU_STATUS_WAIT_SHELF, skuIds);
        }
        catch (Exception e) {
            log.error("syncToEs error:{}", (Throwable)e);
        }
    }

    private void syncToEs(List<UccSkuPo> list, Integer operatorType, List<Long> allSkuIds) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            List skuIds = list.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            this.uccSkuMapper.batchUpdateSkuStatusByIds(skuIds, operatorType, null);
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
            syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
            syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
            syncSceneCommodityToEsReqBO.setSingleType(0);
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            allSkuIds = allSkuIds.stream().filter($ -> !skuIds.contains($)).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBOZkv = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBOZkv.setSkuIds(allSkuIds);
            syncSceneCommodityToEsReqBOZkv.setOperType(ModelRuleConstant.UPDATE_DISCOUNT_LIMIT);
            syncSceneCommodityToEsReqBOZkv.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBOZkv.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBOZkv);
        } else {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(allSkuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_DISCOUNT_LIMIT);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
    }

    private void checkParam(UccFreshProductUpDownStatusReqBO reqBO) {
        Assert.notNull((Object)reqBO, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)reqBO.getOperatorTypes(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void uccEMdmCatalog(Date date) {
        UccEMdmCatalogQryConditionPO uccEMdmCatalogQryConditionPO = new UccEMdmCatalogQryConditionPO();
        uccEMdmCatalogQryConditionPO.setUpdateTime(date);
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qureyByParam(uccEMdmCatalogQryConditionPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogPOS)) {
            List collect = uccEMdmCatalogPOS.stream().map(UccEMdmCatalogPO::getCatalogId).collect(Collectors.toList());
            List longs = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(collect);
            Integer count = this.uccSkuMapper.queryAllcount(longs);
            long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
            Page pageBO = new Page();
            pageBO.setPageSize(200);
            int page = 1;
            while ((long)page <= totalPage) {
                pageBO.setPageNo(page);
                List uccSkuPos = this.uccSkuMapper.queryAllByLimit(longs, pageBO);
                LOGGER.info("defaultHandler uccEMdmCatalog size:{}", (Object)uccSkuPos.size());
                this.updateEsBySku(uccSkuPos);
                ++page;
            }
        }
    }

    private void updateEsBySku(List<UccSkuPo> list) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return;
        }
        List commodityIds = list.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        List brandIds = list.stream().map(UccSkuPo::getBrandId).collect(Collectors.toList());
        List skuForEsPOS = this.uccSkuMapper.qrySkuAndLowPriceList(null, commodityIds);
        UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
        uccMallBrandRelPo.setBrandIds(brandIds);
        List list1 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
        Map<Long, UccMallBrandRelPO> collect = list1.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
        List collect3 = skuForEsPOS.stream().map(SkuForEsPO::getMgCatalogId).collect(Collectors.toList());
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(collect3);
        Map<Long, List<UccEMdmCatalogPO>> collect4 = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
        List<SkuForEsBO> skuForEsBOS = this.potoBo(skuForEsPOS, collect, collect4);
        this.checkMallBrand(skuForEsBOS);
        LOGGER.info("skuForEsBOS model:{}", (Object)JSON.toJSONString(skuForEsBOS));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuForEsBOS)) {
            return;
        }
        LOGGER.info("updateEsByBrandName \u672c\u6b21\u4efb\u52a1\u63d0\u4ea4\u5546\u54c1\u6761\u6570:{}", (Object)skuForEsBOS.size());
        for (int i = 0; i < skuForEsBOS.size(); ++i) {
            SkuForEsBO skuForEsBO = skuForEsBOS.get(i);
            JSONObject object = new JSONObject();
            object.put("brand_verify", (Object)skuForEsBO.getBrandVerify());
            object.put("govern_result", (Object)skuForEsBO.getDataGovernFlag());
            object.put("brandVerifyResult", (Object)skuForEsBO.getBrandVerifyResult());
            object.put("brandVerifyFailReason", (Object)skuForEsBO.getBrandVerifyFailReason());
            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuForEsBO.getSkuId().toString(), object);
        }
    }

    private List<Long> uccRelCatalogBrandVendor(Date date) {
        ArrayList models = new ArrayList();
        ArrayList listByParamAll = new ArrayList();
        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo = new UccRelCatalogBrandVendorPO();
        uccRelCatalogBrandVendorPo.setUpdateTimeStart(date);
        uccRelCatalogBrandVendorPo.setDiscountFlag(Integer.valueOf(0));
        List listByParam = this.uccRelCatalogBrandVendorMapper.getListByParam(uccRelCatalogBrandVendorPo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listByParam)) {
            listByParamAll.addAll(listByParam);
        }
        UccMallBrandRelPO uccMallBrandRelPo1 = new UccMallBrandRelPO();
        uccMallBrandRelPo1.setUpdateTimeStart(date);
        List list = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo1);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            List mallBrandIds = list.stream().map(UccMallBrandRelPO::getMallBrandId).collect(Collectors.toList());
            UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPo1 = new UccRelCatalogBrandVendorPO();
            uccRelCatalogBrandVendorPo1.setBrandIds(mallBrandIds);
            uccRelCatalogBrandVendorPo1.setDiscountFlag(Integer.valueOf(0));
            List listByParam1 = this.uccRelCatalogBrandVendorMapper.getListByParam(uccRelCatalogBrandVendorPo1);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listByParam1)) {
                listByParamAll.addAll(listByParam1);
            }
        }
        LOGGER.info("defaultHandler listByParam size:{}", (Object)listByParamAll.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(listByParamAll)) {
            List brandIds = listByParamAll.stream().map(UccRelCatalogBrandVendorPO::getBrandId).collect(Collectors.toList());
            List vendorIds = listByParamAll.stream().map(UccRelCatalogBrandVendorPO::getVendorId).collect(Collectors.toList());
            List catalogIds = listByParamAll.stream().map(UccRelCatalogBrandVendorPO::getCatalogId).collect(Collectors.toList());
            List commodityTypeIds = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(catalogIds);
            UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
            uccMallBrandRelPo.setMallBrandIds(brandIds);
            List list1 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
            List collect = list1.stream().map($ -> {
                UccBrandDealPO po = new UccBrandDealPO();
                po.setBrandName($.getMallBrandName());
                po.setBrandId($.getBrandId());
                return po;
            }).collect(Collectors.toList());
            models.addAll(collect);
            LOGGER.info("defaultHandler uccBrandDealPOS models:{}", (Object)JSON.toJSONString(models));
            UccBrandDealPO reqBO1 = new UccBrandDealPO();
            reqBO1.setUpdateTime(date);
            List uccBrandDealPOS1 = this.uccBrandDealMapper.selectBy(reqBO1);
            models.addAll(uccBrandDealPOS1);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(models)) {
                List brandIds1 = models.stream().distinct().map(UccBrandDealPO::getBrandId).collect(Collectors.toList());
                Integer count = this.uccSkuMapper.queryBrandIdsCount(brandIds1, vendorIds, commodityTypeIds);
                long totalPage = count % 200 == 0 ? (long)(count / 200) : (long)(count / 200 + 1);
                Page pageBO = new Page();
                pageBO.setPageSize(200);
                int page = 1;
                while ((long)page <= totalPage) {
                    pageBO.setPageNo(page);
                    List skuIds = this.uccSkuMapper.queryBrandIdsByLimit(brandIds1, vendorIds, commodityTypeIds, pageBO);
                    LOGGER.info("updateEsByBrandName skuIds:{},brandIds:{}", (Object)JSON.toJSONString((Object)skuIds), (Object)JSON.toJSONString(brandIds));
                    List skuBrandVerfyBySkuIds = this.uccSkuMapper.getSkuBrandVerfyBySkuIds(skuIds);
                    List commodityIds = skuBrandVerfyBySkuIds.stream().map(SkuSurPassVptPo::getCommodityId).collect(Collectors.toList());
                    List skuForEsPOS = this.uccSkuMapper.qrySkuAndLowPriceList(null, commodityIds);
                    UccMallBrandRelPO uccMallBrandRelPo2 = new UccMallBrandRelPO();
                    uccMallBrandRelPo2.setBrandIds(brandIds1);
                    List list2 = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo2);
                    Map<Long, UccMallBrandRelPO> collect1 = list2.parallelStream().collect(Collectors.toMap(UccMallBrandRelPO::getBrandId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
                    List collect3 = skuForEsPOS.stream().map(SkuForEsPO::getMgCatalogId).collect(Collectors.toList());
                    List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(collect3);
                    Map<Long, List<UccEMdmCatalogPO>> collect4 = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
                    List<SkuForEsBO> skuForEsBOS = this.potoBo(skuForEsPOS, collect1, collect4);
                    this.checkMallBrand(skuForEsBOS);
                    LOGGER.info("skuForEsBOS model:{}", (Object)JSON.toJSONString(skuForEsBOS));
                    LOGGER.info("updateEsByBrandName \u672c\u6b21\u4efb\u52a1\u63d0\u4ea4\u5546\u54c1\u6761\u6570:{}", (Object)skuForEsBOS.size());
                    for (int i = 0; i < skuForEsBOS.size(); ++i) {
                        SkuForEsBO skuForEsBO = skuForEsBOS.get(i);
                        JSONObject object = new JSONObject();
                        object.put("brand_verify", (Object)skuForEsBO.getBrandVerify());
                        object.put("govern_result", (Object)skuForEsBO.getDataGovernFlag());
                        object.put("brandVerifyResult", (Object)skuForEsBO.getBrandVerifyResult());
                        object.put("brandVerifyFailReason", (Object)skuForEsBO.getBrandVerifyFailReason());
                        this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuForEsBO.getSkuId().toString(), object);
                    }
                    ++page;
                }
            }
        }
        return null;
    }

    private List<SkuForEsBO> potoBo(List<SkuForEsPO> skuForEsPOS, Map<Long, UccMallBrandRelPO> collect, Map<Long, List<UccEMdmCatalogPO>> collect4) {
        ArrayList<SkuForEsBO> skuForEsBOS = new ArrayList<SkuForEsBO>();
        for (int i = 0; i < skuForEsPOS.size(); ++i) {
            List<UccEMdmCatalogPO> uccEMdmCatalogPOS;
            SkuForEsPO skuForEsPO = skuForEsPOS.get(i);
            SkuForEsBO skuForEsBO = new SkuForEsBO();
            BeanUtils.copyProperties((Object)skuForEsPO, (Object)skuForEsBO);
            UccMallBrandRelPO uccMallBrandRelPOS = collect.get(skuForEsBO.getBrandId());
            if (Objects.nonNull(uccMallBrandRelPOS)) {
                skuForEsBO.setMallBrandId(uccMallBrandRelPOS.getMallBrandId());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccEMdmCatalogPOS = collect4.get(skuForEsBO.getMgCatalogId()))) {
                skuForEsBO.setBrandVerify(uccEMdmCatalogPOS.get(0).getBrandVerify());
                skuForEsBO.setClassifyManager(uccEMdmCatalogPOS.get(0).getClassifyManager());
            }
            skuForEsBOS.add(skuForEsBO);
        }
        return skuForEsBOS;
    }

    private void checkMallBrand(List<SkuForEsBO> skuForEsBOS) {
        if (CollectionUtils.isEmpty(skuForEsBOS)) {
            return;
        }
        List skuIds = skuForEsBOS.stream().filter(a -> a.getSkuSource() != null && a.getSkuSource() == 2).map(a -> a.getSkuId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrand(skuIds);
        Map<Object, Object> skuBrandMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
            skuBrandMap = uccSkuBrandPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (a, b) -> a));
        }
        List mgCatalogIds = skuForEsBOS.stream().map(SkuForEsBO::getMgCatalogId).collect(Collectors.toList());
        List supplierShopIds = skuForEsBOS.stream().map(SkuForEsBO::getSupplierShopId).collect(Collectors.toList());
        List brandIds = uccSkuBrandPos.stream().map(UccSkuBrandPo::getBrandId).collect(Collectors.toList());
        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
        uccRelCatalogBrandVendorPO.setCatalogIds(mgCatalogIds);
        uccRelCatalogBrandVendorPO.setBrandIds(brandIds);
        uccRelCatalogBrandVendorPO.setVendorIds(supplierShopIds);
        uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getListByParam(uccRelCatalogBrandVendorPO);
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            if (skuForEsBO.getSkuSource() == null || skuForEsBO.getSkuSource() != 2) continue;
            if (skuForEsBO.getBrandVerify() != null && skuForEsBO.getBrandVerify() == 1) {
                UccSkuBrandPo skuBrandPo = (UccSkuBrandPo)skuBrandMap.get(skuForEsBO.getSkuId());
                if (skuBrandPo == null || skuBrandPo.getBrandId() == null) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(3));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getBrandStatus() != 1) {
                    if (skuBrandPo.getBrandStatus() == 2) {
                        skuForEsBO.setBrandVerifyResult(Integer.valueOf(3));
                        skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u54c1\u724c\u5e76\u672a\u4e0e\u5e73\u53f0\u54c1\u724c\u8fdb\u884c\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                        continue;
                    }
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (skuBrandPo.getAppRange() == null || skuBrandPo.getAppRange() == 2) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u6240\u5173\u8054\u5e73\u53f0\u54c1\u724c\u5e94\u7528\u8303\u56f4\u4e3a\u975e\u7535\u5546\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u66f4\u6539\u5e94\u7528\u8303\u56f4\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS) || !uccRelCatalogBrandVendorPOS.stream().map(UccRelCatalogBrandVendorPO::getBrandId).collect(Collectors.toList()).contains(skuForEsBO.getMallBrandId())) {
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u5546\u54c1\u8be5\u4f9b\u5e94\u5546\u6ca1\u6709\u4e0e\u8be5\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u8be5\u54c1\u724c\u505a\u5173\u8054\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u5173\u8054\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                List collect = uccRelCatalogBrandVendorPOS.stream().filter($ -> $.getBrandId().compareTo(skuForEsBO.getMallBrandId()) == 0).collect(Collectors.toList());
                if (((UccRelCatalogBrandVendorPO)collect.get(0)).getStatus() == null || ((UccRelCatalogBrandVendorPO)collect.get(0)).getStatus() != 1) {
                    log.error("\u67e5\u770b\u5173\u8054\u54c1\u724c\u65e5\u5fd7\uff1a========" + JSON.toJSON((Object)skuForEsBO.getSkuId()) + "\u72b6\u6001\u4e3a\uff1a" + JSON.toJSON((Object)((UccRelCatalogBrandVendorPO)collect.get(0)).getStatus()));
                    skuForEsBO.setBrandVerifyResult(Integer.valueOf(2));
                    skuForEsBO.setBrandVerifyFailReason("\u8be5\u4f9b\u5e94\u5546\u5546\u54c1\u7269\u8d44\u5206\u7c7b\u4e0b\u7684\u54c1\u724c\u5173\u8054\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u8bf7\u5148\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u542f\u7528\u4e4b\u540e\u518d\u63a8\u9001\u5546\u54c1\uff01");
                    continue;
                }
                skuForEsBO.setBrandVerifyResult(Integer.valueOf(1));
                continue;
            }
            skuForEsBO.setBrandVerifyResult(Integer.valueOf(0));
        }
    }
}

