/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.busibase.atom.api.UccSyncBrandToDGAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSyncBrandToDGAtomReqBo;
import com.tydic.commodity.busibase.busi.api.updateBranNameService;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandVersionMapper;
import com.tydic.commodity.estore.ability.api.UccBrandAuditService;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityRspBo;
import com.tydic.commodity.estore.atom.api.UccDealApprovalAtomService;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomRspBO;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccBrandVersionPO;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccBrandAuditService"})
public class UccBrandAuditServiceImpl
implements UccBrandAuditService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandAuditServiceImpl.class);
    @Autowired
    private UccBrandVersionMapper uccBrandVersionMapper;
    @Autowired
    private updateBranNameService updateBranNameService;
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDealApprovalAtomService uccDealApprovalAtomService;
    @Autowired
    private UccSyncBrandToDGAtomService uccSyncBrandToDGAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;

    @PostMapping(value={"updateBrandAudit"})
    public CceUccBrandApplyAuditAbilityRspBo updateBrandAudit(@RequestBody CceUccBrandApplyAuditAbilityReqBo reqBo) {
        CceUccBrandApplyAuditAbilityRspBo rspBo = new CceUccBrandApplyAuditAbilityRspBo();
        if (CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u5355\u636e\u4e3b\u952eID");
            return rspBo;
        }
        if (reqBo.getAuditType() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u7ed3\u679c");
            return rspBo;
        }
        if (reqBo.getAuditType() == 1 && StringUtils.isEmpty((Object)reqBo.getAuditAdvice())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u5ba1\u6279\u610f\u89c1");
            return rspBo;
        }
        ArrayList<UocApprovalLogPO> uocApprovalLogPOs = new ArrayList<UocApprovalLogPO>();
        try {
            reqBo.getIds().forEach($ -> uocApprovalLogPOs.add(this.taskTodoWaitService.listApproval($)));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u5ba1\u6279\u5f85\u529e\u524d\u7f6e\u83b7\u53d6\u673a\u6784\u4fe1\u606f get stationId error:{}", (Throwable)e);
        }
        Map<Long, Boolean> finishMap = this.dealAudit(reqBo, uocApprovalLogPOs);
        this.dealMainInfo(reqBo, finishMap, uocApprovalLogPOs);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @DuplicateCommitLimit
    private Map<Long, Boolean> dealAudit(CceUccBrandApplyAuditAbilityReqBo reqBo, List<UocApprovalLogPO> uocApprovalLogPOs) {
        HashMap<Long, Boolean> finishMap = new HashMap<Long, Boolean>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            UccBrandVersionPO brandApplyPO = new UccBrandVersionPO();
            brandApplyPO.setIds(reqBo.getIds());
            List brandApplyPOS = this.uccBrandVersionMapper.selectAll(brandApplyPO);
            Map<Object, Object> stepMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                if (reqBo.getType().equals("1")) {
                    stepMap = brandApplyPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getApprovalStep())).collect(Collectors.toMap(a -> a.getId(), a -> a.getApprovalStep()));
                } else if (reqBo.getType().equals("2")) {
                    stepMap = brandApplyPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getChangeApprovalStep())).collect(Collectors.toMap(a -> a.getId(), a -> a.getChangeApprovalStep()));
                }
            }
            UccDealApprovalAtomReqBO bo = new UccDealApprovalAtomReqBO();
            bo.setAuditAdvice(reqBo.getAuditAdvice());
            bo.setAuditResult(reqBo.getAuditType());
            bo.setUserId(reqBo.getUserId());
            bo.setUserName(reqBo.getName());
            bo.setObjType(1);
            bo.setOrgName(reqBo.getOrgName());
            for (Long id : reqBo.getIds()) {
                bo.setStepId((String)stepMap.get(id));
                bo.setObjId(id);
                UccDealApprovalAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAtomService.dealApproval(bo);
                if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25\uff1a" + dealApprovalAtomRspBO.getRespDesc());
                }
                if (!StringUtils.isEmpty((Object)dealApprovalAtomRspBO.getStepId())) {
                    UccBrandVersionPO set = new UccBrandVersionPO();
                    if (reqBo.getType().equals("1")) {
                        set.setApprovalStep(dealApprovalAtomRspBO.getStepId());
                    } else {
                        set.setChangeApprovalStep(dealApprovalAtomRspBO.getStepId());
                    }
                    set.setId(id);
                    this.uccBrandVersionMapper.update(set);
                }
                finishMap.put(id, dealApprovalAtomRspBO.getFinish());
            }
        }
        return finishMap;
    }

    private void dealMainInfo(CceUccBrandApplyAuditAbilityReqBo reqBo, Map<Long, Boolean> finishMap, List<UocApprovalLogPO> uocApprovalLogPOs) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            if (reqBo.getAuditType() == 0) {
                List finistList = reqBo.getIds().stream().filter(a -> finishMap.containsKey(a) && (Boolean)finishMap.get(a) != false).collect(Collectors.toList());
                for (Long Id : finistList) {
                    UccBrandVersionPO set = new UccBrandVersionPO();
                    if (reqBo.getType().equals("1")) {
                        set.setApprovalStatus(Integer.valueOf(2));
                        set.setAuditTime(new Date());
                        set.setAuditUserCode(reqBo.getOccupation());
                        set.setAuditUserName(reqBo.getName());
                        set.setId(Id);
                    } else {
                        set.setChangeApprovalStatus(Integer.valueOf(2));
                        set.setChangeAuditTime(new Date());
                        set.setChangeAuditUserCode(reqBo.getOccupation());
                        set.setChangeAuditUserName(reqBo.getName());
                        set.setId(Id);
                    }
                    this.syncRel(Id, reqBo);
                    this.uccBrandVersionMapper.update(set);
                }
                this.sendWaitMessage(reqBo, uocApprovalLogPOs);
            } else {
                for (Long id : reqBo.getIds()) {
                    UccBrandVersionPO set = new UccBrandVersionPO();
                    set.setReason(reqBo.getAuditAdvice());
                    set.setId(id);
                    if (reqBo.getType().equals("1")) {
                        set.setApprovalStatus(Integer.valueOf(3));
                        set.setAuditTime(new Date());
                        set.setAuditUserCode(reqBo.getOccupation());
                        set.setAuditUserName(reqBo.getName());
                    } else {
                        set.setChangeApprovalStatus(Integer.valueOf(3));
                        set.setChangeAuditTime(new Date());
                        set.setChangeAuditUserCode(reqBo.getOccupation());
                        set.setChangeAuditUserName(reqBo.getName());
                    }
                    set.setStatus(Integer.valueOf(5));
                    this.uccBrandVersionMapper.update(set);
                    this.sendWaitMessage(reqBo, uocApprovalLogPOs);
                }
            }
        }
    }

    private void sendWaitMessage(CceUccBrandApplyAuditAbilityReqBo reqBo, List<UocApprovalLogPO> uocApprovalLogPOs) {
        try {
            for (int i = 0; i < reqBo.getIds().size(); ++i) {
                Long id = (Long)reqBo.getIds().get(i);
                Map<Long, List<UocApprovalLogPO>> collect = uocApprovalLogPOs.stream().collect(Collectors.groupingBy(UocApprovalLogPO::getObjId));
                UccBrandVersionPO uccBrandVersionPO = new UccBrandVersionPO();
                uccBrandVersionPO.setId(id);
                UccBrandVersionPO uccBrandVersionModel = this.uccBrandVersionMapper.selectById(uccBrandVersionPO);
                TodoUccWaitAbilityReqBO todoParam = new TodoUccWaitAbilityReqBO();
                todoParam.setObjNo(uccBrandVersionModel.getBrandCode());
                todoParam.setOperatorType("1");
                todoParam.setObjId(uccBrandVersionModel.getId());
                todoParam.setCenterCode("commodity");
                if (reqBo.getType().equals("1")) {
                    todoParam.setBusiCode("2020");
                    todoParam.setBusiName("\u54c1\u724c\u7533\u8bf7\u5ba1\u6279");
                } else {
                    todoParam.setBusiCode("2021");
                    todoParam.setBusiName("\u54c1\u724c\u53d8\u66f4\u7533\u8bf7\u5ba1\u6279");
                }
                Long nextStationId = collect.get(id).get(0).getNextStationId();
                todoParam.setStationId(nextStationId + "");
                this.taskTodoWaitService.newBrandHandler(todoParam);
            }
        }
        catch (Exception e) {
            log.error("sendWaitMessage error:{}", (Object)reqBo.getIds());
        }
    }

    private void syncRel(Long finist, CceUccBrandApplyAuditAbilityReqBo reqBo) {
        UccBrandVersionPO uccBrandVersionPO = new UccBrandVersionPO();
        uccBrandVersionPO.setId(finist);
        UccBrandVersionPO uccBrandVersion = this.uccBrandVersionMapper.selectById(uccBrandVersionPO);
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(uccBrandVersion.getBrandId());
        UccBrandDealPO uccBrandDeal = this.mapper.selectByOne(uccBrandDealPO);
        log.info("^^^^^^^^^^^^^uccBrandDealuccBrandDealuccBrandDeal^^^^{}", (Object)JSON.toJSONString((Object)uccBrandDeal));
        UccBrandDealPO brandDealPO = (UccBrandDealPO)JSON.parseObject((String)JSON.toJSONString((Object)uccBrandVersion), UccBrandDealPO.class);
        if (ObjectUtils.isEmpty((Object)uccBrandDeal)) {
            this.mapper.insert(brandDealPO);
        } else {
            brandDealPO.setIsChange(Integer.valueOf(0));
            this.mapper.updateBrand(brandDealPO);
            CompletableFuture.runAsync(() -> {
                this.updateBranNameService.updateBranName(brandDealPO);
                if (0 == brandDealPO.getBrandStatus()) {
                    this.syncState(brandDealPO, reqBo);
                }
            });
        }
        try {
            UccSyncBrandToDGAtomReqBo uccSyncBrandToDGAtomReqBo = new UccSyncBrandToDGAtomReqBo();
            uccSyncBrandToDGAtomReqBo.setBrandIds((List)Lists.newArrayList((Object[])new Long[]{brandDealPO.getBrandId()}));
            this.uccSyncBrandToDGAtomService.dealSyncBrandToDG(uccSyncBrandToDGAtomReqBo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void syncState(UccBrandDealPO brandDealPO, CceUccBrandApplyAuditAbilityReqBo reqBo) {
        try {
            log.info("\u8c03\u7528\u54c1\u724c\u6279\u91cfMQ\u63a5\u53e3\uff0c\u54c1\u724cID:{}", (Object)JSON.toJSONString((Object)brandDealPO));
            UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
            esReqBO.setBrandId(brandDealPO.getBrandId());
            esReqBO.setReason(reqBo.getName() + "\u64cd\u4f5c\u4e86" + brandDealPO.getBrandName() + "\u54c1\u724c\u505c\u7528");
            this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
        }
    }
}

