/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccRelCatalogVendorDiscountMapper;
import com.tydic.commodity.estore.ability.api.UccCatalogVendorDiscountImportAbilityService;
import com.tydic.commodity.estore.ability.bo.UccCatalogVendorDiscountImportReqBO;
import com.tydic.commodity.estore.ability.bo.UccCatalogVendorDiscountImportRspBO;
import com.tydic.commodity.estore.ability.impl.CatalogVendorDiscountImportThread;
import com.tydic.commodity.estore.busi.api.UccBatchSetDiscountCatalogBrandVendorSaveBusiService;
import com.tydic.commodity.estore.utils.ExcelUtils;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.po.CatalogBrandNoRelPO;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccImportCatalogVendorDiscountPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccRelCatalogVendorDiscountPO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccCatalogVendorDiscountImportAbilityService"})
public class UccCatalogVendorDiscountImportAbilityServiceImpl
implements UccCatalogVendorDiscountImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogVendorDiscountImportAbilityServiceImpl.class);
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private UccRelCatalogVendorDiscountMapper uccRelCatalogVendorDiscountMapper;
    private static final String importType = "UCC_CATALOG_VENDOR_DOWNLOAD_TEPLET";
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccBatchSetDiscountCatalogBrandVendorSaveBusiService uccBatchSetDiscountCatalogBrandVendorSaveBusiService;

    @PostMapping(value={"importCataLogVendorDiscount"})
    public UccCatalogVendorDiscountImportRspBO importCataLogVendorDiscount(@RequestBody UccCatalogVendorDiscountImportReqBO reqBO) {
        UccCatalogVendorDiscountImportRspBO rspBO = new UccCatalogVendorDiscountImportRspBO();
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            String dateString = DateUtils.dateToStrAsFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + dateString + "ccCataLogVendorDiscount.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getImportUrl(), file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
                this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateTitle(title, reqBO);
        ArrayList<UccImportCatalogVendorDiscountPO> uccRelCatalogVendorDiscountPOS = new ArrayList<UccImportCatalogVendorDiscountPO>();
        this.getItemImport(uccRelCatalogVendorDiscountPOS, data, reqBO);
        if (uccRelCatalogVendorDiscountPOS.isEmpty()) {
            throw new BusinessException("8888", "\u6a21\u677f\u89e3\u6790\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        System.out.println("\u89e3\u6790\u6570\u636e\u6570\u91cf\u4e3a\uff1a" + uccRelCatalogVendorDiscountPOS.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String format = sdf.format(new Date());
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-impost-catalogVendor" + format).build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(3, 8, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        List<List<UccImportCatalogVendorDiscountPO>> lists = UccCatalogVendorDiscountImportAbilityServiceImpl.splitList(uccRelCatalogVendorDiscountPOS, 10);
        for (List<UccImportCatalogVendorDiscountPO> pos : lists) {
            CatalogVendorDiscountImportThread importThread = new CatalogVendorDiscountImportThread();
            importThread.setReqBO(reqBO);
            importThread.setUccBatchSetDiscountCatalogBrandVendorSaveBusiService(this.uccBatchSetDiscountCatalogBrandVendorSaveBusiService);
            importThread.setUccBrandExtMapper(this.uccBrandExtMapper);
            importThread.setUccDictionaryAtomService(this.uccDictionaryAtomService);
            importThread.setUccEMdmCatalogMapper(this.uccEMdmCatalogMapper);
            importThread.setUccImportCatalogVendorDiscountPO(pos);
            importThread.setUccRelCatalogVendorDiscountMapper(this.uccRelCatalogVendorDiscountMapper);
            fixedThreadPool.submit(importThread);
        }
        List<Map<String, Object>> exportData = this.exportImportResults(uccRelCatalogVendorDiscountPOS, reqBO);
        log.info("------\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString(exportData));
        Long sucessImportCounts = 0L;
        Long failedImportCounts = 0L;
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(exportData, reqBO, sucessImportCounts, failedImportCounts);
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        rspBO.setImpType(importType);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public void dealItemImport(List<UccImportCatalogVendorDiscountPO> uccImportCatalogVendorDiscountPO, List<UccRelCatalogVendorDiscountPO> uccRelCatalogVendorDiscountPO, List<UccRelCatalogBrandVendorPO> uccRelCatalogBrandVendorPOS, UccCatalogVendorDiscountImportReqBO reqBO) {
        List vendorList = this.uccDictionaryAtomService.queryBypCodeBackPo("ec_vendor_id");
        Map<String, DicDictionaryPo> collect = vendorList.stream().collect(Collectors.toMap(DicDictionaryPo::getTitle, a -> a, (k1, k2) -> k1));
        uccImportCatalogVendorDiscountPO.forEach(u -> {
            if (u.getImpResult() == 1) {
                return;
            }
            DicDictionaryPo dicDictionaryPo = (DicDictionaryPo)collect.get(u.getVendorName());
            if (dicDictionaryPo == null) {
                u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\u6709\u8bef");
                u.setImpResult(Integer.valueOf(1));
                return;
            }
            u.setImpResult(Integer.valueOf(0));
            UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatalogCode(u.getCataLogCode());
            if (uccEMdmCatalogPO == null) {
                u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u672a\u67e5\u8be2\u5230\u7269\u6599\u4fe1\u606f");
                u.setImpResult(Integer.valueOf(1));
                return;
            }
            u.setImpResult(Integer.valueOf(0));
            if (reqBO.getImpType() == 0) {
                UccRelCatalogVendorDiscountPO qryPo = new UccRelCatalogVendorDiscountPO();
                qryPo.setCatalogId(uccEMdmCatalogPO.getCatalogId());
                qryPo.setVendorId(Long.valueOf(dicDictionaryPo.getCode()));
                qryPo.setStatus(Integer.valueOf(1));
                UccRelCatalogVendorDiscountPO modelBy = this.uccRelCatalogVendorDiscountMapper.getModelBy(qryPo);
                if (modelBy != null) {
                    UccRelCatalogVendorDiscountPO po = new UccRelCatalogVendorDiscountPO();
                    po.setDiscount(u.getDiscount());
                    po.setUpdateTime(new Date());
                    po.setUpdateOperName(reqBO.getName());
                    po.setUpdateOperId(reqBO.getUsername());
                    UccRelCatalogVendorDiscountPO where = new UccRelCatalogVendorDiscountPO();
                    where.setRelId(modelBy.getRelId());
                    this.uccRelCatalogVendorDiscountMapper.updateBy(po, where);
                    return;
                }
                u.setImpResult(Integer.valueOf(0));
                UccRelCatalogVendorDiscountPO insertPo = new UccRelCatalogVendorDiscountPO();
                insertPo.setCatalogId(uccEMdmCatalogPO.getCatalogId());
                insertPo.setVendorId(Long.valueOf(dicDictionaryPo.getCode()));
                insertPo.setStatus(Integer.valueOf(1));
                insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                insertPo.setDiscount(u.getDiscount());
                insertPo.setUpdateOperId(reqBO.getUsername());
                insertPo.setUpdateOperName(reqBO.getName());
                insertPo.setUpdateTime(new Date());
                insertPo.setCreateOperId(reqBO.getUsername());
                insertPo.setCreateOperName(reqBO.getName());
                insertPo.setCreateTime(new Date());
                uccRelCatalogVendorDiscountPO.add(insertPo);
            } else {
                UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                insertPo.setCatalogId(uccEMdmCatalogPO.getCatalogId());
                insertPo.setCatalogCode(u.getCataLogCode());
                insertPo.setVendorName(u.getVendorName());
                insertPo.setBrandName(u.getBrandName());
                insertPo.setBelongOrg(u.getBelongOrg());
                insertPo.setVendorId(Long.valueOf(dicDictionaryPo.getCode()));
                insertPo.setStatus(Integer.valueOf(3));
                insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                insertPo.setDiscount(u.getDiscount());
                insertPo.setUpdateOperId(reqBO.getUsername());
                insertPo.setUpdateOperName(reqBO.getName());
                insertPo.setUpdateTime(new Date());
                insertPo.setCreateOperId(reqBO.getUsername());
                insertPo.setCreateOperName(reqBO.getName());
                insertPo.setCreateTime(new Date());
                insertPo.setDiscountFlag(Integer.valueOf(1));
                CatalogBrandNoRelPO catalogBrandNoRelPo = new CatalogBrandNoRelPO();
                catalogBrandNoRelPo.setBelongOrg(u.getBelongOrg());
                catalogBrandNoRelPo.setBrandName(u.getBrandName());
                Page page = new Page(1, 1);
                List catalogBrandNoRelList = this.uccBrandExtMapper.getCatalogBrandNoRelList(catalogBrandNoRelPo, page);
                if (CollectionUtils.isEmpty((Collection)catalogBrandNoRelList)) {
                    u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u54c1\u724c\u4e0d\u5b58\u5728\u6216\u8005\u72b6\u6001\u672a\u542f\u7528\u6216\u8005\u8be5\u54c1\u724c\u5e94\u7528\u8303\u56f4\u4e0d\u4e3a\u7535\u5546\uff0c\u8bf7\u68c0\u67e5\u54c1\u724c\u6570\u636e");
                    u.setImpResult(Integer.valueOf(1));
                    return;
                }
                insertPo.setBrandId(((CatalogBrandNoRelPO)catalogBrandNoRelList.get(0)).getBrandId());
                u.setImpResult(Integer.valueOf(0));
                List existList = uccRelCatalogBrandVendorPOS.stream().filter(a -> a.getCatalogCode().equals(u.getCataLogCode()) && a.getVendorName().equals(u.getVendorName()) && a.getBrandName().equals(u.getBrandName()) && a.getBelongOrg().equals(u.getBelongOrg())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(existList)) {
                    u.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u7684\u6570\u636e\u91cd\u590d");
                    u.setImpResult(Integer.valueOf(1));
                    return;
                }
                u.setImpResult(Integer.valueOf(0));
                uccRelCatalogBrandVendorPOS.add(insertPo);
            }
        });
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(6);
            int rowLength = sheet.getLastRowNum();
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                title.add(cell.toString().trim());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 0; i <= rowLength && (row = sheet.getRow(i + 8)) != null; ++i) {
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)UccCatalogVendorDiscountImportAbilityServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
            log.info("\u5bfc\u5165\u4f9b\u5e94\u5546\u6298\u6263\u7387\u8868\u5934" + JSON.toJSONString(title));
            log.info("\u5bfc\u5165\u4f9b\u5e94\u5546\u6298\u6263\u7387\u6570\u636e" + JSON.toJSONString((Object)jsonArray));
        }
        catch (Exception e) {
            log.error("getExcelDateByImport error\uff1a" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            log.error("getCellValueByCell error\uff1a" + e);
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = BigDecimal.valueOf(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    private void validateTitle(List<String> title, UccCatalogVendorDiscountImportReqBO reqBO) {
        String titleTemplate = "\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *|\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *|\u4f9b\u5e94\u5546 *|\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09*|";
        if (reqBO.getImpType() != 0) {
            titleTemplate = "\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *|\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *|\u54c1\u724c\u540d\u79f0 *|\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *|\u4f9b\u5e94\u5546 *|\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09*|";
        }
        String currentTitile = "";
        for (String s : title) {
            currentTitile = currentTitile + s.trim() + "|";
        }
        if (!titleTemplate.equals(currentTitile)) {
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e");
        }
    }

    List<UccImportCatalogVendorDiscountPO> getItemImport(List<UccImportCatalogVendorDiscountPO> uccRelCatalogVendorDiscountPOS, JSONObject data, UccCatalogVendorDiscountImportReqBO reqBO) {
        JSONArray excelJSON = data.getJSONArray("excelJSON");
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            UccImportCatalogVendorDiscountPO itemPO = new UccImportCatalogVendorDiscountPO();
            JSONObject next = (JSONObject)iterator.next();
            itemPO.setCataLogCode(next.getString("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *"));
            itemPO.setCataLogName(next.getString("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *"));
            itemPO.setVendorName(next.getString("\u4f9b\u5e94\u5546 *"));
            itemPO.setBrandName(next.getString("\u54c1\u724c\u540d\u79f0 *"));
            itemPO.setBelongOrg(next.getString("\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *"));
            String discount = next.getString("\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09*");
            itemPO.setImpResult(Integer.valueOf(0));
            if (discount == null || "".equals(discount)) {
                itemPO.setDiscount(null);
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u6298\u6263\u7387\u6700\u5927\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (discount.contains("%")) {
                itemPO.setDiscount(new BigDecimal(discount.substring(0, discount.charAt(37))));
            } else {
                itemPO.setDiscount(new BigDecimal(discount));
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getCataLogCode())) {
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getCataLogName())) {
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getVendorName())) {
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getImpType() == 1 && StringUtils.isEmpty((CharSequence)itemPO.getBrandName())) {
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getImpType() == 1 && StringUtils.isEmpty((CharSequence)itemPO.getBelongOrg())) {
                itemPO.setImpResult(Integer.valueOf(1));
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uccRelCatalogVendorDiscountPOS.add(itemPO);
        }
        return uccRelCatalogVendorDiscountPOS;
    }

    private List<Map<String, Object>> exportImportResults(List<UccImportCatalogVendorDiscountPO> uccRelCatalogVendorDiscountPOS, UccCatalogVendorDiscountImportReqBO reqBO) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (UccImportCatalogVendorDiscountPO discountPO : uccRelCatalogVendorDiscountPOS) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *", discountPO.getCataLogCode() != null ? discountPO.getCataLogCode() : "");
            item.put("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *", discountPO.getCataLogName() != null ? discountPO.getCataLogName() : "");
            item.put("\u4f9b\u5e94\u5546 *", discountPO.getVendorName() != null ? discountPO.getVendorName() : "");
            if (reqBO.getImpType() == 1) {
                item.put("\u54c1\u724c\u540d\u79f0 *", discountPO.getBrandName() != null ? discountPO.getBrandName() : "");
                item.put("\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *", discountPO.getBelongOrg() != null ? discountPO.getBelongOrg() : "");
            }
            item.put("\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09*", discountPO.getDiscount() != null ? discountPO.getDiscount() : "");
            if (discountPO.getImpResult() != null && discountPO.getImpResult() == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (discountPO.getImpResult() != null && discountPO.getImpResult() == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", discountPO.getImpRemark());
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, UccCatalogVendorDiscountImportReqBO reqBO, Long sucessImportCounts, Long failedImportCounts) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType(importType);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    public static List<List<UccImportCatalogVendorDiscountPO>> splitList(List<UccImportCatalogVendorDiscountPO> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<UccImportCatalogVendorDiscountPO>> result = new ArrayList<List<UccImportCatalogVendorDiscountPO>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<UccImportCatalogVendorDiscountPO> subList = list.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }
}

