/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCollectMapper;
import com.tydic.commodity.estore.ability.api.UccCollectDealAbilityService;
import com.tydic.commodity.estore.ability.bo.UccCollectDealAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccCollectDealAbilityRspBO;
import com.tydic.commodity.po.UccCollectPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccCollectDealAbilityService"})
public class UccCollectDealAbilityServiceImpl
implements UccCollectDealAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCollectDealAbilityServiceImpl.class);
    @Autowired
    private UccCollectMapper uccCollectMapper;

    @PostMapping(value={"dealCollect"})
    public UccCollectDealAbilityRspBO dealCollect(@RequestBody UccCollectDealAbilityReqBO reqBO) {
        this.val(reqBO);
        UccCollectPO modelBy = new UccCollectPO();
        modelBy.setSkuId(reqBO.getSkuId());
        modelBy = this.uccCollectMapper.getModelBy(modelBy);
        if (modelBy == null) {
            UccCollectPO insertPO = new UccCollectPO();
            insertPO.setSkuId(reqBO.getSkuId());
            if (reqBO.getDealType() == 1) {
                insertPO.setLookNum(Integer.valueOf(1));
                insertPO.setCollectNum(Integer.valueOf(0));
            } else {
                insertPO.setLookNum(Integer.valueOf(1));
                insertPO.setCollectNum(Integer.valueOf(1));
            }
            try {
                this.uccCollectMapper.insert(insertPO);
            }
            catch (DuplicateKeyException E) {
                this.uccCollectMapper.updateCollect(reqBO.getSkuId(), reqBO.getDealType().intValue());
            }
        } else {
            this.uccCollectMapper.updateCollect(reqBO.getSkuId(), reqBO.getDealType().intValue());
        }
        UccCollectDealAbilityRspBO rspBO = new UccCollectDealAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(UccCollectDealAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSkuId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[skuId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getDealType() == null || reqBO.getDealType() != 1 && reqBO.getDealType() != 2) {
            throw new BusinessException("0001", "\u5165\u53c2[dealType]\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
    }
}

