/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.estore.atom.api.UccGovernMaterialPushAtomService;
import com.tydic.commodity.estore.atom.bo.UccGovernMaterialPushAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccGovernMaterialPushAtomRspBO;
import com.tydic.commodity.po.UccPushLogPO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccGovernMaterialPushAtomServiceImpl
implements UccGovernMaterialPushAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccGovernMaterialPushAtomServiceImpl.class);
    @Autowired
    private UccPushLogMapper uccPushLogMapper;
    @Value(value="${STANDARD_CODE_APPLICATION_URL:${ESB_ACCESS_IP}/OSN/api/standardAppyCodeGovern/v1}")
    private String STANDARD_CODE_APPLICATION_URL;

    @Override
    public UccGovernMaterialPushAtomRspBO dealGovernMaterialPush(UccGovernMaterialPushAtomReqBO reqBO) {
        String serialNumber = null;
        try {
            serialNumber = ESBParamUtil.getSerialNumber();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("8888", (Object)"\u5e8f\u5217\u53f7\u83b7\u53d6\u5931\u8d25");
        }
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)serialNumber);
        JSONArray array = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("userName", (Object)reqBO.getName());
        item.put("userId", (Object)reqBO.getUserId());
        item.put("standardComIdList", reqBO.getExtStandardComIds());
        array.add((Object)item);
        data.put("data", (Object)array);
        String reqStr = JSON.toJSONString((Object)data);
        UccPushLogPO uccPushLogPO = new UccPushLogPO();
        uccPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uccPushLogPO.setCreateTime(new Date());
        uccPushLogPO.setType(Integer.valueOf(100));
        uccPushLogPO.setReqJson(reqStr);
        Object respStr = null;
        try {
            log.info("\u8d4b\u7801\u7533\u8bf7\u5165\u53c2\uff1a" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.STANDARD_CODE_APPLICATION_URL), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            log.info("\u8d4b\u7801\u7533\u8bf7\u51fa\u53c2" + JSON.toJSONString((Object)httpRetBean));
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8d4b\u7801\u7533\u8bf7\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8d4b\u7801\u7533\u8bf7\u63a8\u9001\u6570\u636e\u6cbb\u7406-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                uccPushLogPO.setStatus(Integer.valueOf(0));
            } else {
                uccPushLogPO.setStatus(Integer.valueOf(1));
            }
            uccPushLogPO.setRspJson(returnString);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u6807\u54c1\u8be6\u60c5\u5f02\u5e38 {}", (Object)e.getMessage());
            uccPushLogPO.setStatus(Integer.valueOf(0));
            uccPushLogPO.setRspJson(e.getMessage());
        }
        this.uccPushLogMapper.insert(uccPushLogPO);
        UccGovernMaterialPushAtomRspBO rspBO = new UccGovernMaterialPushAtomRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

