/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.dao.ApplyShelvesFormItemMapper;
import com.tydic.commodity.dao.ApplyShelvesFormItemSkuMapper;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.dao.ApplyShelvesFormVendorMapper;
import com.tydic.commodity.estore.ability.api.UccApplyShelvesFormFeedBackAbilityService;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesFormFeedBackReqBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesFormFeedBackRspBO;
import com.tydic.commodity.estore.busi.api.UccApplyShelvesFormBusiService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccApplyShelvesFormFeedBackAbilityService"})
public class UccApplyShelvesFormFeedBackAbilityServiceImpl
implements UccApplyShelvesFormFeedBackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyShelvesFormFeedBackAbilityServiceImpl.class);
    @Autowired
    private UccApplyShelvesFormBusiService uccApplyShelvesFormBusiService;
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private ApplyShelvesFormVendorMapper applyShelvesFormVendorMapper;
    @Autowired
    private ApplyShelvesFormItemMapper applyShelvesFormItemMapper;
    @Autowired
    private ApplyShelvesFormItemSkuMapper applyShelvesFormItemSkuMapper;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;

    @PostMapping(value={"dealApplyShelvesFormFeedBack"})
    public UccApplyShelvesFormFeedBackRspBO dealApplyShelvesFormFeedBack(@RequestBody UccApplyShelvesFormFeedBackReqBO reqBO) {
        this.validateParams(reqBO);
        UccApplyShelvesFormFeedBackRspBO rspBO = this.uccApplyShelvesFormBusiService.dealApplyShelvesFormFeedBack(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UccSendNotificationExtAtomReqBO uccSendNotificationExtAtomReqBO = new UccSendNotificationExtAtomReqBO();
            uccSendNotificationExtAtomReqBO.setApplyId(reqBO.getApplyId());
            uccSendNotificationExtAtomReqBO.setFeedBackType(reqBO.getFeedBackType());
            uccSendNotificationExtAtomReqBO.setVendorId(reqBO.getVendorId());
            uccSendNotificationExtAtomReqBO.setIsDealApplyShelvesFormFeedBack(Integer.valueOf(1));
            try {
                log.info("\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u7ba1\u7406\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccSendNotificationExtAtomReqBO));
                this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSON.toJSONString((Object)uccSendNotificationExtAtomReqBO)));
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u7ba1\u7406\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)uccSendNotificationExtAtomReqBO));
            }
        }
        return rspBO;
    }

    private void validateParams(UccApplyShelvesFormFeedBackReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u4e0a\u67b6\u7533\u8bf7\u5355\u53cd\u9988API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getApplyId()) {
            throw new BusinessException("0001", "\u4e0a\u67b6\u7533\u8bf7\u5355\u53cd\u9988API\u5165\u53c2\u3010applyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFeedBackType()) {
            throw new BusinessException("0001", "\u4e0a\u67b6\u7533\u8bf7\u5355\u53cd\u9988API\u5165\u53c2\u3010feedBackType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFeedBackType() != 1 && reqBO.getFeedBackType() != 2) {
            throw new BusinessException("0002", "\u4e0a\u67b6\u7533\u8bf7\u5355\u53cd\u9988API\u5165\u53c2\u3010feedBackType\u3011\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        if (reqBO.getFeedBackType() == 2 && reqBO.getVendorId() == null) {
            throw new BusinessException("0001", "\u4e0a\u67b6\u7533\u8bf7\u5355\u53cd\u9988API\u5165\u53c2\u7533\u8bf7\u5355ID\u3010vendorId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

