/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccEMdmCatalogBO;
import com.tydic.commodity.base.bo.UccSkuAddPriceQryBO;
import com.tydic.commodity.busibase.busi.api.UccMasterDataCategoryQryBusiService;
import com.tydic.commodity.busibase.busi.bo.UccMasterDataCategoryQryReqBO;
import com.tydic.commodity.busibase.busi.bo.UccMasterDataCategoryQryRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceListQueryRspBO;
import com.tydic.commodity.po.CnncUccSkuAddPricePO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceListQueryService"})
public class UccSkuAddPriceListQueryServiceImpl
implements UccSkuAddPriceListQueryService {
    private static final Logger logger = LoggerFactory.getLogger(UccSkuAddPriceListQueryServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccEMdmCatalogMapper cnncUccEMdmCatalogMapper;
    @Autowired
    private UccMasterDataCategoryQryBusiService uccMasterDataCategoryQryBusiService;

    @PostMapping(value={"querySkuAddPriceList"})
    public UccSkuAddPriceListQueryRspBO querySkuAddPriceList(@RequestBody UccSkuAddPriceListQueryReqBO reqBO) {
        logger.info("\u5355\u54c1\u52a0\u4ef7\u7cfb\u6570\u5217\u8868\u5206\u9875\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        UccSkuAddPriceListQueryRspBO rspBO = new UccSkuAddPriceListQueryRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getExtSkuId())) {
            reqBO.setExtSkuId(null);
        }
        if (StringUtils.isEmpty((Object)reqBO.getSkuName())) {
            reqBO.setSkuName(null);
        }
        List<String> supplierShopIds = null;
        List<String> extSpus = null;
        List<String> extSkus = null;
        List<String> skuCodes = null;
        if (reqBO.getSupplierId() != null && !"".equals(reqBO.getSupplierId())) {
            supplierShopIds = Arrays.asList(reqBO.getSupplierId().split(","));
        }
        if (reqBO.getExtSkuId() != null && !"".equals(reqBO.getExtSkuId())) {
            extSkus = Arrays.asList(reqBO.getExtSkuId().split(","));
        }
        if (reqBO.getExtSpuId() != null && !"".equals(reqBO.getExtSpuId())) {
            extSpus = Arrays.asList(reqBO.getExtSpuId().split(","));
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getSkuCode())) {
            skuCodes = Arrays.asList(reqBO.getSkuCode().split(","));
            reqBO.setSkuCode("");
        }
        UccSkuAddPriceQryBO uccSkuAddPriceQryBO = new UccSkuAddPriceQryBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuAddPriceQryBO);
        uccSkuAddPriceQryBO.setSupplierShopId(supplierShopIds);
        uccSkuAddPriceQryBO.setExtSpuId(extSpus);
        uccSkuAddPriceQryBO.setExtSkuId(extSkus);
        uccSkuAddPriceQryBO.setSkuCodes(skuCodes);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        logger.info("\u67e5\u8be2\u5355\u54c1\u52a0\u4ef7\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccSkuAddPriceQryBO));
        List cnncUccSkuAddPricePOS = this.uccSkuAddCoefficientMapper.queryPage(uccSkuAddPriceQryBO, page);
        if (!CollectionUtils.isEmpty((Collection)cnncUccSkuAddPricePOS)) {
            ArrayList<UccSkuAddPriceListQueryInfoBO> rows = new ArrayList<UccSkuAddPriceListQueryInfoBO>(16);
            for (CnncUccSkuAddPricePO uccSkuAddPricePO : cnncUccSkuAddPricePOS) {
                List categoryRows;
                UccSkuAddPriceListQueryInfoBO uccSkuAddPriceListQueryInfoBO = new UccSkuAddPriceListQueryInfoBO();
                BeanUtils.copyProperties((Object)uccSkuAddPricePO, (Object)uccSkuAddPriceListQueryInfoBO);
                ArrayList<Long> catalogIds = new ArrayList<Long>();
                catalogIds.add(uccSkuAddPriceListQueryInfoBO.getCatalogId());
                List<UccEMdmCatalogPO> parent = this.findParent(catalogIds);
                StringBuffer catalogName = new StringBuffer();
                for (int i = parent.size() - 1; i >= 0; --i) {
                    catalogName.append(parent.get(i).getCatalogName()).append("/");
                }
                if (!StringUtils.isEmpty((Object)catalogName) && catalogName.length() > 1) {
                    catalogName.deleteCharAt(catalogName.length() - 1);
                    uccSkuAddPriceListQueryInfoBO.setCatalogName(catalogName.toString());
                }
                UccMasterDataCategoryQryReqBO uccMasterDataCategoryQryReqBO = new UccMasterDataCategoryQryReqBO();
                uccMasterDataCategoryQryReqBO.setCatalogId(uccSkuAddPriceListQueryInfoBO.getCatalogId());
                UccMasterDataCategoryQryRspBO uccMasterDataCategoryQryRspBO1 = this.uccMasterDataCategoryQryBusiService.qryCategory(uccMasterDataCategoryQryReqBO);
                if ("0000".equals(uccMasterDataCategoryQryRspBO1.getRespCode()) && (categoryRows = uccMasterDataCategoryQryRspBO1.getRows()) != null && categoryRows.size() > 0) {
                    uccSkuAddPriceListQueryInfoBO.setCatalogCode(((UccEMdmCatalogBO)categoryRows.get(0)).getCatalogCode());
                }
                uccSkuAddPriceListQueryInfoBO.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getAgreementPrice()));
                uccSkuAddPriceListQueryInfoBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getSalePrice()));
                uccSkuAddPriceListQueryInfoBO.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)uccSkuAddPriceListQueryInfoBO.getMarketPrice()));
                if (uccSkuAddPriceListQueryInfoBO.getUpdateTime() != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    uccSkuAddPriceListQueryInfoBO.setUpdateTimeStr(simpleDateFormat.format(uccSkuAddPriceListQueryInfoBO.getUpdateTime()));
                }
                rows.add(uccSkuAddPriceListQueryInfoBO);
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalCount());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(List<Long> catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        List qryRspList = this.cnncUccEMdmCatalogMapper.queryByIds(catalogId);
        if (CollectionUtils.isEmpty((Collection)qryRspList)) {
            return poList;
        }
        poList.addAll(qryRspList);
        ArrayList<Long> next = new ArrayList<Long>();
        qryRspList.forEach(a -> {
            if (a.getCatalogLevel() > 1) {
                next.add(a.getParentCatalogId());
            }
        });
        if (CollectionUtils.isEmpty(next)) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(next);
        poList.addAll(parent);
        return poList;
    }
}

