/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.dao.UccCommodityPicLogMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicLogMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.estore.ability.bo.UccPicCompressAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccPicCompressAbilityRspBo;
import com.tydic.commodity.estore.busi.api.UccPicCompressBusiService;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.estore.utils.PicUtils;
import com.tydic.commodity.po.UccCommodityPicLogPO;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccSkuPicLogPo;
import com.tydic.commodity.po.UccSkuPicPo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccPicCompressBusiServiceImpl
implements UccPicCompressBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccPicCompressBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPicLogMapper uccSkuPicLogMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPicLogMapper uccCommodityPicLogMapper;
    @Value(value="${pic_compress_size:150}")
    private long size;
    @Autowired
    private FileUpLoad fileUpLoad;

    @Override
    public UccPicCompressAbilityRspBo dealPicCompress(UccPicCompressAbilityReqBo reqBo) {
        UccPicCompressAbilityRspBo rspBo = new UccPicCompressAbilityRspBo();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            List uccSkuPicPos;
            List commodityIds;
            List uccCommodityPicPos;
            List uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
            if (!CollectionUtils.isEmpty((Collection)uccSkuPos) && !CollectionUtils.isEmpty((Collection)(uccCommodityPicPos = this.uccCommodityPicMapper.queryBatchByCommdId(commodityIds = uccSkuPos.stream().map(a -> a.getCommodityId()).distinct().collect(Collectors.toList()), null)))) {
                Map<Long, String> picIdAndUrlMap;
                Map<Long, String> resultPicMap;
                ArrayList uccCommodityPicLogPOS = new ArrayList();
                for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                    UccCommodityPicLogPO uccCommodityPicLogPO = new UccCommodityPicLogPO();
                    BeanUtils.copyProperties((Object)uccCommodityPicPo, (Object)uccCommodityPicLogPO);
                    uccCommodityPicLogPO.setBatchId(Long.valueOf(Sequence.getInstance().nextId()));
                    uccCommodityPicLogPO.setRemark("\u538b\u7f29");
                    uccCommodityPicLogPOS.add(uccCommodityPicLogPO);
                }
                if (!CollectionUtils.isEmpty((Collection)uccCommodityPicLogPOS)) {
                    this.uccCommodityPicLogMapper.batchInsert((List)uccCommodityPicLogPOS);
                }
                if (!CollectionUtils.isEmpty(resultPicMap = this.picCompress(picIdAndUrlMap = uccCommodityPicPos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getCommodityPicUrl())).collect(Collectors.toMap(a -> a.getCommodityPicId(), a -> a.getCommodityPicUrl()))))) {
                    for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                        uccCommodityPicPo.setCommodityPicUrl(resultPicMap.get(uccCommodityPicPo.getCommodityPicId()));
                        this.uccCommodityPicMapper.updateCommodityPic(uccCommodityPicPo);
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(reqBo.getSkuIds(), null)))) {
                Map<Long, String> picIdAndUrlMap;
                Map<Long, String> resultPicMap;
                ArrayList<UccSkuPicLogPo> uccSkuPicLogPos = new ArrayList<UccSkuPicLogPo>();
                for (UccSkuPicPo uccSkuPicPo : uccSkuPicPos) {
                    UccSkuPicLogPo uccSkuPicLogPo = new UccSkuPicLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPicPo, (Object)uccSkuPicLogPo);
                    uccSkuPicLogPo.setBatchId(Long.valueOf(Sequence.getInstance().nextId()));
                    uccSkuPicLogPo.setRemark("\u538b\u7f29");
                    uccSkuPicLogPos.add(uccSkuPicLogPo);
                }
                if (!CollectionUtils.isEmpty(uccSkuPicLogPos)) {
                    this.uccSkuPicLogMapper.batchInsert(uccSkuPicLogPos);
                }
                if (!CollectionUtils.isEmpty(resultPicMap = this.picCompress(picIdAndUrlMap = uccSkuPicPos.stream().filter(a -> !StringUtils.isEmpty((Object)a.getSkuPicUrl())).collect(Collectors.toMap(a -> a.getSkuPicId(), a -> a.getSkuPicUrl()))))) {
                    for (UccSkuPicPo uccSkuPicPo : uccSkuPicPos) {
                        uccSkuPicPo.setSkuPicUrl(resultPicMap.get(uccSkuPicPo.getSkuPicId()));
                        this.uccSkuPicMapper.updateSkuPic(uccSkuPicPo);
                    }
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private Map<Long, String> picCompress(Map<Long, String> picMap) {
        HashedMap resultPicMap = new HashedMap();
        if (!CollectionUtils.isEmpty(picMap)) {
            for (Map.Entry<Long, String> each : picMap.entrySet()) {
                try {
                    File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + UUID.randomUUID() + ".jpg");
                    File fileParent = file.getParentFile();
                    if (!fileParent.exists()) {
                        fileParent.mkdirs();
                    }
                    HttpUtil.httpDownload(each.getValue(), file.getAbsolutePath());
                    byte[] bytes = PicUtils.compressPicForScale(UccPicCompressBusiServiceImpl.file2byte(file), this.size);
                    String fileUrl = this.fileUpLoad.upload(UUID.randomUUID() + "", bytes, ".jpg");
                    resultPicMap.put(each.getKey(), fileUrl);
                    HttpUtil.deleteFile("temporaryfile/" + file.getName());
                }
                catch (Exception e) {
                    log.info("\u538b\u7f29\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        return resultPicMap;
    }

    public static void main(String[] args) {
        String newFileName = UUID.randomUUID() + ".jpg";
        File fOut = new File("C:\\Users\\Administrator\\Desktop\\" + newFileName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(fOut);){
            File in = new File("C:\\Users\\Administrator\\Desktop\\\u6d4b\u8bd5\u56fe\u7247\u538b\u7f29.jpg");
            byte[] bytes = PicUtils.compressPicForScale(UccPicCompressBusiServiceImpl.file2byte(in), 150L);
            fileOutputStream.write(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2byte(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fileInputStream.read(b)) != -1) {
                byteArrayOutputStream.write(b, 0, n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("file2byte error" + e);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    log.error("byteArrayOutputStream error" + e);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error("fileInputStream error" + e);
                }
            }
        }
        return null;
    }
}

