/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccDataGovernSkuStateSingleQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccDataGovernSkuStateQryAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccDataGovernSkuStateQryAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccDataGovernSkuStateQryBatchAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccGovernSkuStateBO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccDataGovernSkuStateSingleQryAbilityService"})
public class UccDataGovernSkuStateSingleQryAbilityServiceImpl
implements UccDataGovernSkuStateSingleQryAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"skuStateSingleQry"})
    public UccDataGovernSkuStateQryAbilityRspBO skuStateSingleQry(@RequestBody UccDataGovernSkuStateQryAbilityReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuId())) {
            throw new BusinessException("8888", "\u5165\u53c2 skuId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List uccSkuPos = this.uccSkuMapper.qryBySkuIds(Collections.singletonList(reqBo.getSkuId()));
        Optional<Object> optionalUccSkuPo = Optional.ofNullable(uccSkuPos.stream().findFirst().orElse(null));
        if (!optionalUccSkuPo.isPresent()) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230sku\u4fe1\u606f");
        }
        UccSkuPo uccSkuPo = optionalUccSkuPo.get();
        UccDataGovernSkuStateQryAbilityRspBO rspBO = new UccDataGovernSkuStateQryAbilityRspBO();
        rspBO.setSkuStatus(uccSkuPo.getSkuStatus());
        Date date = uccSkuPo.getUpdateTime() != null ? uccSkuPo.getUpdateTime() : uccSkuPo.getCreateTime();
        rspBO.setChangeTime(DateUtils.dateToStrLong((Date)date));
        rspBO.setSkuId(uccSkuPo.getSkuId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"skuStateSingleBatchQry"})
    public UccDataGovernSkuStateQryBatchAbilityRspBO skuStateSingleBatchQry(@RequestBody UccDataGovernSkuStateQryAbilityReqBO reqBo) {
        UccDataGovernSkuStateQryBatchAbilityRspBO rspBO = new UccDataGovernSkuStateQryBatchAbilityRspBO();
        rspBO.setRespCode("0000");
        List uccSkuPos = this.uccSkuMapper.qryBySkuIds(Collections.singletonList(reqBo.getSkuId()));
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            List list = uccSkuPos.stream().map(e -> {
                UccGovernSkuStateBO bo = new UccGovernSkuStateBO();
                bo.setSkuStatus(e.getSkuStatus());
                Date date = e.getUpdateTime() != null ? e.getUpdateTime() : e.getCreateTime();
                bo.setChangeTime(DateUtils.dateToStrLong((Date)date));
                bo.setSkuId(e.getSkuId());
                return bo;
            }).collect(Collectors.toList());
            rspBO.setData(list);
        }
        return rspBO;
    }
}

