/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.estore.ability.api.UccBatchUpdateStatusForCatalogAbilityService;
import com.tydic.commodity.estore.ability.bo.UccBatchUpdateStatusForCatalogAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.UccBatchUpdateStatusForCatalogAbilityRspBo;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccBatchUpdateStatusForCatalogAbilityService"})
public class UccBatchUpdateStatusForCatalogAbilityServiceImpl
implements UccBatchUpdateStatusForCatalogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchUpdateStatusForCatalogAbilityServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${MDM_STANDARD_SKU_NUM_HIDE_SIZE:100}")
    private Integer MDM_STANDARD_SKU_NUM_HIDE_SIZE;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    @Autowired
    private BatchUpdateCommoStatusForMarketService updateCommoStatusForMarketService;

    @PostMapping(value={"batchUpdateStatusForCatalogAbility"})
    public UccBatchUpdateStatusForCatalogAbilityRspBo batchUpdateStatusForCatalogAbility(@RequestBody UccBatchUpdateStatusForCatalogAbilityReqBo reqBo) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("\u975e\u6807\u51c6\u5546\u54c1\u8f6c\u4e3a\u6807\u51c6\u5546\u54c1-thread-call-runner-%d").build();
        ThreadPoolExecutor threadService = new ThreadPoolExecutor(CPU, 2 * CPU, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
        UccEMdmCatalogPO qryUccEMdmCatalogPo = new UccEMdmCatalogPO();
        qryUccEMdmCatalogPo.setCatalogId(reqBo.getCatalogId());
        int totalCount = this.uccEMdmCatalogMapper.qryCommodityIdByCatalogIdCount(qryUccEMdmCatalogPo);
        if (totalCount > 0) {
            Page page;
            List commodityIdList;
            int cycle = totalCount % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? totalCount / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : totalCount / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
            for (int pageNoIndex = 1; pageNoIndex <= cycle && !CollectionUtils.isEmpty((Collection)(commodityIdList = this.uccEMdmCatalogMapper.qryCommodityIdByCatalogIdList(qryUccEMdmCatalogPo, page = new Page(pageNoIndex, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue())))); ++pageNoIndex) {
                Long[] longs = new Long[commodityIdList.size()];
                for (int i = 0; i < commodityIdList.size(); ++i) {
                    longs[i] = (Long)commodityIdList.get(i);
                }
                threadService.execute(() -> {
                    BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                    batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                    batchUpdateCommoStatusForMarketBO.setReason("\u7269\u6599\u5206\u7c7b\u4ece\u975e\u6807\u51c6\u5546\u54c1\u8f6c\u4e3a\u6807\u51c6\u5546\u54c1\u65f6,\u5c06\u8be5\u7269\u6599\u5206\u7c7b\u4e0b\u6240\u6709\u975e\u6807\u54c1\u5546\u54c1\u8fdb\u884c\u4e86\u81ea\u52a8\u4e0b\u67b6\u64cd\u4f5c");
                    batchUpdateCommoStatusForMarketBO.setOperationType(Integer.valueOf(21));
                    RspUccBo rspUccBo = this.updateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.FROZEN_STATUS, SkuStatusEnum.WARN_DOWN_STATUS);
                    if (!"0000".equals(rspUccBo.getRespCode())) {
                        log.error("\u4e0b\u67b6\u5546\u54c1\u548c\u5355\u54c1\u5931\u8d25\uff1a{}", (Object)rspUccBo.getRespCode());
                    }
                });
            }
        }
        UccBatchUpdateStatusForCatalogAbilityRspBo rspBo = new UccBatchUpdateStatusForCatalogAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

