/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccEstoreSkuManagementListQryBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.comb.api.UccConfigurationparametersDetailCombService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombRspBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirLogMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.estore.ability.api.UccEstoreSkuManagementListQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.estore.atom.api.UccEstoreDictionaryAtomService;
import com.tydic.commodity.po.SkuDataGovernPO;
import com.tydic.commodity.po.UccBrandAddPricePO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuShelvesPo;
import com.tydic.commodity.po.UocApprovalObjPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccEstoreSkuManagementListQryAbilityService"})
public class UccEstoreSkuManagementListQryAbilityServiceImpl
implements UccEstoreSkuManagementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreSkuManagementListQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuManagementListQryCombService uccSkuManagementListQryAbilityService;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccConfigurationparametersDetailCombService uccConfigurationparametersDetailAbilityService;
    @Autowired
    private UccSkuPutCirLogMapper uccSkuPutCirLogMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SkuDataGovernMapper skuDataGovernMapper;

    @PostMapping(value={"getSkuManagementListQry"})
    public UccEstoreSkuManagementListQryAbilityRspBO getSkuManagementListQry(@RequestBody UccEstoreSkuManagementListQryAbilityReqBO reqBO) {
        UccEstoreSkuManagementListQryAbilityRspBO rspBO = new UccEstoreSkuManagementListQryAbilityRspBO();
        reqBO.setSkuSource(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT);
        UccSkuManagementListQryCombReqBO skuManagementListQryAbilityReqBO = new UccSkuManagementListQryCombReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)skuManagementListQryAbilityReqBO);
        if (reqBO.getDownType() != null) {
            ArrayList<Integer> skuStatusList = new ArrayList<Integer>();
            skuStatusList.add(reqBO.getDownType());
            skuManagementListQryAbilityReqBO.setSkuStatus(skuStatusList);
        }
        UccSkuManagementListQryCombRspBO managementListQryAbilityRspBO = this.uccSkuManagementListQryAbilityService.getSkuManagementListQry(skuManagementListQryAbilityReqBO);
        BeanUtils.copyProperties((Object)managementListQryAbilityRspBO, (Object)rspBO);
        if (!"0000".equals(managementListQryAbilityRspBO.getRespCode())) {
            return rspBO;
        }
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)managementListQryAbilityRspBO.getRows()), UccEstoreSkuManagementListQryBO.class);
        rspBO.setRows(rows);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            List addCoefficientPOS;
            List skus = rspBO.getRows().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            Map<Object, Object> brandCoefficient = new HashMap();
            HashMap<Long, BigDecimal> skuCoefficient = new HashMap<Long, BigDecimal>();
            for (Long sku : skus) {
                UccBrandAddPricePO brandAddPricePO = this.uccSkuAddCoefficientMapper.selectBrandAddPriceBySkuIdNotIsFlag(sku);
                if (ObjectUtils.isEmpty((Object)brandAddPricePO)) continue;
                skuCoefficient.put(sku, brandAddPricePO.getAddCoefficient());
            }
            List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
            if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
                brandCoefficient = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, UccSkuAddCoefficientPO::getAddCoefficient));
                skuCoefficient.putAll(brandCoefficient);
            }
            HashSet catalogIds = new HashSet();
            rspBO.getRows().forEach(a -> {
                if (a.getL4mgCategoryId() != null) {
                    catalogIds.add(a.getL4mgCategoryId());
                }
            });
            HashMap typeCoefficient = new HashMap();
            if (!catalogIds.isEmpty() && !CollectionUtils.isEmpty((Collection)(addCoefficientPOS = this.uccAddCoefficientMapper.qryCoefficientByCatalogIds(new ArrayList(catalogIds), null)))) {
                addCoefficientPOS.forEach(a -> typeCoefficient.put("" + a.getCatalogId() + a.getSupplierShopId(), a.getAddCoefficient()));
            }
            BigDecimal defaultCoefficient = null;
            UccConfigurationparametersDetailCombReqBO parametersDetailAbilityReqBO = new UccConfigurationparametersDetailCombReqBO();
            parametersDetailAbilityReqBO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
            UccConfigurationparametersDetailCombRspBO detailAbilityRspBO = this.uccConfigurationparametersDetailAbilityService.getparametersDetail(parametersDetailAbilityReqBO);
            if ("0000".equals(detailAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)detailAbilityRspBO.getRows())) {
                defaultCoefficient = new BigDecimal(((UccConfigurationparametersCombQryBO)detailAbilityRspBO.getRows().get(0)).getRule());
            }
            List ObjIds = rspBO.getRows().stream().map(UccEstoreSkuManagementListQryBO::getSkuId).collect(Collectors.toList());
            UocApprovalObjPO uocApprovalObjPO = new UocApprovalObjPO();
            uocApprovalObjPO.setObjIds(ObjIds);
            List auditOrderIds = this.uocApprovalObjMapper.getAuditOrderId(uocApprovalObjPO);
            Map collect = null;
            if (!CollectionUtils.isEmpty((Collection)auditOrderIds)) {
                collect = auditOrderIds.parallelStream().collect(Collectors.toMap(UocApprovalObjPO::getObjId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
            }
            for (UccEstoreSkuManagementListQryBO each : rspBO.getRows()) {
                UocApprovalObjPO uocApprovalObjPOS;
                if (skuCoefficient.containsKey(each.getSkuId())) {
                    each.setMarkupRate((BigDecimal)skuCoefficient.get(each.getSkuId()));
                    continue;
                }
                if (MapUtils.isNotEmpty(collect) && Objects.nonNull(uocApprovalObjPOS = (UocApprovalObjPO)collect.get(each.getSkuId()))) {
                    each.setObjType(uocApprovalObjPOS.getObjType());
                }
                if (typeCoefficient.containsKey("" + each.getL4mgCategoryId() + each.getSupplierShopId())) {
                    each.setMarkupRate((BigDecimal)typeCoefficient.get("" + each.getL4mgCategoryId() + each.getSupplierShopId()));
                    continue;
                }
                if (defaultCoefficient == null) continue;
                each.setMarkupRate(defaultCoefficient);
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                List catalogIdList;
                List skuIds = rspBO.getRows().stream().map(UccEstoreSkuManagementListQryBO::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuIds)) {
                    List uccSkuShelvesPos = this.uccSkuPutCirLogMapper.getSkuShelves(skuIds);
                    Map<Long, List<UccSkuShelvesPo>> skuShelvesMap = uccSkuShelvesPos.stream().collect(Collectors.groupingBy(UccSkuShelvesPo::getSkuId));
                    List uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, null);
                    Object skuIdUpc = null;
                    if (!ObjectUtils.isEmpty((Object)uccSkuPos)) {
                        skuIdUpc = uccSkuPos.stream().filter(a -> a.getUpcCode() != null && !"".equals(a.getUpcCode())).collect(Collectors.toMap(a -> a.getSkuId(), b -> b.getUpcCode(), (a, b) -> a));
                    }
                    for (UccEstoreSkuManagementListQryBO bo : rspBO.getRows()) {
                        if (!CollectionUtils.isEmpty((Collection)skuShelvesMap.get(bo.getSkuId()))) {
                            bo.setUpCount(skuShelvesMap.get(bo.getSkuId()).get(0).getUpCount());
                        } else {
                            bo.setUpCount(Integer.valueOf(0));
                        }
                        if (ObjectUtils.isEmpty((Object)skuIdUpc) || !skuIdUpc.containsKey(bo.getSkuId())) continue;
                        bo.setUpcCode((String)skuIdUpc.get(bo.getSkuId()));
                    }
                }
                if (!CollectionUtils.isEmpty(catalogIdList = rspBO.getRows().stream().map(UccEstoreSkuManagementListQryBO::getCatalogId).collect(Collectors.toList()))) {
                    List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIdList);
                    Map<Long, List<UccEMdmCatalogPO>> catalogMap = uccEMdmCatalogPOS.stream().collect(Collectors.groupingBy(UccEMdmCatalogPO::getCatalogId));
                    for (UccEstoreSkuManagementListQryBO bo : rspBO.getRows()) {
                        if (CollectionUtils.isEmpty((Collection)catalogMap.get(bo.getCatalogId()))) continue;
                        bo.setCatalogCode(catalogMap.get(bo.getCatalogId()).get(0).getCatalogCode());
                    }
                }
                if (!CollectionUtils.isEmpty(skuIds)) {
                    SkuDataGovernPO qrySkuDataGovernPo = new SkuDataGovernPO();
                    qrySkuDataGovernPo.setSkuIds(skuIds);
                    List skuDataGovernPos = this.skuDataGovernMapper.getList(qrySkuDataGovernPo);
                    if (!CollectionUtils.isEmpty((Collection)skuDataGovernPos)) {
                        Map<Long, List<SkuDataGovernPO>> skuDataGovernPosMap = skuDataGovernPos.stream().collect(Collectors.groupingBy(SkuDataGovernPO::getSkuId));
                        for (UccEstoreSkuManagementListQryBO row : rspBO.getRows()) {
                            if (CollectionUtils.isEmpty((Collection)skuDataGovernPosMap.get(row.getSkuId()))) continue;
                            row.setGovernRemark(skuDataGovernPosMap.get(row.getSkuId()).get(0).getRemark());
                        }
                    }
                }
            }
            Map<String, String> dictionaryMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("BRAND_VERIFY_RESULT");
            Map<String, String> expState = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("GOVERN_PRICE_EXP_STATE");
            for (UccEstoreSkuManagementListQryBO row : rspBO.getRows()) {
                if (ObjectUtil.isNotEmpty((Object)row.getBrandVerifyResult())) {
                    row.setBrandVerifyResultStr(dictionaryMap.get(String.valueOf(row.getBrandVerifyResult())));
                }
                if (!ObjectUtil.isNotEmpty((Object)row.getAbnormalDesc())) continue;
                row.setAbnormalDescStr(expState.get(row.getAbnormalDesc()));
            }
        }
        return rspBO;
    }
}

