/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.bo.UccAutoHideCatalogStandardSkuAbilityReqBO;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.estore.ability.api.CceUccBrandApplyAuditAbilityService;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccBrandApplyAuditAbilityRspBo;
import com.tydic.commodity.estore.busi.api.CceUccBrandApplyAuditBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.CceUccBrandApplyAuditAbilityService"})
public class CceUccBrandApplyAuditAbilityServiceImpl
implements CceUccBrandApplyAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CceUccBrandApplyAuditAbilityServiceImpl.class);
    @Autowired
    private CceUccBrandApplyAuditBusiService cceUccBrandApplyAuditBusiService;
    @Resource(name="brandSkuHideProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_HIDE_TOPIC:BRAND_SKU_HIDE_TOPIC}")
    private String brandSkuHideTopic;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    public static final Integer OPER_TYPE_HIDE_CATALOG = 1;
    public static final Integer OPER_TYPE_DISPLAY_CATALOG = 2;
    public static final Integer OPER_TYPE_HIDE_BANNER = 3;

    @PostMapping(value={"dealBrandApplyAudit"})
    public CceUccBrandApplyAuditAbilityRspBo dealBrandApplyAudit(@RequestBody CceUccBrandApplyAuditAbilityReqBo reqBo) {
        CceUccBrandApplyAuditAbilityRspBo rspBo = this.cceUccBrandApplyAuditBusiService.dealBrandApplyAudit(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getFinistList())) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(rspBo.getFinistList());
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            Map<Integer, List<BrandApplyPO>> applyRelStatusMap = brandApplyPOS.stream().filter(e -> e.getApplyRelStatus() != null).collect(Collectors.groupingBy(BrandApplyPO::getApplyRelStatus));
            ArrayList<Integer> operType = new ArrayList<Integer>();
            if (applyRelStatusMap.containsKey(2)) {
                operType.add(OPER_TYPE_DISPLAY_CATALOG);
            }
            if (applyRelStatusMap.containsKey(1)) {
                operType.add(OPER_TYPE_HIDE_BANNER);
            }
            if (!CollectionUtils.isEmpty(operType)) {
                UccAutoHideCatalogStandardSkuAbilityReqBO abilityReqBO = new UccAutoHideCatalogStandardSkuAbilityReqBO();
                try {
                    this.proxyMessageProducer.send(new ProxyMessage(this.brandSkuHideTopic, "*", JSON.toJSONString((Object)abilityReqBO)));
                }
                catch (Exception e2) {
                    log.error("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u901a\u8fc7\u540e\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        return rspBo;
    }
}

