/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.DataGovernInitMapper;
import com.tydic.commodity.dao.SkuDataGovernRecordMapper;
import com.tydic.commodity.estore.ability.api.SkuDataGovernAbilityService;
import com.tydic.commodity.estore.ability.bo.CceSkuDataGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuDataGovernRspBO;
import com.tydic.commodity.estore.busi.api.UccSkuDataGovernBusiService;
import com.tydic.commodity.po.DataGovernInitPO;
import com.tydic.commodity.po.SkuDataGovernRecordPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.SkuDataGovernAbilityService"})
public class SkuDataGovernAbilityServiceImpl
implements SkuDataGovernAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SkuDataGovernAbilityServiceImpl.class);
    private UccSkuDataGovernBusiService uccSkuDataGovernBusiService;
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private SkuDataGovernRecordMapper skuDataGovernRecordMapper;
    @Value(value="${data_govern_time_flag:1}")
    private String dataGovernTimeFlag;
    public final int count = 100;
    @Autowired
    private DataGovernInitMapper dataGovernInitMapper;

    @PostMapping(value={"skuDataGovernReceive"})
    public SkuDataGovernRspBO skuDataGovernReceive(@RequestBody CceSkuDataGovernReqBO reqBO) {
        SkuDataGovernRspBO rspBO = new SkuDataGovernRspBO();
        if (reqBO.getData() == null || CollectionUtils.isEmpty((Collection)reqBO.getData().getSkuInfos())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6cbb\u7406\u63a8\u9001\u6570\u636e\u5355\u54c1\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        } else {
            try {
                SkuDataGovernRecordPO skuDataGovernRecordPO = new SkuDataGovernRecordPO();
                skuDataGovernRecordPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                skuDataGovernRecordPO.setMsgGetTime(new Date());
                skuDataGovernRecordPO.setSerialNo(reqBO.getSerialNo());
                skuDataGovernRecordPO.setSkuData(JSONObject.toJSONString((Object)reqBO));
                this.skuDataGovernRecordMapper.insert(skuDataGovernRecordPO);
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u6570\u636e\u6cbb\u7406\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
            }
            if ("1".equals(this.dataGovernTimeFlag)) {
                DataGovernInitPO dataGovernInitPO = new DataGovernInitPO();
                dataGovernInitPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                dataGovernInitPO.setSerialNo(reqBO.getSerialNo());
                dataGovernInitPO.setData(JSONObject.toJSONString((Object)reqBO.getData()));
                dataGovernInitPO.setStatus(Integer.valueOf(0));
                dataGovernInitPO.setType(Integer.valueOf(0));
                dataGovernInitPO.setCreateTime(new Date());
                this.dataGovernInitMapper.insert(dataGovernInitPO);
            } else {
                rspBO = this.uccSkuDataGovernBusiService.dealSkuDataGovernReceive(reqBO.getData());
                List skuIds = reqBO.getData().getSkuInfos().stream().filter(a -> !StringUtils.isEmpty((Object)a.getSkuId())).map(a -> Long.valueOf(a.getSkuId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuIds)) {
                    try {
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBo.setSkuIds(skuIds);
                        syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                        syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                        syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBo);
                    }
                    catch (Exception e) {
                        log.info("----------\u6570\u636e\u6cbb\u7406\u7ed3\u679c\u63a8\u9001\u5546\u54c1\u540c\u6b65ES\u62a5\u9519" + e);
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Autowired
    public void setUccSkuDataGovernBusiService(UccSkuDataGovernBusiService uccSkuDataGovernBusiService) {
        this.uccSkuDataGovernBusiService = uccSkuDataGovernBusiService;
    }

    @Autowired
    public void setSyncSceneCommodityToEsAtomService(SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService) {
        this.syncSceneCommodityToEsAtomService = syncSceneCommodityToEsAtomService;
    }
}

