/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccEstoreVerificationOfGoodsAbilityService;
import com.tydic.commodity.estore.ability.bo.UccEstoreVerificationOfGoodsAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEstoreVerificationOfGoodsAbilityRspBO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccEstoreVerificationOfGoodsAbilityService"})
public class UccEstoreVerificationOfGoodsAbilityServiceImpl
implements UccEstoreVerificationOfGoodsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreVerificationOfGoodsAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"queryEstoreVerificationOfGoods"})
    public UccEstoreVerificationOfGoodsAbilityRspBO queryEstoreVerificationOfGoods(@RequestBody UccEstoreVerificationOfGoodsAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccEstoreVerificationOfGoodsAbilityRspBO rspBO = new UccEstoreVerificationOfGoodsAbilityRspBO();
        List uccSkuPoList = this.uccSkuMapper.queryVerificationSkuList(reqBO.getSkuIds());
        List skuPoList = this.uccSkuMapper.queryAllSkuListBySkuIds(reqBO.getSkuIds());
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setSkuCodes(new ArrayList());
            return rspBO;
        }
        for (Long skuId : reqBO.getSkuIds()) {
            List skuIdList = skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            if (skuIdList.contains(skuId)) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setSkuCodes(new ArrayList());
            return rspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)uccSkuPoList) && reqBO.getSkuIds().size() == uccSkuPoList.size()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setSkuCodes(new ArrayList());
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            List skuCodes = skuPoList.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setSkuCodes(skuCodes);
            return rspBO;
        }
        List skuIds = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List collect = skuPoList.stream().filter(po -> !skuIds.contains(po.getSkuId())).collect(Collectors.toList());
        List skuCodes = collect.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSkuCodes(skuCodes);
        return rspBO;
    }

    private void validate(UccEstoreVerificationOfGoodsAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            throw new BusinessException("8888", "\u5355\u54c1ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

