/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.busibase.busi.bo.UccCatalogDataGovernFlagBusiReqBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.SkuCatalogBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchAbilityReqBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.estore.ability.api.UccExtupdateNewService;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesFormItemImportRspBO;
import com.tydic.commodity.estore.ability.bo.UccExtSkuAddPriceAbilityReqBO;
import com.tydic.commodity.estore.ability.impl.enums.TitleTemplateEnum;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.estore.busi.api.UccExtUpdateDateGovernFlagBusiService;
import com.tydic.commodity.estore.utils.ExcelUtils;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccExtupdateNewService"})
public class UccExtupdateNewServiceImpl
implements UccExtupdateNewService {
    private static final Logger log = LoggerFactory.getLogger(UccExtupdateNewServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccThematerialsearchAbilityService uccMaterialInfoQueryAbilityService;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private UccExtUpdateDateGovernFlagBusiService uccMdmCatalogUpdateDateGovernFlagBusiService;
    @Resource(name="catalogDataGovernFlagProvider")
    private ProxyMessageProducer catalogDataGovernFlagProvider;
    @Value(value="${CATALOG_DATA_GOVERN_FLAG_TOPIC:CATALOG_DATA_GOVERN_FLAG_TOPIC}")
    private String catalogDataGovernFlagTopic;
    @Value(value="${CATALOG_DATA_GOVERN_FLAG_TAG:*}")
    private String catalogDataGovernFlagTag;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    @Autowired
    private EsConfig esConfig;
    @Value(value="${MDM_STANDARD_SKU_NUM_HIDE_SIZE:100}")
    private Integer MDM_STANDARD_SKU_NUM_HIDE_SIZE;
    @Autowired
    private BatchUpdateCommoStatusForMarketService updateCommoStatusForMarketService;
    @Autowired
    private SyncSceneStandardCommodityToEsAtomService syncSceneStandardCommodityToEsAtomService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    private static final HashMap<String, String> TITLE = new HashMap(11);

    private static void initialize() {
        TITLE.put("CATALOG_NAME", "*\u7269\u6599\u5206\u7c7b\u540d\u79f0");
        TITLE.put("CATALOG_CODE", "*\u7269\u6599\u5206\u7c7b\u7f16\u7801");
        TITLE.put("APPLY_GROUND_YN", "*\u662f\u5426\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u76ee\u5f55");
        TITLE.put("E_CATEGORY_FLAG", "*\u7535\u5546\u5206\u7c7b\u6807\u8bc6");
        TITLE.put("DATA_GOVERN_FLAG", "*\u662f\u5426\u6570\u636e\u6cbb\u7406\u5206\u7c7b");
        TITLE.put("STANDARD_FLAG", "*\u662f\u5426\u6807\u54c1\u5c55\u793a");
        TITLE.put("STANDARD_SKU_NUM", "*\u6807\u54c1\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf");
        TITLE.put("CLASSIFY_MANAGER", "*\u7535\u5546\u5206\u7c7b\u7ba1\u7406\u4eba");
        TITLE.put("CATALOG_DESC", "\u8bf4\u660e");
        TITLE.put("ELC_BUY", "\u662f\u5426\u4e0a\u67b6\u7535\u5b50\u8d85\u5e02");
        TITLE.put("FREEZE_FLAG", "\u72b6\u6001");
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, UccExtSkuAddPriceAbilityReqBO reqBO, Long sucessImportCounts, Long failedImportCounts, String importType) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType(importType);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    private List<Map<String, Object>> exportImportResults(List<UccMdmCatalogsearchAbilityReqBO> applyShelvesFormItemPOS) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (UccMdmCatalogsearchAbilityReqBO applyShelvesFormItemPO : applyShelvesFormItemPOS) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u7269\u6599\u5206\u7c7b\u540d\u79f0", applyShelvesFormItemPO.getCatalogName() != null ? applyShelvesFormItemPO.getCatalogName() : "");
            item.put("\u7269\u6599\u5206\u7c7b\u7f16\u7801", applyShelvesFormItemPO.getCatalogCode() != null ? applyShelvesFormItemPO.getCatalogCode() : "");
            item.put("\u662f\u5426\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u76ee\u5f55", applyShelvesFormItemPO.getApplyGroundYnsString() != null ? applyShelvesFormItemPO.getApplyGroundYnsString() : "");
            item.put("\u662f\u5426\u5c55\u793a\u6807\u54c1", applyShelvesFormItemPO.getStandardFlagStr() != null ? applyShelvesFormItemPO.getStandardFlagStr() : "");
            item.put("\u6807\u54c1\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf", applyShelvesFormItemPO.getStandardSkuNumStr() != null ? applyShelvesFormItemPO.getStandardSkuNumStr() : "");
            item.put("\u7535\u5546\u5206\u7c7b\u6807\u8bc6", this.getEcategoryFlag(applyShelvesFormItemPO.getECategoryFlag(), applyShelvesFormItemPO.getECategoryFlagStr()));
            item.put("\u662f\u5426\u6570\u636e\u6cbb\u7406\u5206\u7c7b", applyShelvesFormItemPO.getDataGovernFlagStr() != null ? applyShelvesFormItemPO.getDataGovernFlagStr() : "");
            item.put("\u7535\u5546\u5206\u7c7b\u7ba1\u7406\u4eba", applyShelvesFormItemPO.getClassifyManager() != null ? applyShelvesFormItemPO.getClassifyManager() : "");
            if (applyShelvesFormItemPO.getImpResult() != null && applyShelvesFormItemPO.getImpResult() == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (applyShelvesFormItemPO.getImpResult() != null && applyShelvesFormItemPO.getImpResult() == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", applyShelvesFormItemPO.getImpRemark());
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    private String getEcategoryFlag(Integer type, String eCategoryFlagStr) {
        String string = eCategoryFlagStr = eCategoryFlagStr == null ? "" : eCategoryFlagStr;
        if (Objects.isNull(type)) {
            return eCategoryFlagStr;
        }
        String str = eCategoryFlagStr;
        switch (type.toString()) {
            case "0": {
                str = "\u529e\u516c\u7528\u54c1";
                break;
            }
            case "1": {
                str = "\u5de5\u4e1a\u54c1";
                break;
            }
            case "2": {
                str = "\u529e\u516c\u7528\u54c1&\u5de5\u4e1a\u54c1";
            }
        }
        return str;
    }

    private void dealItemImport(List<UccMdmCatalogsearchAbilityReqBO> applyShelvesFormItemPOS, Set<String> catalogCodes, List<UccEMdmCatalogPO> uccEMdmCatalogPos) {
        block7: {
            if (CollectionUtils.isEmpty(catalogCodes)) break block7;
            UccEMdmCatalogPO uccThematerialsearchAbilityReqBO = new UccEMdmCatalogPO();
            uccThematerialsearchAbilityReqBO.setCatalogCodes(new ArrayList<String>(catalogCodes));
            List uccEMdmCatalogPoList = this.uccEMdmCatalogMapper.queryAllMdmLessCloum(uccThematerialsearchAbilityReqBO);
            if (CollectionUtils.isEmpty((Collection)uccEMdmCatalogPoList)) {
                for (UccMdmCatalogsearchAbilityReqBO applyShelvesFormItemPO : applyShelvesFormItemPOS) {
                    if (UccConstants.ImpResult.FAIL.equals(applyShelvesFormItemPO.getImpResult())) continue;
                    applyShelvesFormItemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25,\u7269\u8d44\u5206\u7c7b\u586b\u5199\u9519\u8bef!");
                    applyShelvesFormItemPO.setImpResult(UccConstants.ImpResult.FAIL);
                }
            } else {
                uccEMdmCatalogPos.addAll(uccEMdmCatalogPoList);
                Map<String, UccEMdmCatalogPO> uccRspMap = uccEMdmCatalogPos.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, e -> e, (k, v) -> k));
                for (UccMdmCatalogsearchAbilityReqBO applyShelvesFormItemPO : applyShelvesFormItemPOS) {
                    if (UccConstants.ImpResult.FAIL.equals(applyShelvesFormItemPO.getImpResult())) continue;
                    UccEMdmCatalogPO uccEMdmMaterialBO = uccRspMap.get(applyShelvesFormItemPO.getCatalogCode());
                    if (uccEMdmMaterialBO != null) {
                        if (!applyShelvesFormItemPO.getCatalogCode().equals(uccEMdmMaterialBO.getCatalogCode())) {
                            applyShelvesFormItemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u7269\u8d44\u7c7b\u522b\u7f16\u7801\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e2d\u7269\u8d44\u7c7b\u522b\u7f16\u7801\u4e0d\u4e00\u81f4");
                            applyShelvesFormItemPO.setImpResult(UccConstants.ImpResult.FAIL);
                            continue;
                        }
                        if (!applyShelvesFormItemPO.getCatalogName().replaceAll("\\s+", "").equals(uccEMdmMaterialBO.getCatalogName().replaceAll("\\s+", ""))) {
                            applyShelvesFormItemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u7269\u8d44\u7c7b\u522b\u540d\u79f0\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e2d\u7269\u8d44\u7c7b\u522b\u540d\u79f0\u4e0d\u4e00\u81f4");
                            applyShelvesFormItemPO.setImpResult(UccConstants.ImpResult.FAIL);
                            continue;
                        }
                        applyShelvesFormItemPO.setCatalogId(uccEMdmMaterialBO.getCatalogId());
                        applyShelvesFormItemPO.setImpRemark("\u5bfc\u5165\u6210\u529f");
                        applyShelvesFormItemPO.setImpResult(UccConstants.ImpResult.SUCCESS);
                        continue;
                    }
                    applyShelvesFormItemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c\u7269\u8d44\u7f16\u7801\u67e5\u8be2\u7269\u8d44\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
                    applyShelvesFormItemPO.setImpResult(UccConstants.ImpResult.FAIL);
                }
            }
        }
    }

    private void getItemImport(List<UccMdmCatalogsearchAbilityReqBO> applyShelvesFormItemPOS, JSONObject data, Set<String> catalogCodes) {
        JSONArray excelJSON = data.getJSONArray("excelJSON");
        log.debug("\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)excelJSON));
        for (Object o : excelJSON) {
            UccMdmCatalogsearchAbilityReqBO itemPO = new UccMdmCatalogsearchAbilityReqBO();
            JSONObject next = (JSONObject)o;
            UccExtupdateNewServiceImpl.verificationRequired(next, itemPO);
            if (UccConstants.ImpResult.FAIL.equals(itemPO.getImpResult())) {
                applyShelvesFormItemPOS.add(itemPO);
                break;
            }
            itemPO.setImpResult(UccConstants.ImpResult.SUCCESS);
            String applyGroundYn = next.getString(TITLE.get("APPLY_GROUND_YN"));
            if (applyGroundYn.equals("\u4e0a\u67b6") || applyGroundYn.equals("1") || applyGroundYn.equals("\u662f")) {
                itemPO.setApplyGroundYn(Integer.valueOf(1));
            } else if (applyGroundYn.equals("\u4e0b\u67b6") || applyGroundYn.equals("0") || applyGroundYn.equals("\u5426")) {
                itemPO.setApplyGroundYn(Integer.valueOf(0));
            } else {
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u662f\u5426\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u76ee\u5f55\u8bf7\u586b\u5165\u662f\u6216\u8005\u5426");
            }
            String eCategoryFlag = next.getString(TITLE.get("E_CATEGORY_FLAG"));
            if (eCategoryFlag.equals("\u529e\u516c\u7528\u54c1")) {
                itemPO.setECategoryFlag(Integer.valueOf(0));
            } else if (eCategoryFlag.equals("\u5de5\u4e1a\u54c1")) {
                itemPO.setECategoryFlag(Integer.valueOf(1));
            } else if (eCategoryFlag.equals("\u529e\u516c\u7528\u54c1&\u5de5\u4e1a\u54c1")) {
                itemPO.setECategoryFlag(Integer.valueOf(2));
            } else {
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u672a\u77e5\u7684\u7535\u5546\u5206\u7c7b\u6807\u8bc6");
            }
            String dataGovernFlag = next.getString(TITLE.get("DATA_GOVERN_FLAG"));
            if (dataGovernFlag.equals("\u662f")) {
                itemPO.setDataGovernFlag(Integer.valueOf(1));
            } else if (dataGovernFlag.equals("\u5426")) {
                itemPO.setDataGovernFlag(Integer.valueOf(0));
            } else {
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u662f\u5426\u6570\u636e\u6cbb\u7406\u5206\u7c7b\u8bf7\u586b\u5165\u662f\u6216\u8005\u5426");
            }
            String standardFlag = next.getString(TITLE.get("STANDARD_FLAG"));
            if (standardFlag.equals("\u662f")) {
                itemPO.setStandardFlag(Integer.valueOf(1));
            } else if (standardFlag.equals("\u5426")) {
                itemPO.setStandardFlag(Integer.valueOf(0));
            } else {
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u662f\u5426\u6807\u54c1\u5c55\u793a\u8bf7\u586b\u5165\u662f\u6216\u8005\u5426");
            }
            String standardSkuNumStr = next.getString(TITLE.get("STANDARD_SKU_NUM"));
            try {
                int i = Integer.parseInt(standardSkuNumStr);
                if (i < 1) {
                    itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                    itemPO.setImpRemark("\u6807\u54c1\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf\u8bf7\u8f93\u5165\u7684\u6700\u5c0f\u503c\u4e3a1");
                } else {
                    itemPO.setStandardSkuNum(Integer.valueOf(i));
                }
            }
            catch (Exception e) {
                log.error("\u6807\u54c1\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf\u586b\u5199\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u6807\u54c1\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf\u8bf7\u586b\u5165\u6574\u6570");
            }
            itemPO.setClassifyManager(next.getString(TITLE.get("CLASSIFY_MANAGER")));
            if (!StringUtils.isEmpty((String)itemPO.getCatalogCode()) && UccConstants.ImpResult.SUCCESS.equals(itemPO.getImpResult())) {
                catalogCodes.add(itemPO.getCatalogCode());
            }
            String replace = itemPO.getCatalogName().replace(" ", "");
            itemPO.setCatalogName(replace);
            log.info(itemPO.getCatalogName());
            applyShelvesFormItemPOS.add(itemPO);
        }
    }

    private static void verificationRequired(JSONObject next, UccMdmCatalogsearchAbilityReqBO itemPO) {
        for (String key : TITLE.keySet()) {
            String value = TITLE.get(key);
            if (key.equals("CATALOG_DESC") || key.equals("ELC_BUY") || key.equals("FREEZE_FLAG")) continue;
            if (StringUtils.isBlank((String)next.getString(value))) {
                itemPO.setImpResult(UccConstants.ImpResult.FAIL);
                itemPO.setImpRemark("\u5bfc\u5165\u5931\u8d25\uff0c" + next.getString(value) + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            itemPO.setCatalogName(next.getString(TITLE.get("CATALOG_NAME")));
            itemPO.setCatalogCode(next.getString(TITLE.get("CATALOG_CODE")));
            itemPO.setApplyGroundYnsString(next.getString(TITLE.get("APPLY_GROUND_YN")));
            itemPO.setECategoryFlagStr(next.getString(TITLE.get("E_CATEGORY_FLAG")));
            itemPO.setDataGovernFlagStr(next.getString(TITLE.get("DATA_GOVERN_FLAG")));
            itemPO.setStandardFlagStr(next.getString(TITLE.get("STANDARD_FLAG")));
            itemPO.setStandardSkuNumStr(next.getString(TITLE.get("STANDARD_SKU_NUM")));
            itemPO.setClassifyManager(next.getString(TITLE.get("CLASSIFY_MANAGER")));
        }
    }

    private void validateTitle(List<String> title, UccExtSkuAddPriceAbilityReqBO reqBO) {
        String currentTitile = "";
        for (String s : title) {
            currentTitile = currentTitile + s + "|";
        }
        String typeBydesc = TitleTemplateEnum.getTypeBydesc(currentTitile);
        if (StringUtils.isEmpty((String)typeBydesc)) {
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e");
        }
        if (!typeBydesc.equals(reqBO.getImportType())) {
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f7f\u7528\u6a21\u677f\u662f\u5426\u6b63\u786e");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            Row row = sheet.getRow(1);
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                title.add(cell.toString().trim());
                log.debug("\u83b7\u53d6\u5230\u7684\u8868\u5934\uff1a{}", (Object)cell);
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 2; i <= rowLength && (row = sheet.getRow(i)) != null; ++i) {
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)UccExtupdateNewServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
        }
        catch (Exception e) {
            log.error("getExcelDateByImport error\uff1a" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            log.error("getCellValueByCell error\uff1a" + e1);
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = BigDecimal.valueOf(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    @PostMapping(value={"itemImport"})
    public UccApplyShelvesFormItemImportRspBO itemImport(@RequestBody UccExtSkuAddPriceAbilityReqBO reqBO) {
        JSONObject data = new JSONObject();
        this.analysisExcelData(reqBO, data);
        return this.materielCategoryImport(reqBO, data);
    }

    private void analysisExcelData(UccExtSkuAddPriceAbilityReqBO reqBO, JSONObject data) {
        ArrayList<String> title = new ArrayList<String>();
        try {
            String dateString = DateUtils.dateToStrAsFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + dateString + "content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getImportUrl(), file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
                this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateTitle(title, reqBO);
    }

    private UccApplyShelvesFormItemImportRspBO materielCategoryImport(UccExtSkuAddPriceAbilityReqBO reqBO, JSONObject data) {
        List catalogIds;
        ArrayList<UccMdmCatalogsearchAbilityReqBO> uccApplyFeedBackBOS = new ArrayList<UccMdmCatalogsearchAbilityReqBO>();
        HashSet<String> catalogCodes = new HashSet<String>();
        this.getItemImport(uccApplyFeedBackBOS, data, catalogCodes);
        if (CollectionUtils.isEmpty(uccApplyFeedBackBOS)) {
            throw new BusinessException("8888", "\u6a21\u677f\u89e3\u6790\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<UccEMdmCatalogPO> uccEMdmCatalogPos = new ArrayList<UccEMdmCatalogPO>();
        this.dealItemImport(uccApplyFeedBackBOS, catalogCodes, uccEMdmCatalogPos);
        for (UccMdmCatalogsearchAbilityReqBO uccApplyFeedBackBo : uccApplyFeedBackBOS) {
            if (UccConstants.ImpResult.FAIL.equals(uccApplyFeedBackBo.getImpResult())) continue;
            UccEMdmCatalogPO uccEMdmCatalogPo = (UccEMdmCatalogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)uccApplyFeedBackBo), UccEMdmCatalogPO.class);
            try {
                this.uccEMdmCatalogMapper.updateCatalogInfo(uccEMdmCatalogPo);
            }
            catch (Exception e2) {
                log.error("\u8fde\u63a5\u6570\u636e\u5e93\u4fee\u6539\u7269\u6599\u5206\u7c7b\u5931\u8d25:{}{}", (Object)uccEMdmCatalogPo.getCatalogCode(), (Object)e2.getMessage());
                uccApplyFeedBackBo.setImpRemark("\u5bfc\u5165\u5931\u8d25,\u8fde\u63a5\u6570\u636e\u5e93\u4fee\u6539\u7269\u6599\u5206\u7c7b\u5931\u8d25!");
                uccApplyFeedBackBo.setImpResult(UccConstants.ImpResult.FAIL);
            }
        }
        List finalApplyShelvesFormItemPos = uccApplyFeedBackBOS.stream().filter(e -> UccConstants.ImpResult.SUCCESS.equals(e.getImpResult())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(finalApplyShelvesFormItemPos)) {
            Map<String, UccEMdmCatalogPO> uccEMdmCatalogMap = uccEMdmCatalogPos.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, e -> e, (k1, k2) -> k1));
            HashSet<Long> changeCatalogIdSet = new HashSet<Long>();
            HashSet<Long> changeCatalogIdStandardFlagSet = new HashSet<Long>();
            for (UccMdmCatalogsearchAbilityReqBO newPo : finalApplyShelvesFormItemPos) {
                UccEMdmCatalogPO oldPO = (UccEMdmCatalogPO)uccEMdmCatalogMap.get(newPo.getCatalogCode());
                Integer oldDataGovernFlag = oldPO.getDataGovernFlag();
                if (oldDataGovernFlag == null) {
                    if (newPo.getDataGovernFlag() == 1) {
                        changeCatalogIdSet.add(oldPO.getCatalogId());
                    }
                } else if (!oldDataGovernFlag.equals(newPo.getDataGovernFlag())) {
                    changeCatalogIdSet.add(oldPO.getCatalogId());
                }
                if (!UccConstants.StandardFlag.YES.equals(newPo.getStandardFlag()) || !UccConstants.StandardFlag.NO.equals(oldPO.getStandardFlag())) continue;
                changeCatalogIdStandardFlagSet.add(oldPO.getCatalogId());
            }
            if (!CollectionUtils.isEmpty(changeCatalogIdSet)) {
                UccCatalogDataGovernFlagBusiReqBO syncBusiReqBO = new UccCatalogDataGovernFlagBusiReqBO();
                syncBusiReqBO.setCatalogIds(new ArrayList(changeCatalogIdSet));
                log.info("\u53d1\u9001\u7269\u6599\u5206\u7c7b\u4fee\u6539\u662f\u5426\u6570\u636e\u6cbb\u7406\u540e\u540c\u6b65\u5355\u54c1\u6d88\u606f\uff1a" + JSON.toJSONString((Object)syncBusiReqBO));
                this.catalogDataGovernFlagProvider.send(new ProxyMessage(this.catalogDataGovernFlagTopic, this.catalogDataGovernFlagTag, JSON.toJSONString((Object)syncBusiReqBO)));
            }
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("\u7269\u6599\u5206\u7c7b\u5bfc\u5165-thread-call-runner-%d").build();
            ThreadPoolExecutor threadService = new ThreadPoolExecutor(CPU, 2 * CPU, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
            if (!CollectionUtils.isEmpty(changeCatalogIdStandardFlagSet)) {
                for (Long catalogId : changeCatalogIdStandardFlagSet) {
                    threadService.execute(() -> {
                        UccEMdmCatalogPO qryUccEMdmCatalogPo = new UccEMdmCatalogPO();
                        qryUccEMdmCatalogPo.setCatalogId(catalogId);
                        qryUccEMdmCatalogPo.setSkuSource(Integer.valueOf(2));
                        int totalCount = this.uccEMdmCatalogMapper.qryCommodityIdByCatalogIdCount(qryUccEMdmCatalogPo);
                        if (totalCount > 0) {
                            Page page;
                            List commodityIdList;
                            int cycle = totalCount % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? totalCount / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : totalCount / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
                            for (int pageNoIndex = 1; pageNoIndex <= cycle && !CollectionUtils.isEmpty((Collection)(commodityIdList = this.uccEMdmCatalogMapper.qryCommodityIdByCatalogIdList(qryUccEMdmCatalogPo, page = new Page(pageNoIndex, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue())))); ++pageNoIndex) {
                                Long[] longs = new Long[commodityIdList.size()];
                                for (int i = 0; i < commodityIdList.size(); ++i) {
                                    longs[i] = (Long)commodityIdList.get(i);
                                }
                                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                                batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                                batchUpdateCommoStatusForMarketBO.setReason("\u7269\u6599\u5206\u7c7b\u4ece\u975e\u6807\u51c6\u5546\u54c1\u8f6c\u4e3a\u6807\u51c6\u5546\u54c1\u65f6,\u5c06\u8be5\u7269\u6599\u5206\u7c7b\u4e0b\u6240\u6709\u975e\u6807\u54c1\u5546\u54c1\u8fdb\u884c\u4e86\u81ea\u52a8\u4e0b\u67b6\u64cd\u4f5c");
                                batchUpdateCommoStatusForMarketBO.setOperationType(Integer.valueOf(21));
                                RspUccBo rspUccBo = this.updateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.DOWN_STATUS, SkuStatusEnum.DOWN_FRAME_STATUS);
                                if (!"0000".equals(rspUccBo.getRespCode())) {
                                    log.error("\u4e0b\u67b6\u5546\u54c1\u548c\u5355\u54c1\u5931\u8d25\uff1a{}", (Object)rspUccBo.getRespCode());
                                }
                                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                                syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(longs));
                                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                                try {
                                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                                    continue;
                                }
                                catch (Exception e) {
                                    log.error("\u540c\u6b65es\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                                }
                            }
                        }
                    });
                }
                threadService.execute(() -> {
                    for (UccMdmCatalogsearchAbilityReqBO bo : finalApplyShelvesFormItemPos) {
                        List skuCatalogBOS = this.uccEMdmCatalogMapper.selectSkuIdByCatalogCode(bo.getCatalogCode());
                        for (SkuCatalogBO skuCatalogBO : skuCatalogBOS) {
                            if (ObjectUtils.isEmpty((Object)skuCatalogBO.getECategoryFlag())) continue;
                            JSONObject object = new JSONObject();
                            object.put("classify_manager", (Object)skuCatalogBO.getClassifyManager());
                            object.put("e_category_flag", (Object)skuCatalogBO.getECategoryFlag());
                            if (skuCatalogBO.getStandardComId() == null) {
                                object.put("standard_flag", (Object)0);
                            } else {
                                object.put("standard_flag", (Object)skuCatalogBO.getStandardFlag());
                            }
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), skuCatalogBO.getSkuId().toString(), object);
                        }
                        List standardComIds = skuCatalogBOS.stream().map(SkuCatalogBO::getStandardComId).filter(Objects::nonNull).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(standardComIds)) continue;
                        SyncSceneStandardCommodityToEsReqBO commodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                        commodityToEsReqBO.setStandardIdLList(standardComIds);
                        commodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                        this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(commodityToEsReqBO);
                    }
                });
                threadService.shutdown();
            }
        }
        for (UccMdmCatalogsearchAbilityReqBO uccApplyFeedBackBO : uccApplyFeedBackBOS) {
            if (uccApplyFeedBackBO.getApplyGroundYn() != null) {
                if (uccApplyFeedBackBO.getApplyGroundYn() == 1) {
                    uccApplyFeedBackBO.setApplyGroundYnsString("\u662f");
                } else if (uccApplyFeedBackBO.getApplyGroundYn() == 0) {
                    uccApplyFeedBackBO.setApplyGroundYnsString("\u5426");
                }
            }
            if (uccApplyFeedBackBO.getDataGovernFlag() != null) {
                if (uccApplyFeedBackBO.getDataGovernFlag() == 1) {
                    uccApplyFeedBackBO.setDataGovernFlagStr("\u662f");
                } else if (uccApplyFeedBackBO.getDataGovernFlag() == 0) {
                    uccApplyFeedBackBO.setDataGovernFlagStr("\u5426");
                }
            }
            if (uccApplyFeedBackBO.getStandardFlag() == null) continue;
            if (uccApplyFeedBackBO.getStandardFlag() == 1) {
                uccApplyFeedBackBO.setStandardFlagStr("\u662f");
                continue;
            }
            if (uccApplyFeedBackBO.getStandardFlag() != 0) continue;
            uccApplyFeedBackBO.setStandardFlagStr("\u5426");
        }
        List<Map<String, Object>> exportData = this.exportImportResults(uccApplyFeedBackBOS);
        long sucessImportCounts = CollectionUtils.isEmpty(finalApplyShelvesFormItemPos) ? 0 : finalApplyShelvesFormItemPos.size();
        Long failedImportCounts = (long)uccApplyFeedBackBOS.size() - sucessImportCounts;
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(exportData, reqBO, sucessImportCounts, failedImportCounts, "UCC_CATALOG_ITEM_IMPORT");
        UccApplyShelvesFormItemImportRspBO rspBO = new UccApplyShelvesFormItemImportRspBO();
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty(finalApplyShelvesFormItemPos) && !CollectionUtils.isEmpty(catalogIds = finalApplyShelvesFormItemPos.stream().map(UccMdmCatalogsearchAbilityReqBO::getCatalogId).filter(Objects::nonNull).collect(Collectors.toList()))) {
            rspBO.setCatalogIds(catalogIds);
        }
        return rspBO;
    }

    static {
        UccExtupdateNewServiceImpl.initialize();
    }
}

