/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.bo.UccTimeDealBrandCheckAbilityReqBo;
import com.tydic.commodity.estore.busi.api.UccTimeDealBrandCheckBusiService;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccSkuBrandPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccTimeDealBrandCheckBusiServiceImpl
implements UccTimeDealBrandCheckBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @Override
    public RspUccBo dealBrandCheck(UccTimeDealBrandCheckAbilityReqBo reqBo) {
        RspUccBo rspBo = new RspUccBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            this.dealSku(reqBo.getSkuIds());
        } else {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO;
            List syncSkus;
            Page page;
            int num = 1;
            int total = 0;
            do {
                page = new Page(num, 1000);
                syncSkus = this.uccSkuMapper.getSkuByNotBrandVerfy(page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (!CollectionUtils.isEmpty((Collection)syncSkus)) {
                    this.uccSkuMapper.updateBrandCheckSku(syncSkus, Integer.valueOf(2));
                }
                syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(syncSkus);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_BRAND_VERIFY);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            } while (++num <= total);
            num = 1;
            total = 0;
            do {
                page = new Page(num, 1000);
                syncSkus = this.uccSkuMapper.getSkuByExistBrandVerfy(page);
                if (total == 0) {
                    total = page.getTotalPages();
                }
                if (!CollectionUtils.isEmpty((Collection)syncSkus)) {
                    this.uccSkuMapper.updateBrandCheckSku(syncSkus, Integer.valueOf(2));
                }
                syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(syncSkus);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_BRAND_VERIFY);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
            } while (++num <= total);
        }
        return rspBo;
    }

    private void dealSku(List<Long> syncSkus) {
        if (!CollectionUtils.isEmpty(syncSkus)) {
            ArrayList<Long> disValidSkuIds = new ArrayList<Long>();
            ArrayList<Long> notRelSkuIds = new ArrayList<Long>();
            ArrayList<Long> validSkuIds = new ArrayList<Long>();
            List uccSkuBrandPos = this.uccBrandDealMapper.querySkuMallBrandExt(syncSkus);
            if (!CollectionUtils.isEmpty((Collection)uccSkuBrandPos)) {
                for (UccSkuBrandPo uccSkuBrandPo : uccSkuBrandPos) {
                    if (uccSkuBrandPo.getBrandVerify() != null && uccSkuBrandPo.getBrandVerify() == 1) {
                        if (uccSkuBrandPo.getBrandId() == null) {
                            notRelSkuIds.add(uccSkuBrandPo.getSkuId());
                        }
                        if (uccSkuBrandPo.getBrandStatus() == null || uccSkuBrandPo.getBrandStatus() != 1) {
                            disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        }
                        if (uccSkuBrandPo.getAppRange() == null || uccSkuBrandPo.getAppRange() == 2) {
                            disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                        }
                        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                        uccRelCatalogBrandVendorPO.setCatalogId(uccSkuBrandPo.getCatalogId());
                        uccRelCatalogBrandVendorPO.setBrandId(uccSkuBrandPo.getBrandId());
                        uccRelCatalogBrandVendorPO.setVendorId(uccSkuBrandPo.getSupplierShopId());
                        uccRelCatalogBrandVendorPO.setDiscountFlag(Integer.valueOf(0));
                        List uccRelCatalogBrandVendorPOS = this.uccBrandDealMapper.getRelCatalogBrandVendor(uccRelCatalogBrandVendorPO);
                        if (CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                            disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                            continue;
                        }
                        if (((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() == null || ((UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0)).getStatus() != 1) {
                            disValidSkuIds.add(uccSkuBrandPo.getSkuId());
                            continue;
                        }
                        validSkuIds.add(uccSkuBrandPo.getSkuId());
                        continue;
                    }
                    validSkuIds.add(uccSkuBrandPo.getSkuId());
                }
                if (!CollectionUtils.isEmpty(validSkuIds)) {
                    this.uccSkuMapper.updateBrandCheckSku(validSkuIds, Integer.valueOf(2));
                }
            }
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(validSkuIds);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_BRAND_VERIFY);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
    }
}

