/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.estore.ability.api.CceUccCreateBrandApplyAbilityService;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityRspBo;
import com.tydic.commodity.estore.busi.api.CceUccCreateBrandApplyBusiService;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccBrandDealPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.CceUccCreateBrandApplyAbilityService"})
public class CceUccCreateBrandApplyAbilityServiceImpl
implements CceUccCreateBrandApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CceUccCreateBrandApplyAbilityServiceImpl.class);
    @Autowired
    private CceUccCreateBrandApplyBusiService cceUccCreateBrandApplyBusiService;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"createBrandApply"})
    public CceUccCreateBrandApplyAbilityRspBo createBrandApply(@RequestBody CceUccCreateBrandApplyAbilityReqBo reqBo) {
        CceUccCreateBrandApplyAbilityRspBo rspBo = this.cceUccCreateBrandApplyBusiService.createBrandApply(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getOffIds())) {
            BrandApplyPO searchPO = new BrandApplyPO();
            searchPO.setIds(rspBo.getOffIds());
            List mapperList = this.brandApplyMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty((Collection)mapperList)) {
                this.syncState(mapperList, reqBo);
            }
        }
        return rspBo;
    }

    @PostMapping(value={"updateBrandApply"})
    public CceUccCreateBrandApplyAbilityRspBo updateBrandApply(@RequestBody CceUccCreateBrandApplyAbilityReqBo reqBo) {
        CceUccCreateBrandApplyAbilityRspBo rspBo = this.cceUccCreateBrandApplyBusiService.updateBrandApply(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getOffIds())) {
            BrandApplyPO searchPO = new BrandApplyPO();
            searchPO.setIds(rspBo.getOffIds());
            List mapperList = this.brandApplyMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty((Collection)mapperList)) {
                this.syncState(mapperList, reqBo);
            }
        }
        return rspBo;
    }

    private void syncState(List<BrandApplyPO> mapperList, CceUccCreateBrandApplyAbilityReqBo reqBo) {
        try {
            Map<Object, Object> brandIdMap = new HashMap();
            List brandIds = mapperList.stream().filter(e -> e.getBrandId() != null).map(BrandApplyPO::getBrandId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(brandIds)) {
                UccBrandDealPO searchPO = new UccBrandDealPO();
                searchPO.setBrandIds(brandIds);
                List uccBrandDealPOS = this.uccBrandDealMapper.selectBy(searchPO);
                if (!CollectionUtils.isEmpty((Collection)uccBrandDealPOS)) {
                    brandIdMap = uccBrandDealPOS.stream().filter(e -> e.getBrandId() != null && !StringUtils.isEmpty((Object)e.getBrandName())).collect(Collectors.toMap(UccBrandDealPO::getBrandId, UccBrandDealPO::getBrandName));
                }
            }
            for (BrandApplyPO brandApplyPO : mapperList) {
                log.info("\u8c03\u7528\u54c1\u724c\u4e0a\u67b6\u786e\u8ba4\u5b8c\u6210\u5e76\u505c\u7528\u6279\u91cfMQ\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)brandApplyPO));
                UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
                esReqBO.setBrandId(brandApplyPO.getBrandId());
                esReqBO.setCatalogId(brandApplyPO.getCatalogId());
                esReqBO.setVendorId(brandApplyPO.getVendorId());
                if (brandApplyPO.getBrandId() != null && brandIdMap.containsKey(brandApplyPO.getBrandId())) {
                    esReqBO.setReason(reqBo.getName() + " \u64cd\u4f5c\u4e86" + (String)brandIdMap.get(brandApplyPO.getBrandId()) + "\u54c1\u724c\u5173\u8054\u5173\u7cfb\u505c\u7528");
                } else {
                    esReqBO.setReason(reqBo.getName() + " \u64cd\u4f5c\u4e86\u54c1\u724c\u5173\u8054\u5173\u7cfb\u505c\u7528");
                }
                esReqBO.setName(reqBo.getName());
                this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
            }
        }
        catch (Exception e2) {
            log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
        }
    }
}

