/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.estore.ability.bo.UccOffShelfSkuBo;
import com.tydic.commodity.estore.ability.bo.UccPushDataGovernanceOffShelfSkuAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccPushDataGovernanceOffShelfSkuAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccPushDataGovernanceOffShelfSkuBusiService;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccPushDataGovernanceOffShelfSkuBusiServiceImpl
implements UccPushDataGovernanceOffShelfSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccPushDataGovernanceOffShelfSkuBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    private final Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;

    @Override
    public UccPushDataGovernanceOffShelfSkuAbilityRspBO updateDataGovernanceOffShelfSku(UccPushDataGovernanceOffShelfSkuAbilityReqBO reqBo) {
        UccPushDataGovernanceOffShelfSkuBusiServiceImpl.check(reqBo);
        List skuIds = reqBo.getData().getShelfSkuBos().stream().map(UccOffShelfSkuBo::getSkuId).distinct().collect(Collectors.toList());
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        if (CollectionUtil.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
        }
        Map<Long, List<UccOffShelfSkuBo>> uccOffShelfSkuBoMap = reqBo.getData().getShelfSkuBos().stream().collect(Collectors.groupingBy(UccOffShelfSkuBo::getSkuId));
        ArrayList<Long> skuIdsEs = new ArrayList<Long>();
        for (UccSkuPo each : uccSkuPos) {
            if (!ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(each.getSkuStatus())) {
                throw new BusinessException("8888", "\u5b58\u5728\u5355\u54c1\u4e0d\u662f\u4e0a\u67b6\u72b6\u6001\u7684\u6570\u636e");
            }
            if (CollectionUtil.isEmpty((Collection)uccOffShelfSkuBoMap.get(each.getSkuId()))) continue;
            skuIdsEs.add(each.getSkuId());
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(each.getSkuId());
            uccSkuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_DOWN_SHELF);
            uccSkuPo.setUpdateTime(new Date());
            uccSkuPo.setApprovalStatus(Integer.valueOf(-1));
            uccSkuPo.setStepId("null");
            this.uccSkuMapper.updateSku(uccSkuPo);
            ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
            UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
            logRecordAbilityBO.setSkuId(each.getSkuId());
            logRecordAbilityBO.setCreateOperId("\u6570\u636e\u6cbb\u7406");
            logRecordAbilityBO.setCommodityId(((UccSkuPo)uccSkuPos.get(0)).getCommodityId());
            logRecordAbilityBO.setCreateTime(new Date());
            logRecordAbilityBO.setOperationType(Integer.valueOf(20));
            logRecordAbilityBO.setRemark("\u6570\u636e\u6cbb\u7406\u89e6\u53d1\u4e0b\u67b6");
            logRecordAbilityBO.setSkuExtValue(uccOffShelfSkuBoMap.get(each.getSkuId()).get(0).getRemark());
            recordAbilityBOS.add(logRecordAbilityBO);
            try {
                if (!ObjectUtils.isEmpty((Object)logRecordAbilityBO.getSkuExtValue())) {
                    UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                    skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                    this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                }
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u4e0b\u67b6\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
            }
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuPutCirPo.setSkuId(each.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(each.getSupplierShopId());
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            uccSkuPutCirPo.setRealDownTime(new Date());
            uccSkuPutCirPo.setDownType(Integer.valueOf(1));
            try {
                uccSkuPutCirPo.setRemark(uccOffShelfSkuBoMap.get(each.getSkuId()).get(0).getRemark());
                this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
            }
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            BeanUtils.copyProperties((Object)each, (Object)uccSkuLogPo);
            uccSkuLogPo.setBatchId(Long.valueOf(this.sequence.nextId()));
            this.uccSkuLogMapper.insert(uccSkuLogPo);
        }
        UccPushDataGovernanceOffShelfSkuAbilityRspBO rspBo = new UccPushDataGovernanceOffShelfSkuAbilityRspBO();
        rspBo.setSkuIds(skuIdsEs);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private static void check(UccPushDataGovernanceOffShelfSkuAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getData() == null) {
            throw new BusinessException("8888", "\u5165\u53c2[data]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBO.getData().getShelfSkuBos())) {
            throw new BusinessException("8888", "\u5165\u53c2[shelfSkuBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccOffShelfSkuBo shelfSkuBo : reqBO.getData().getShelfSkuBos()) {
            if (shelfSkuBo.getSkuId() != null) continue;
            throw new BusinessException("8888", "\u5165\u53c2[\u5355\u54c1id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

