/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuOnShelveWayEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelCatalogVendorDiscountMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecChangeDealMapper;
import com.tydic.commodity.dao.UccSkuSpecChangeDetailMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.estore.atom.api.UccUpdateSkuPropAtomService;
import com.tydic.commodity.estore.atom.bo.UccSkuAttrBO;
import com.tydic.commodity.estore.atom.bo.UccSkuAttrComparisonBO;
import com.tydic.commodity.estore.atom.bo.UccUpdateSkuPropAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccUpdateSkuPropAtomRspBO;
import com.tydic.commodity.estore.busi.api.UccMqSyncCommdDetailBusiService;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdDetailReqBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdDetailRspBo;
import com.tydic.commodity.estore.busi.bo.UccSkuSpecChangeDealBO;
import com.tydic.commodity.estore.busi.bo.UccSkuSpecChangeDetailBO;
import com.tydic.commodity.estore.busi.bo.XwgLSaveLogReqBo;
import com.tydic.commodity.estore.busi.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecChangeDealPO;
import com.tydic.commodity.po.UccSkuSpecChangeDetailPO;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMqSyncCommdDetailBusiServiceImpl
implements UccMqSyncCommdDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdDetailBusiServiceImpl.class);
    @Value(value="${SUPERMARKET_VENDOR:202200511,202200512}")
    private String supermarketVendor;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccRelCatalogVendorDiscountMapper uccRelCatalogVendorDiscountMapper;
    @Value(value="${discount_digit:4}")
    private String digit;
    private final Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UccUpdateSkuPropAtomService uccUpdateSkuPropAtomService;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuSpecChangeDealMapper uccSkuSpecChangeDealMapper;
    @Autowired
    private UccSkuSpecChangeDetailMapper uccSkuSpecChangeDetailMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${xwgl.qry.url:http://172.20.175.66:30043/XWGL_GROUP_DEV/1.0.0/com.tydic.xwgl.ability.api.XwglRuleGetDetailAbilityService/getDetail}")
    private String xwglQryUrl;
    @Value(value="${xwgl.save.url:http://172.20.175.66:30043/XWGL_GROUP_DEV/1.0.0/com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService/saveXwglLog}")
    private String xwglSaveUrl;
    @Value(value="${ucc.sx.ruleNo:DZSC-SP-00002}")
    private String sxRuleNo;
    @Value(value="${ucc.sx.orgCode:101123}")
    private String sxOrgCode;
    @Value(value="${ucc.sx.orgName:\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8}")
    private String sxOrgNmae;

    @Override
    public MqSyncCommdDetailRspBo dealSync(MqSyncCommdDetailReqBo mqSyncCommdDetailReqBo) {
        MqSyncCommdDetailRspBo rspBo;
        block61: {
            rspBo = new MqSyncCommdDetailRspBo();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtPicPath())) {
                UccCommodityPicPo commodityPicPo = new UccCommodityPicPo();
                commodityPicPo.setCommodityPicUrl(mqSyncCommdDetailReqBo.getExtPicPath());
                commodityPicPo.setCommodityId(mqSyncCommdDetailReqBo.getCommodityId());
                commodityPicPo.setCommodityPicType(Integer.valueOf(1));
                commodityPicPo.setSupplierShopId(mqSyncCommdDetailReqBo.getSupplierShopId());
                try {
                    if (mqSyncCommdDetailReqBo.getCommodityPicId() != null) {
                        commodityPicPo.setCommodityPicId(mqSyncCommdDetailReqBo.getCommodityPicId());
                        this.uccCommodityPicMapper.updateCommodityPic(commodityPicPo);
                    } else {
                        commodityPicPo.setCommodityPicId(Long.valueOf(Sequence.getInstance().nextId()));
                        this.uccCommodityPicMapper.addcommodityPic(commodityPicPo);
                    }
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
            UccSkuPo skuPo = null;
            boolean isChanger = false;
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtSkuNmae())) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setSkuName(mqSyncCommdDetailReqBo.getExtSkuNmae());
                skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
            }
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtBrandName())) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setBrandName(mqSyncCommdDetailReqBo.getExtBrandName());
                skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
                UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(mqSyncCommdDetailReqBo.getSkuId().toString());
                if (!ObjectUtils.isEmpty((Object)uccSkuPo.getBrandId())) {
                    UccBrandDealPO uccBrandDealPO = this.uccBrandDealMapper.selectBrandId(uccSkuPo.getBrandId());
                    if (ObjectUtils.isEmpty((Object)uccBrandDealPO)) {
                        UccBrandDealPO uccBrandDealBo = new UccBrandDealPO();
                        uccBrandDealBo.setBrandName(mqSyncCommdDetailReqBo.getExtBrandName());
                        uccBrandDealBo.setBrandId(Long.valueOf(Sequence.getInstance().nextId()));
                        uccBrandDealBo.setEffTime(new Date());
                        uccBrandDealBo.setBrandType(Integer.valueOf(0));
                        uccBrandDealBo.setBrandStatus(Integer.valueOf(1));
                        uccBrandDealBo.setExpTime(DateUtils.strToDate((String)"9999-12-31 00:00:00"));
                        uccBrandDealBo.setRemark("\u54c1\u724c\u540d\u79f0\u53d8\u66f4\u65b0\u589e\u54c1\u724c");
                        this.uccBrandDealMapper.addBrand(uccBrandDealBo);
                        skuPo.setBrandId(uccBrandDealBo.getBrandId());
                    } else {
                        skuPo.setBrandId(uccBrandDealPO.getBrandId());
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtModel())) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setModel(mqSyncCommdDetailReqBo.getExtModel());
                skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
            }
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtSpec())) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setSpec(mqSyncCommdDetailReqBo.getExtSpec());
                skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
            }
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtmeasureName())) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setMeasureName(mqSyncCommdDetailReqBo.getExtmeasureName());
                skuPo.setSalesUnitName(mqSyncCommdDetailReqBo.getExtmeasureName());
                skuPo.setSettlementUnit(mqSyncCommdDetailReqBo.getExtmeasureName());
            }
            if (mqSyncCommdDetailReqBo.getExtisFactoryShip() != null) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setIsFactoryShip(mqSyncCommdDetailReqBo.getExtisFactoryShip());
            }
            if (mqSyncCommdDetailReqBo.getExtMoq() != null) {
                if (skuPo == null) {
                    skuPo = new UccSkuPo();
                }
                skuPo.setMoq(new BigDecimal(mqSyncCommdDetailReqBo.getExtMoq()));
            }
            if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtaxtCode()) && skuPo == null) {
                skuPo = new UccSkuPo();
            }
            if (mqSyncCommdDetailReqBo.getExtTaxRate() != null && skuPo == null) {
                skuPo = new UccSkuPo();
            }
            if (mqSyncCommdDetailReqBo.getIsSkuAttrChange() != null && mqSyncCommdDetailReqBo.getIsSkuAttrChange().booleanValue() && skuPo == null) {
                skuPo = new UccSkuPo();
            }
            if (skuPo != null) {
                skuPo.setSupplierShopId(mqSyncCommdDetailReqBo.getSupplierShopId());
                isChanger = true;
                skuPo.setSkuId(mqSyncCommdDetailReqBo.getSkuId());
                if (!StringUtils.isEmpty((Object)skuPo.getSkuName()) || !StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtaxtCode()) || mqSyncCommdDetailReqBo.getExtTaxRate() != null) {
                    UccCommodityPo uccCommodityPo = new UccCommodityPo();
                    if (!StringUtils.isEmpty((Object)skuPo.getSkuName())) {
                        uccCommodityPo.setCommodityName(skuPo.getSkuName());
                    }
                    if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtaxtCode())) {
                        uccCommodityPo.setTaxCatCode(mqSyncCommdDetailReqBo.getExtaxtCode());
                    }
                    if (mqSyncCommdDetailReqBo.getExtTaxRate() != null) {
                        uccCommodityPo.setRate(mqSyncCommdDetailReqBo.getExtTaxRate());
                    }
                    uccCommodityPo.setCommodityId(mqSyncCommdDetailReqBo.getCommodityId());
                    uccCommodityPo.setSupplierShopId(mqSyncCommdDetailReqBo.getSupplierShopId());
                    try {
                        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
                    }
                    catch (Exception e) {
                        log.error("\u5546\u54c1\u8be6\u60c5\u9875\u5546\u54c1\u540d\u79f0\u6709\u53d8\u66f4\uff1a \u66f4\u65b0\u5931\u8d25:" + JSONObject.toJSONString((Object)uccCommodityPo) + "\u9519\u8bef\u63cf\u8ff0\uff1a" + e.getMessage());
                    }
                }
                if (!StringUtils.isEmpty((Object)skuPo.getMeasureName())) {
                    UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
                    uccCommodityMeasurePo.setMeasureName(skuPo.getMeasureName());
                    Page page = new Page(1, 10);
                    List measurePoList = this.uccCommodityMeasureMapper.queryToPage(page, uccCommodityMeasurePo);
                    if (CollectionUtils.isEmpty((Collection)measurePoList)) {
                        uccCommodityMeasurePo.setMeasureId(Long.valueOf(Sequence.getInstance().nextId()));
                        try {
                            this.uccCommodityMeasureMapper.addMeasure(uccCommodityMeasurePo);
                        }
                        catch (Exception e) {
                            log.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u63a5\u53e3 \u8ba1\u91cf\u5355\u4f4d\u53d8\u52a8\u5931\u8d25:" + JSONObject.toJSONString((Object)uccCommodityMeasurePo) + "\u9519\u8bef\u63cf\u8ff0\uff1a" + e.getMessage());
                        }
                        skuPo.setMeasureId(uccCommodityMeasurePo.getMeasureId());
                    } else {
                        skuPo.setMeasureId(((UccCommodityMeasurePo)measurePoList.get(0)).getMeasureId());
                    }
                    skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
                }
                ArrayList<UccSkuSpecPo> uccSkuSpecPos = new ArrayList();
                if (mqSyncCommdDetailReqBo.getIsSkuAttrChange() != null && mqSyncCommdDetailReqBo.getIsSkuAttrChange().booleanValue()) {
                    UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
                    uccSkuSpecPo.setSkuId(mqSyncCommdDetailReqBo.getSkuId());
                    uccSkuSpecPos = this.uccSkuSpecMapper.querySpecInfos(uccSkuSpecPo);
                    UccUpdateSkuPropAtomReqBO uccUpdateSkuPropAtomReqBO = new UccUpdateSkuPropAtomReqBO();
                    uccUpdateSkuPropAtomReqBO.setUccSkuAttrBos(mqSyncCommdDetailReqBo.getUccSkuAttrBOList());
                    uccUpdateSkuPropAtomReqBO.setSkuId(mqSyncCommdDetailReqBo.getSkuId());
                    uccUpdateSkuPropAtomReqBO.setSupplierCode(mqSyncCommdDetailReqBo.getSupplierCode());
                    UccUpdateSkuPropAtomRspBO uccUpdateSkuPropAtomRspBO = this.uccUpdateSkuPropAtomService.updateSkuProp(uccUpdateSkuPropAtomReqBO);
                    if (!"0000".equals(uccUpdateSkuPropAtomRspBO.getRespCode())) {
                        log.error("\u5355\u54c1\u5c5e\u6027\u53d8\u66f4\u5f02\u5e38\uff1a" + JSONObject.toJSONString((Object)skuPo) + "\u9519\u8bef\u63cf\u8ff0\uff1a" + uccUpdateSkuPropAtomRspBO.getRespDesc());
                    } else {
                        try {
                            log.error("\u5f00\u59cb\u8fdb\u5165\u6dfb\u52a0\u5546\u54c1\u5c5e\u6027\u53d8\u52a8\u8bb0\u5f55\u903b\u8f91");
                            if (uccUpdateSkuPropAtomRspBO.getIsChange().booleanValue() && !ModelRuleConstant.SKU_STATUS_WAIT_SHELF.equals(skuPo.getSkuStatus())) {
                                this.addChangesProductAttributes(mqSyncCommdDetailReqBo, uccSkuSpecPos);
                                skuPo.setUpdateTime(new Date());
                            }
                        }
                        catch (Exception e) {
                            log.error("\u5355\u54c1\u5c5e\u6027\u53d8\u66f4\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                    }
                }
                try {
                    String value;
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuId(skuPo.getSkuId());
                    List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                    String[] supermarketVendorArray = this.supermarketVendor.split(",");
                    boolean isGovernIng = false;
                    if (skuPo.getSkuStatus() != null && !Arrays.asList(supermarketVendorArray).contains(((UccSkuPo)uccSkuPos.get(0)).getSupplierShopId().toString())) {
                        skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_DATA_GOVERNANCE);
                        isGovernIng = true;
                    }
                    this.uccSkuMapper.updateSku(skuPo);
                    ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
                    UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                    logRecordAbilityBO.setSkuId(skuPo.getSkuId());
                    logRecordAbilityBO.setCreateOperId(mqSyncCommdDetailReqBo.getName());
                    logRecordAbilityBO.setCommodityId(((UccSkuPo)uccSkuPos.get(0)).getCommodityId());
                    logRecordAbilityBO.setCreateTime(new Date());
                    if (isGovernIng) {
                        logRecordAbilityBO.setOperationType(Integer.valueOf(26));
                        logRecordAbilityBO.setRemark("\u8be6\u60c5\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u89e6\u53d1");
                    } else {
                        logRecordAbilityBO.setOperationType(Integer.valueOf(20));
                        logRecordAbilityBO.setRemark("\u8be6\u60c5\u89e6\u53d1\u4e0b\u67b6");
                    }
                    StringBuffer bf = new StringBuffer();
                    if (!ObjectUtils.isEmpty((Object)skuPo.getSkuName())) {
                        bf.append("\u540d\u79f0");
                    }
                    if (!ObjectUtils.isEmpty((Object)skuPo.getMeasureName())) {
                        bf.append("\u3001").append("\u5355\u4f4d");
                    }
                    if (!ObjectUtils.isEmpty((Object)skuPo.getBrandName())) {
                        bf.append("\u3001").append("\u54c1\u724c");
                    }
                    if (!ObjectUtils.isEmpty((Object)skuPo.getSkuPrice())) {
                        bf.append("\u3001").append("\u4ef7\u683c");
                    }
                    if (!ObjectUtils.isEmpty((Object)skuPo.getSpec())) {
                        bf.append("\u3001").append("\u89c4\u683c");
                    }
                    if (!ObjectUtils.isEmpty((Object)skuPo.getModel())) {
                        bf.append("\u3001").append("\u578b\u53f7");
                    }
                    if (mqSyncCommdDetailReqBo.getIsSkuAttrChange() != null && mqSyncCommdDetailReqBo.getIsSkuAttrChange().booleanValue()) {
                        bf.append("\u3001").append("\u5c5e\u6027\u503c");
                    }
                    if ((value = bf + "").startsWith("\u3001")) {
                        value = value.substring(1);
                    }
                    logRecordAbilityBO.setSkuExtValue(value);
                    recordAbilityBOS.add(logRecordAbilityBO);
                    try {
                        if (!CollectionUtils.isEmpty(recordAbilityBOS) && !ObjectUtils.isEmpty((Object)logRecordAbilityBO.getSkuExtValue())) {
                            UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                            skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                            this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8be6\u60c5\u51fa\u53d1\u4e0b\u67b6\u540e\u540e\u540e\u540e\u540e" + e.getMessage());
                    }
                    if (StringUtils.isEmpty((Object)skuPo.getSkuStatus())) break block61;
                    StringBuilder stringBuilder = new StringBuilder();
                    UccSkuPo uccSkuPo1 = (UccSkuPo)uccSkuPos.get(0);
                    UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
                    uccSkuPutCirPo.setSkuId(skuPo.getSkuId());
                    uccSkuPutCirPo.setSupplierShopId(skuPo.getSupplierShopId());
                    uccSkuPutCirPo.setState(Integer.valueOf(1));
                    uccSkuPutCirPo.setRealDownTime(new Date());
                    uccSkuPutCirPo.setDownType(Integer.valueOf(2));
                    try {
                        this.remark(mqSyncCommdDetailReqBo, stringBuilder, uccSkuPo1, uccSkuSpecPos);
                        uccSkuPutCirPo.setRemark(stringBuilder.toString());
                        this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                    }
                    catch (Exception e) {
                        log.error("\u6dfb\u52a0\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
                    }
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(skuPo.getSkuId());
                    this.dealSku(skuIds);
                }
                catch (Exception e) {
                    log.error("\u5355\u54c1\u6570\u636e\u53d8\u66f4\u5f02\u5e38\uff1a" + JSONObject.toJSONString((Object)skuPo) + "\u9519\u8bef\u63cf\u8ff0\uff1a" + e.getMessage());
                }
            }
        }
        return rspBo;
    }

    private void addChangesProductAttributes(MqSyncCommdDetailReqBo reqBo, List<UccSkuSpecPo> before) {
        log.error("\u5f53\u524d\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        Long skuId = reqBo.getSkuId();
        log.error("\u5f00\u59cb\u8bb0\u5f55\u5546\u54c1\u5c5e\u6027\u53d8\u52a8\u8bb0\u5f55\uff0c\u5f53\u524d\u7684skuId\u4e3a\uff1a{}\uff0c\u53d8\u52a8\u524d\u6570\u636e\u4e3a\uff1a{}", (Object)reqBo.getSkuId(), (Object)JSON.toJSONString(before));
        UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(String.valueOf(skuId));
        if (uccSkuPo == null || uccSkuPo.getSkuStatus() == null || !SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(uccSkuPo.getSkuStatus())) {
            log.error("\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u5df2\u4e0a\u67b6\uff0c\u4e0d\u89e6\u53d1");
            return;
        }
        log.error("\u67e5\u8be2sku\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)uccSkuPo));
        UccEMdmCatalogPO skuCatalog = this.uccEMdmCatalogMapper.selectSkuIdBySkuId(skuId);
        log.error("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)skuCatalog));
        UccSkuSpecChangeDealBO uccSkuSpecChangeDealBO = new UccSkuSpecChangeDealBO();
        uccSkuSpecChangeDealBO.setSkuId(skuId);
        uccSkuSpecChangeDealBO.setCommodityId(uccSkuPo.getCommodityId());
        uccSkuSpecChangeDealBO.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuSpecChangeDealBO.setShopName(uccSkuPo.getShopName());
        uccSkuSpecChangeDealBO.setCommodityTypeId(skuCatalog.getCommodityTypeId());
        uccSkuSpecChangeDealBO.setExt1(skuCatalog.getCommodityTypeName());
        uccSkuSpecChangeDealBO.setSkuCode(uccSkuPo.getSkuCode());
        uccSkuSpecChangeDealBO.setSkuSource(uccSkuPo.getSkuSource());
        uccSkuSpecChangeDealBO.setSkuName(uccSkuPo.getSkuName());
        uccSkuSpecChangeDealBO.setExtSkuId(uccSkuPo.getExtSkuId());
        uccSkuSpecChangeDealBO.setCreateUserName(StringUtils.isEmpty((Object)reqBo.getName()) ? "\u7cfb\u7edf\u81ea\u52a8" : reqBo.getUsername());
        uccSkuSpecChangeDealBO.setCreateUserCode(StringUtils.isEmpty((Object)reqBo.getUsername()) ? "\u7cfb\u7edf\u81ea\u52a8" : reqBo.getUsername());
        uccSkuSpecChangeDealBO.setManageMan(skuCatalog.getClassifyManager());
        uccSkuSpecChangeDealBO.setCreateTime(new Date());
        uccSkuSpecChangeDealBO.setIsDelete(0);
        uccSkuSpecChangeDealBO.setDealType(0);
        Long relId = this.insertUccSkuSpecChangeDeal(uccSkuSpecChangeDealBO);
        log.error("\u4e3b\u952e\u4e3a\uff1a{}", (Object)relId);
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(skuId);
        HashSet<String> set = new HashSet<String>(1);
        ArrayList<UccSkuSpecPo> newBefore = new ArrayList<UccSkuSpecPo>();
        for (int i = 0; i < before.size(); ++i) {
            String key = before.get(i).getPropName() + "-" + before.get(i).getPropValue();
            if (i == 0) {
                set.add(key);
                newBefore.add(before.get(i));
                continue;
            }
            if (set.contains(key)) continue;
            set.add(key);
            newBefore.add(before.get(i));
        }
        ArrayList<UccSkuAttrBO> newAfter = new ArrayList<UccSkuAttrBO>();
        List<UccSkuAttrBO> after = reqBo.getUccSkuAttrBOList();
        for (int i = 0; i < after.size(); ++i) {
            String key = after.get(i).getAttrName() + "-" + after.get(i).getAttrValue();
            if (i == 0) {
                set.add(key);
                newAfter.add(after.get(i));
                continue;
            }
            if (set.contains(key)) continue;
            set.add(key);
            newAfter.add(after.get(i));
        }
        List<UccSkuSpecChangeDetailBO> results = this.comparativeData(relId, newBefore, newAfter);
        this.insertUccSkuSpecChangeDetail(results);
    }

    private void insertUccSkuSpecChangeDetail(List<UccSkuSpecChangeDetailBO> results) {
        log.error("\u4fdd\u5b58\u5c5e\u6027\u503c:{}", (Object)JSON.toJSONString(results));
        ArrayList<UccSkuSpecChangeDetailPO> changeDealPOS = new ArrayList<UccSkuSpecChangeDetailPO>();
        for (UccSkuSpecChangeDetailBO result : results) {
            UccSkuSpecChangeDetailPO changeDealPO = new UccSkuSpecChangeDetailPO();
            BeanUtils.copyProperties((Object)result, (Object)changeDealPO);
            changeDealPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            changeDealPOS.add(changeDealPO);
        }
        this.uccSkuSpecChangeDetailMapper.insertBatch(changeDealPOS);
    }

    private List<UccSkuSpecChangeDetailBO> comparativeData(Long relId, List<UccSkuSpecPo> newBefore, List<UccSkuAttrBO> after) {
        log.error("\u67e5\u8be2\u4fee\u6539\u524d\u7684\u5c5e\u6027\u503c\u4e3a\uff1a{}", (Object)JSON.toJSONString(newBefore));
        log.error("\u67e5\u8be2\u4fee\u6539\u540e\u7684\u5c5e\u6027\u503c\u4e3a\uff1a{}", (Object)JSON.toJSONString(after));
        ArrayList<UccSkuSpecChangeDetailBO> results = new ArrayList<UccSkuSpecChangeDetailBO>();
        if (CollectionUtils.isEmpty(newBefore)) {
            log.error("\u5f53\u524d\u903b\u8f91\u4e3a\u4fee\u6539\u524d\u4e3a\u7a7a");
            for (UccSkuAttrBO uccSkuAttrBO : after) {
                UccSkuSpecChangeDetailBO bo = this.addInfo(relId, uccSkuAttrBO.getAttrName(), uccSkuAttrBO.getAttrValue(), 2, 1);
                results.add(bo);
            }
        } else if (CollectionUtils.isEmpty(after)) {
            log.error("\u5f53\u524d\u903b\u8f91\u540e\u4fee\u6539\u524d\u4e3a\u7a7a");
            for (UccSkuSpecPo uccSkuSpecPo : newBefore) {
                UccSkuSpecChangeDetailBO bo = this.addInfo(relId, uccSkuSpecPo.getPropName(), uccSkuSpecPo.getPropValue(), 1, 1);
                results.add(bo);
            }
        } else {
            UccSkuSpecChangeDetailBO bo;
            log.error("\u5f53\u524d\u4e3a\u4fee\u6539\u903b\u8f91");
            ArrayList<UccSkuSpecChangeDetailBO> newBeforeInit = new ArrayList<UccSkuSpecChangeDetailBO>();
            ArrayList<UccSkuSpecChangeDetailBO> afterInit = new ArrayList<UccSkuSpecChangeDetailBO>();
            for (UccSkuSpecPo uccSkuSpecPo : newBefore) {
                bo = this.addInfo(relId, uccSkuSpecPo.getPropName(), uccSkuSpecPo.getPropValue(), 1, 1);
                newBeforeInit.add(bo);
            }
            for (UccSkuAttrBO uccSkuAttrBO : after) {
                bo = this.addInfo(relId, uccSkuAttrBO.getAttrName(), uccSkuAttrBO.getAttrValue(), 2, 1);
                afterInit.add(bo);
            }
            for (UccSkuSpecChangeDetailBO beforeIn : newBeforeInit) {
                for (UccSkuSpecChangeDetailBO afterIn : afterInit) {
                    if (beforeIn.getPropValue() == null || beforeIn.getPropShowName() == null || afterIn.getPropValue() == null || afterIn.getPropShowName() == null || !afterIn.getPropShowName().equals(beforeIn.getPropShowName()) || !afterIn.getPropValue().equals(beforeIn.getPropValue())) continue;
                    afterIn.setChangeType(0);
                }
            }
            for (UccSkuSpecChangeDetailBO afterIn : afterInit) {
                for (UccSkuSpecChangeDetailBO beforeIn : newBeforeInit) {
                    if (beforeIn.getPropValue() == null || beforeIn.getPropShowName() == null || afterIn.getPropValue() == null || afterIn.getPropShowName() == null || !afterIn.getPropShowName().equals(beforeIn.getPropShowName()) || !afterIn.getPropValue().equals(beforeIn.getPropValue())) continue;
                    beforeIn.setChangeType(0);
                }
            }
            results.addAll(newBeforeInit);
            results.addAll(afterInit);
        }
        return results;
    }

    private UccSkuSpecChangeDetailBO addInfo(Long relId, String attrName, String attrValue, int specType, int changeType) {
        UccSkuSpecChangeDetailBO bo = new UccSkuSpecChangeDetailBO();
        bo.setRelId(relId);
        bo.setPropShowName(attrName);
        bo.setPropValue(attrValue);
        bo.setSpecType(specType);
        bo.setChangeType(changeType);
        bo.setCreateUserName("\u7cfb\u7edf\u81ea\u52a8");
        bo.setCreateTime(new Date());
        bo.setUpdateUserName("\u7cfb\u7edf\u81ea\u52a8");
        bo.setUpdateTime(new Date());
        bo.setIsDelete(0);
        log.error("\u5c5e\u6027\u503c\u8be6\u60c5\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)bo));
        return bo;
    }

    private UccSkuSpecChangeDetailBO createDetailBO(Long relId, UccSkuSpecPo po, Integer specType) {
        UccSkuSpecChangeDetailBO bo = this.addInfo(relId, po.getPropShowName(), po.getPropValue(), specType, 1);
        return bo;
    }

    private UccSkuSpecChangeDetailBO createDetailBO(Long relId, UccSkuSpecPo po, String propShowName, String propValue, Integer specType) {
        UccSkuSpecChangeDetailBO bo = this.addInfo(relId, po != null ? po.getPropShowName() : propShowName, po != null ? po.getPropValue() : propValue, specType, 1);
        return bo;
    }

    private Long insertUccSkuSpecChangeDeal(UccSkuSpecChangeDealBO uccSkuSpecChangeDealBO) {
        log.error("insertUccSkuSpecChangeDetail:{}", (Object)JSON.toJSONString((Object)uccSkuSpecChangeDealBO));
        UccSkuSpecChangeDealPO uccSkuSpecChangeDetailPO = new UccSkuSpecChangeDealPO();
        BeanUtils.copyProperties((Object)uccSkuSpecChangeDealBO, (Object)uccSkuSpecChangeDetailPO);
        uccSkuSpecChangeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.uccSkuSpecChangeDealMapper.insert(uccSkuSpecChangeDetailPO);
        return uccSkuSpecChangeDetailPO.getId();
    }

    private void remark(MqSyncCommdDetailReqBo mqSyncCommdDetailReqBo, StringBuilder stringBuilder, UccSkuPo uccSkuPo1, List<UccSkuSpecPo> uccSkuSpecPos) {
        if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtSkuNmae())) {
            stringBuilder.append("\u7535\u5546\u5546\u54c1\u540d\u79f0:").append(mqSyncCommdDetailReqBo.getExtSkuNmae()).append(",").append("\u6613\u8d2d\u5546\u54c1\u540d\u79f0:").append(uccSkuPo1.getSkuName()).append(",");
        }
        if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtmeasureName())) {
            stringBuilder.append("\u7535\u5546\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0:").append(mqSyncCommdDetailReqBo.getExtmeasureName()).append(",").append("\u6613\u8d2d\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0:").append(uccSkuPo1.getMeasureName()).append(",");
        }
        if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtBrandName())) {
            stringBuilder.append("\u7535\u5546\u54c1\u724c\u540d\u79f0:").append(mqSyncCommdDetailReqBo.getExtBrandName()).append(",").append("\u6613\u8d2d\u54c1\u724c\u540d\u79f0:").append(uccSkuPo1.getBrandName()).append(",");
        }
        if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtSpec())) {
            stringBuilder.append("\u7535\u5546\u89c4\u683c:").append(mqSyncCommdDetailReqBo.getExtSpec()).append(",").append("\u6613\u8d2d\u89c4\u683c:").append(uccSkuPo1.getSpec()).append(",");
        }
        if (!StringUtils.isEmpty((Object)mqSyncCommdDetailReqBo.getExtModel())) {
            stringBuilder.append("\u7535\u5546\u578b\u53f7:").append(mqSyncCommdDetailReqBo.getExtModel()).append(",").append("\u6613\u8d2d\u578b\u53f7:").append(uccSkuPo1.getModel()).append(",");
        }
        if (mqSyncCommdDetailReqBo.getIsSkuAttrChange() != null && mqSyncCommdDetailReqBo.getIsSkuAttrChange().booleanValue()) {
            UccSkuAttrComparisonBO uccSkuAttrComparisonBO;
            ArrayList<UccSkuAttrComparisonBO> uccSkuAttrComparisonNew = new ArrayList<UccSkuAttrComparisonBO>();
            ArrayList<UccSkuAttrComparisonBO> uccSkuAttrComparisonOld = new ArrayList<UccSkuAttrComparisonBO>();
            if (!CollectionUtils.isEmpty(mqSyncCommdDetailReqBo.getUccSkuAttrBOList())) {
                for (UccSkuAttrBO uccSkuAttrBO : mqSyncCommdDetailReqBo.getUccSkuAttrBOList()) {
                    uccSkuAttrComparisonBO = new UccSkuAttrComparisonBO();
                    uccSkuAttrComparisonBO.setAttrValue(uccSkuAttrBO.getAttrValue());
                    uccSkuAttrComparisonBO.setAttrName(uccSkuAttrBO.getAttrName());
                    uccSkuAttrComparisonNew.add(uccSkuAttrComparisonBO);
                }
            }
            if (!CollectionUtils.isEmpty(uccSkuSpecPos)) {
                for (UccSkuSpecPo uccSkuSpecPo : uccSkuSpecPos) {
                    uccSkuAttrComparisonBO = new UccSkuAttrComparisonBO();
                    uccSkuAttrComparisonBO.setAttrValue(uccSkuSpecPo.getPropValue());
                    uccSkuAttrComparisonBO.setAttrName(uccSkuSpecPo.getPropName());
                    uccSkuAttrComparisonOld.add(uccSkuAttrComparisonBO);
                }
            }
            stringBuilder.append("\u7535\u5546\u5c5e\u6027\u503c:").append(JSONObject.toJSONString(uccSkuAttrComparisonNew)).append(",").append("\u6613\u8d2d\u5c5e\u6027\u503c:").append(JSONObject.toJSONString(uccSkuAttrComparisonOld)).append(",");
        }
    }

    private void dealSku(List<Long> skuIds) {
        if (!CollectionUtils.isEmpty(skuIds)) {
            List secondDiscountLimitSkuIds;
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
            List directList = uccSkuPos.stream().filter($ -> $.getSkuSource() == 2 && Objects.nonNull($.getOnShelveWay()) && SkuOnShelveWayEnum.ON_DECRIT_WAY.getCode().equals($.getOnShelveWay()) && ModelRuleConstant.SKU_STATUS_ON_SHELF.equals($.getSkuStatus())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
            ArrayList<Long> checkSecond = new ArrayList<Long>();
            List surpassDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSurpassDiscountLimitSku(skuIds, Integer.valueOf(this.digit));
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                skuIds.forEach(each -> {
                    if (!surpassDiscountLimitSkuIds.contains(each)) {
                        checkSecond.add((Long)each);
                    }
                });
            } else {
                checkSecond.addAll(skuIds);
            }
            if (!CollectionUtils.isEmpty(checkSecond) && !CollectionUtils.isEmpty((Collection)(secondDiscountLimitSkuIds = this.uccRelCatalogVendorDiscountMapper.getSecondDiscountLimitSku(checkSecond, Integer.valueOf(this.digit))))) {
                surpassDiscountLimitSkuIds.addAll(secondDiscountLimitSkuIds);
            }
            if (!CollectionUtils.isEmpty((Collection)surpassDiscountLimitSkuIds)) {
                List<Long> notDiscountLimitSkuIds;
                List<Long> failList = surpassDiscountLimitSkuIds.stream().filter($ -> directList.contains($)).collect(Collectors.toList());
                List<Long> successList = surpassDiscountLimitSkuIds.stream().filter($ -> !directList.contains($)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(failList)) {
                    failList.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(1), Integer.valueOf(0));
                    });
                }
                if (!CollectionUtils.isEmpty(successList)) {
                    successList.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(1), Integer.valueOf(1));
                    });
                }
                if (!CollectionUtils.isEmpty(notDiscountLimitSkuIds = skuIds.stream().filter(a -> !surpassDiscountLimitSkuIds.contains(a)).distinct().collect(Collectors.toList()))) {
                    notDiscountLimitSkuIds.forEach($ -> {
                        List<Long> ids = Collections.singletonList($);
                        this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(0), Integer.valueOf(0));
                    });
                }
            } else {
                skuIds.forEach($ -> {
                    List<Long> ids = Collections.singletonList($);
                    this.uccRelCatalogVendorDiscountMapper.updateDiscountLimitSku(ids, Integer.valueOf(0), Integer.valueOf(0));
                });
            }
        }
    }

    private void saveXwgl(MqSyncCommdDetailReqBo commdDetailReqBo) {
        try {
            log.error("\u9884\u8b66\u6821\u9a8c\u5f00\u59cb\u4e86");
            JSONObject qry = new JSONObject();
            qry.put("ruleNo", (Object)this.sxRuleNo);
            String rule = HttpUtil.doPost(this.xwglQryUrl, qry.toJSONString());
            log.error("\u9884\u8b66\u6821\u9a8c\u8fd4\u56de" + rule);
            if (StringUtils.isEmpty((Object)rule)) {
                log.error("\u67e5\u8be2\u9884\u8b66\u62a5\u9519");
                return;
            }
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setSkuId(commdDetailReqBo.getSkuId());
            UccSkuPo sku = (UccSkuPo)this.uccSkuMapper.qerySku(skuPo).get(0);
            XwgLSaveLogReqBoXwglLogs x = (XwgLSaveLogReqBoXwglLogs)JSONObject.parseObject((String)rule, XwgLSaveLogReqBoXwglLogs.class);
            XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
            ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
            x.setBusinessName(sku.getSkuName());
            x.setBusinessId(String.valueOf(sku.getSkuId()));
            x.setBusinessCode(sku.getExtSkuId());
            x.setXwglSupplierId(sku.getSupplierShopId());
            x.setBusinessUrl("/#/index/ecCommodityItemDetail?skuId=" + sku.getSkuId() + "&supplierShopId=" + sku.getSupplierShopId());
            x.setRulId(x.getRuleId());
            x.setIsZj(1);
            x.setCompanyId(this.sxOrgCode);
            x.setDeptId(this.sxOrgCode);
            x.setCompanyName(this.sxOrgNmae);
            x.setDeptName(this.sxOrgNmae);
            xwglLogs.add(x);
            reqBo.setXwglLogs(xwglLogs);
            reqBo.setIsZj(1);
            reqBo.setUserId(-1L);
            reqBo.setName("\u7cfb\u7edf");
            log.error("\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)((Object)reqBo)));
            String str = HttpUtil.doPost(this.xwglSaveUrl, JSONObject.toJSONString((Object)((Object)reqBo)));
            log.error("\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)str));
        }
        catch (Exception e) {
            log.error("\u9884\u8b66\u4e8b\u4ef6\u5931\u8d25\uff1a" + e);
        }
    }
}

