/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.estore.ability.api.UccBrandBatchHideSkuAbilityService;
import com.tydic.commodity.estore.ability.bo.UccBrandBatchHideSkuAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccBrandBatchHideSkuAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccBrandBatchHideSkuBusiService;
import com.tydic.commodity.estore.busi.bo.UccBrandBatchHideSkuBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccBrandBatchHideSkuBusiRspBO;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccBrandBatchHideSkuAbilityService"})
public class UccBrandBatchHideSkuAbilityServiceImpl
implements UccBrandBatchHideSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandBatchHideSkuAbilityServiceImpl.class);
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${MDM_STANDARD_SKU_NUM_HIDE_SIZE:100}")
    private Integer MDM_STANDARD_SKU_NUM_HIDE_SIZE;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();
    private static final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-sku-hide-runner-%d").build();
    private static final ExecutorService fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
    @Autowired
    private UccBrandBatchHideSkuBusiService uccBrandBatchHideSkuBusiService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;

    @PostMapping(value={"dealSkuBrandHide"})
    public UccBrandBatchHideSkuAbilityRspBO dealSkuBrandHide(@RequestBody UccBrandBatchHideSkuAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinistList())) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(reqBO.getFinistList());
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            for (BrandApplyPO applyPO : brandApplyPOS) {
                Integer count;
                if (applyPO.getApplyRelStatus() == null || applyPO.getApplyRelStatus() == 2 || applyPO.getCatalogId() == null || applyPO.getVendorId() == null || applyPO.getBrandId() == null || (count = Integer.valueOf(this.uccEMdmCatalogMapper.getHideListByStandardTaskCount(applyPO))) <= 0) continue;
                int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
                int i = 1;
                while (i <= cycle) {
                    int finalI = i++;
                    fixedThreadPool.submit(() -> {
                        Page page = new Page(finalI, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue());
                        List byStandardTaskCountPage = this.uccEMdmCatalogMapper.getHideListByStandardTaskCountPage(applyPO, page);
                        UccBrandBatchHideSkuBusiReqBO busiReqBO = new UccBrandBatchHideSkuBusiReqBO();
                        List<Long> skuIds = byStandardTaskCountPage.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                        busiReqBO.setSkuIds(skuIds);
                        busiReqBO.setHide(UccConstants.Hide.yes);
                        UccBrandBatchHideSkuBusiRspBO busiRspBO = this.uccBrandBatchHideSkuBusiService.dealSkuBrandHide(busiReqBO);
                        if (!"0000".equals(busiRspBO.getRespCode())) {
                            throw new BusinessException("8888", busiRspBO.getRespDesc());
                        }
                        try {
                            this.addLog(busiReqBO.getSkuIds(), busiReqBO.getHide());
                        }
                        catch (Exception e) {
                            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                        }
                        Map<Long, List<UccSkuPo>> mapSku = byStandardTaskCountPage.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                        for (Long supplierShopId : mapSku.keySet()) {
                            List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                            try {
                                this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                            }
                            catch (Exception e) {
                                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                            }
                        }
                    });
                }
            }
        }
        return null;
    }

    private void addLog(List<Long> skuIds, Integer hide) {
        ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
        for (Long skuId : skuIds) {
            UccSkuOperationLogRecordAbilityBO uccSkuOperationLogRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
            uccSkuOperationLogRecordAbilityBO.setSkuId(skuId);
            uccSkuOperationLogRecordAbilityBO.setCreateOperId("\u7ba1\u7406\u5458");
            uccSkuOperationLogRecordAbilityBO.setCommodityId(null);
            uccSkuOperationLogRecordAbilityBO.setCreateTime(new Date());
            if (UccConstants.Hide.no.equals(hide)) {
                uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(23));
                uccSkuOperationLogRecordAbilityBO.setRemark("\u5355\u54c1\u9690\u85cf");
            } else {
                uccSkuOperationLogRecordAbilityBO.setOperationType(Integer.valueOf(24));
                uccSkuOperationLogRecordAbilityBO.setRemark("\u5355\u54c1\u53d6\u6d88\u9690\u85cf");
            }
            recordAbilityBOS.add(uccSkuOperationLogRecordAbilityBO);
        }
        UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
        skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
        this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
    }
}

