/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class UccDateUtil {
    private static final int WEEK_DAY_NUM = 7;
    private static final int HOUR_16_PM = 16;
    private static final int MINTUES_10 = 10;
    static final ThreadLocal threadLocal = new ThreadLocal();

    public static String getFormatTime(long date) {
        return UccDateUtil.getFormatTime(new Date(date));
    }

    public static String getFormatTime(Date date) {
        return UccDateUtil.getFormatDate(date, "HH:mm:ss");
    }

    public static String getFormatDateTimeMinute(Date date) {
        return UccDateUtil.getFormatDate(date, "yyyy-MM-dd HH:mm");
    }

    public static Date getDateTimeMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getTomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static long getTomorrowMinusCurrent() {
        Date tomorrow = UccDateUtil.getTomorrow();
        return tomorrow.getTime() - System.currentTimeMillis();
    }

    public static long betweenMinute(Date dateA, Date dateB) {
        long between = dateB.getTime() - dateA.getTime();
        return between / 60000L;
    }

    public static String getCurrentFormatTime() {
        return UccDateUtil.getFormatDate(new Date());
    }

    public static String getFormatDate(Date date) {
        return UccDateUtil.getFormatDate(date, "yyyyMMdd");
    }

    public static String getFormatDate(long date) {
        Date d = new Date(date);
        return UccDateUtil.getFormatDate(d, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatDate(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        threadLocal.set(format);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)threadLocal.get();
        return simpleDateFormat.format(date);
    }

    public static int getWeekOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w <= 0) {
            w = 7;
        }
        return w;
    }

    public static long getTodayForHour(int hour) {
        Calendar beginningOfDayCalendar = Calendar.getInstance();
        beginningOfDayCalendar.set(11, hour);
        beginningOfDayCalendar.set(12, 0);
        beginningOfDayCalendar.set(13, 0);
        long beginningOfDayInMillis = beginningOfDayCalendar.getTimeInMillis();
        Date beginningOfDayDate = new Date(beginningOfDayInMillis);
        return beginningOfDayDate.getTime();
    }

    public static Date getFriday() {
        Calendar calendar = Calendar.getInstance();
        switch (calendar.get(7)) {
            case 6: {
                int hour = calendar.get(11);
                int min = calendar.get(12);
                if (hour <= 16 && (hour != 16 || min < 10)) break;
                calendar.add(7, 7);
                break;
            }
            case 7: {
                calendar.add(7, 7);
            }
        }
        calendar.set(7, 6);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, days);
        return cal.getTime();
    }

    public static String getSeasonFriday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, UccDateUtil.getSeason(calendar.getTime()) + 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.add(5, 6 - calendar.get(7));
        return UccDateUtil.getFormatDate(calendar.getTime());
    }

    public static int getSeason(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: {
                return 5;
            }
            case 6: 
            case 7: 
            case 8: {
                return 8;
            }
            case 9: 
            case 10: 
            case 11: {
                return 11;
            }
        }
        return 2;
    }

    public static Long getLongDateFromDateStr(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dateTime = format.parse(date);
            return dateTime.getTime();
        }
        catch (ParseException var3) {
            return null;
        }
    }

    public static Date getDateFromDateStr(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dateTime = format.parse(date);
            return dateTime;
        }
        catch (ParseException var6) {
            try {
                Date parse = format1.parse(date);
                return parse;
            }
            catch (ParseException var5) {
                return null;
            }
        }
    }

    public static String getStrFromDate(Date date) {
        return UccDateUtil.getFormatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String regularDateTimeFromDate(Date date) {
        DateTimeFormatter isoLocalDateTime = DateTimeFormatter.ISO_INSTANT;
        return isoLocalDateTime.format(date.toInstant());
    }

    public static String regularDateTimeFromLong(Long date) {
        return UccDateUtil.regularDateTimeFromDate(new Date(date));
    }

    public static Long getTimestampFromISODateStr(String isoDate) {
        return UccDateUtil.getDateFromISODateStr(isoDate).getTime();
    }

    public static Date getDateFromISODateStr(String isoDate) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_INSTANT;
        TemporalAccessor accessor = timeFormatter.parse(isoDate);
        return Date.from(Instant.from(accessor));
    }

    public static Date StrToDate(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(str);
        }
        catch (ParseException var4) {
            var4.printStackTrace();
        }
        return date;
    }

    public static Date stringToDate(String strDate, String format) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException var5) {
            var5.printStackTrace();
        }
        return date;
    }

    public static Date getMonthToday(int n) {
        Date date = new Date();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(2, calendar.get(2) - n);
            date = calendar.getTime();
            return date;
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }
}

