/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccRelBrandVendorDiscountTempMapper;
import com.tydic.commodity.estore.ability.bo.UccBatchSetCatalogBrandVendorDiscountAddAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccBatchSetCatalogBrandVendorDiscountAddAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.UccCatalogBrandVendorAddInfo;
import com.tydic.commodity.estore.busi.api.UccBatchSetCatalogBrandVendorDiscountAddBusiService;
import com.tydic.commodity.po.UccRelBrandVendorDiscountTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchSetCatalogBrandVendorDiscountAddBusiServiceImpl
implements UccBatchSetCatalogBrandVendorDiscountAddBusiService {
    @Autowired
    private UccRelBrandVendorDiscountTempMapper uccRelBrandVendorDiscountTempMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public UccBatchSetCatalogBrandVendorDiscountAddAbilityRspBO addBatchSetCatalogBrandVendorDiscount(UccBatchSetCatalogBrandVendorDiscountAddAbilityReqBO reqBO) {
        Map<Long, List<UccRelBrandVendorDiscountTempPO>> collect;
        UccBatchSetCatalogBrandVendorDiscountAddAbilityRspBO rspBO = new UccBatchSetCatalogBrandVendorDiscountAddAbilityRspBO();
        if (reqBO.getTempId() == null || CollectionUtils.isEmpty((Collection)reqBO.getCatalogBrandVendorRelList())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List oldPOS = this.uccRelBrandVendorDiscountTempMapper.getListByTempId(reqBO.getTempId());
        HashMap vendorIdMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)oldPOS) && !CollectionUtils.isEmpty(collect = oldPOS.stream().filter(e -> e.getVendorId() != null && e.getBrandId() != null).collect(Collectors.groupingBy(UccRelBrandVendorDiscountTempPO::getVendorId)))) {
            for (Long vendorId : collect.keySet()) {
                List brandIds = collect.get(vendorId).stream().map(UccRelBrandVendorDiscountTempPO::getBrandId).collect(Collectors.toList());
                vendorIdMap.put(vendorId, brandIds);
            }
        }
        ArrayList<UccRelBrandVendorDiscountTempPO> addPOS = new ArrayList<UccRelBrandVendorDiscountTempPO>();
        Date now = new Date();
        HashMap<Long, List<Long>> insertVendorIdMap = new HashMap<Long, List<Long>>();
        for (UccCatalogBrandVendorAddInfo addInfo : reqBO.getCatalogBrandVendorRelList()) {
            List<Long> insertBrandIds;
            List oldBrandIds;
            if (addInfo.getBrandId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (addInfo.getVendorId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vendorIdMap.keySet().contains(addInfo.getVendorId()) && (oldBrandIds = (List)vendorIdMap.get(addInfo.getVendorId())).contains(addInfo.getBrandId())) continue;
            if (insertVendorIdMap.keySet().contains(addInfo.getVendorId())) {
                insertBrandIds = (List)insertVendorIdMap.get(addInfo.getVendorId());
                if (insertBrandIds.contains(addInfo.getBrandId())) continue;
                insertBrandIds.add(addInfo.getBrandId());
            } else {
                insertBrandIds = new ArrayList<Long>();
                insertBrandIds.add(addInfo.getBrandId());
                insertVendorIdMap.put(addInfo.getVendorId(), insertBrandIds);
            }
            UccRelBrandVendorDiscountTempPO addPO = new UccRelBrandVendorDiscountTempPO();
            addPO.setRelId(Long.valueOf(this.uccBatchSequence.nextId()));
            addPO.setTempId(reqBO.getTempId());
            addPO.setVendorId(addInfo.getVendorId());
            addPO.setBrandId(addInfo.getBrandId());
            addPO.setDiscount(addInfo.getDiscount());
            addPO.setCreateOperId(reqBO.getUserId().toString());
            addPO.setCreateOperCode(reqBO.getUsername());
            addPO.setCreateOperName(reqBO.getName());
            addPO.setCreateTime(now);
            addPO.setUpdateOperId(reqBO.getUserId().toString());
            addPO.setUpdateOperCode(reqBO.getUsername());
            addPO.setUpdateOperName(reqBO.getName());
            addPO.setUpdateTime(now);
            addPOS.add(addPO);
        }
        if (!CollectionUtils.isEmpty(addPOS)) {
            this.uccRelBrandVendorDiscountTempMapper.insertBatch(addPOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

