/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuOperationLogMapper;
import com.tydic.commodity.estore.busi.api.UccEstoreFailureOfGoodsBusiService;
import com.tydic.commodity.estore.busi.bo.UccEstoreFailureOfGoodsBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccEstoreFailureOfGoodsBusiRspBO;
import com.tydic.commodity.po.UccSkuOperationLogPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccEstoreFailureOfGoodsBusiServiceImpl
implements UccEstoreFailureOfGoodsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreFailureOfGoodsBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuOperationLogMapper uccSkuOperationLogMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    private static final Integer SKU_STATUS = 6;
    private static final Integer OPERATION_TYPE = 14;

    @Override
    public UccEstoreFailureOfGoodsBusiRspBO dealEstoreFailureOfGoods(UccEstoreFailureOfGoodsBusiReqBO reqBO) {
        UccEstoreFailureOfGoodsBusiRspBO rspBO = new UccEstoreFailureOfGoodsBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, UccSkuPo> uccSkuPoMap = uccSkuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, po -> po));
        Map<Long, List<UccSkuPo>> supplierShopMap = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        ArrayList<UccStatusChangeUpdateSpuAtomReqBO> uccStatusChangeUpdateSpuAtomReqBOList = new ArrayList<UccStatusChangeUpdateSpuAtomReqBO>();
        for (Map.Entry<Long, List<UccSkuPo>> entry : supplierShopMap.entrySet()) {
            List<UccSkuPo> uccSkuPos = entry.getValue();
            UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            ArrayList<UccSkuUpdateStatusBO> skuStatusList = new ArrayList<UccSkuUpdateStatusBO>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccSkuUpdateStatusBO uccSkuUpdateStatusBO = new UccSkuUpdateStatusBO();
                uccSkuUpdateStatusBO.setSkuId(uccSkuPo.getSkuId());
                uccSkuUpdateStatusBO.setSkuStatus(SKU_STATUS);
                skuStatusList.add(uccSkuUpdateStatusBO);
            }
            uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuStatusList);
            uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(entry.getKey());
            uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
            uccStatusChangeUpdateSpuAtomReqBOList.add(uccStatusChangeUpdateSpuAtomReqBO);
        }
        log.info("\u5355\u54c1\u72b6\u6001\u66f4\u65b0\u539f\u5b50\u670d\u52a1-\u5165\u53c2\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(uccStatusChangeUpdateSpuAtomReqBOList));
        for (UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO : uccStatusChangeUpdateSpuAtomReqBOList) {
            UccStatusChangeUpdateSpuAtomRspBO uccStatusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if ("0000".equals(uccStatusChangeUpdateSpuAtomRspBO.getRespCode())) continue;
            throw new BusinessException(uccStatusChangeUpdateSpuAtomRspBO.getRespCode(), uccStatusChangeUpdateSpuAtomRspBO.getRespDesc());
        }
        ArrayList<UccSkuOperationLogPO> uccSkuOperationLogPOList = new ArrayList<UccSkuOperationLogPO>();
        for (Long skuId : reqBO.getSkuIds()) {
            UccSkuOperationLogPO uccSkuOperationLogPO = new UccSkuOperationLogPO();
            uccSkuOperationLogPO.setBatchId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuOperationLogPO.setSkuId(skuId);
            uccSkuOperationLogPO.setCommodityId(uccSkuPoMap.get(skuId).getCommodityId());
            uccSkuOperationLogPO.setOperationType(OPERATION_TYPE);
            uccSkuOperationLogPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uccSkuOperationLogPO.setCreateTime(new Date());
            uccSkuOperationLogPO.setRemark("\u9a73\u56de\u81f3\u4f9b\u5e94\u5546");
            uccSkuOperationLogPOList.add(uccSkuOperationLogPO);
        }
        this.uccSkuOperationLogMapper.batchInsert(uccSkuOperationLogPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

