/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.dao.SkuDataGovernPriceMapper;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernInfo;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernReqBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceGovernRspBO;
import com.tydic.commodity.estore.ability.bo.SkuPriceSameInfo;
import com.tydic.commodity.estore.busi.api.UccSkuPriceGovernBusiService;
import com.tydic.commodity.po.SkuDataGovernPricePO;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuPriceGovernBusiServiceImpl
implements UccSkuPriceGovernBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPriceGovernBusiServiceImpl.class);
    private SkuDataGovernPriceMapper skuDataGovernPriceMapper;
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;

    @Override
    public SkuPriceGovernRspBO dealSkuPriceGovernBusi(SkuPriceGovernReqBO reqBO) {
        SkuPriceGovernRspBO rspBO = new SkuPriceGovernRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List skuIds = reqBO.getSkuInfos().stream().map(e -> Long.valueOf(e.getSkuId())).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuIds)) {
            SkuDataGovernPricePO priceDeletePo = new SkuDataGovernPricePO();
            priceDeletePo.setSkuIds(skuIds);
            this.skuDataGovernPriceMapper.deleteBy(priceDeletePo);
            SkuDataGovernSamePricePO somePriceDeletePo = new SkuDataGovernSamePricePO();
            somePriceDeletePo.setSkuIds(skuIds);
            this.skuDataGovernSamePriceMapper.deleteBy(somePriceDeletePo);
        }
        ArrayList<SkuDataGovernPricePO> priceList = new ArrayList<SkuDataGovernPricePO>();
        ArrayList<SkuDataGovernSamePricePO> samePriceList = new ArrayList<SkuDataGovernSamePricePO>();
        ArrayList<Long> existSku = new ArrayList<Long>();
        for (SkuPriceGovernInfo priceGovernInfo : reqBO.getSkuInfos()) {
            if (existSku.contains(Long.valueOf(priceGovernInfo.getSkuId()))) continue;
            SkuDataGovernPricePO pricePo = new SkuDataGovernPricePO();
            pricePo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            pricePo.setSkuId(Long.valueOf(priceGovernInfo.getSkuId()));
            if (CheckUtil.isNotBlank((Object)priceGovernInfo.getLowestPrice())) {
                pricePo.setLowestPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(priceGovernInfo.getLowestPrice().toString())));
            }
            if (CheckUtil.isNotBlank((Object)priceGovernInfo.getRegularPrice())) {
                pricePo.setRegularPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(priceGovernInfo.getRegularPrice().toString())));
            }
            pricePo.setCreateTime(new Date());
            priceList.add(pricePo);
            existSku.add(pricePo.getSkuId());
            for (SkuPriceSameInfo skuPriceSameInfo : priceGovernInfo.getSameComPrice()) {
                SkuDataGovernSamePricePO sameComPrice = new SkuDataGovernSamePricePO();
                sameComPrice.setId(Long.valueOf(Sequence.getInstance().nextId()));
                sameComPrice.setSkuId(Long.valueOf(priceGovernInfo.getSkuId()));
                sameComPrice.setRelSkuId(Long.valueOf(skuPriceSameInfo.getSkuId()));
                sameComPrice.setType(Integer.valueOf(1));
                sameComPrice.setPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(skuPriceSameInfo.getPrice().toString())));
                sameComPrice.setCreateTime(new Date());
                samePriceList.add(sameComPrice);
            }
            for (SkuPriceSameInfo skuPriceMarInfo : priceGovernInfo.getSameMarPrice()) {
                SkuDataGovernSamePricePO sameMarPrice = new SkuDataGovernSamePricePO();
                sameMarPrice.setId(Long.valueOf(Sequence.getInstance().nextId()));
                sameMarPrice.setSkuId(Long.valueOf(priceGovernInfo.getSkuId()));
                sameMarPrice.setRelSkuId(Long.valueOf(skuPriceMarInfo.getSkuId()));
                sameMarPrice.setType(Integer.valueOf(2));
                sameMarPrice.setPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(skuPriceMarInfo.getPrice().toString())));
                sameMarPrice.setCreateTime(new Date());
                samePriceList.add(sameMarPrice);
            }
        }
        if (!CollectionUtils.isEmpty(priceList)) {
            this.skuDataGovernPriceMapper.insertBatch(priceList);
        }
        if (samePriceList.size() > 0) {
            this.skuDataGovernSamePriceMapper.insertBatch(samePriceList);
        }
        if (skuIds.size() > 0) {
            rspBO.setSkuIds(skuIds);
        }
        return rspBO;
    }

    @Autowired
    public void setSkuDataGovernPriceMapper(SkuDataGovernPriceMapper skuDataGovernPriceMapper) {
        this.skuDataGovernPriceMapper = skuDataGovernPriceMapper;
    }

    @Autowired
    public void setSkuDataGovernSamePriceMapper(SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper) {
        this.skuDataGovernSamePriceMapper = skuDataGovernSamePriceMapper;
    }
}

