/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.estore.atom.api.UccDealApprovalAtomService;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomReqBO;
import com.tydic.commodity.estore.atom.bo.UccDealApprovalAtomRspBO;
import com.tydic.commodity.estore.busi.api.UccApplyShelvesFormAuditBusiService;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesFormAuditBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesFormAuditBusiRspBO;
import com.tydic.commodity.po.ApplyShelvesFormPO;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccApplyShelvesFormAuditBusiServiceImpl
implements UccApplyShelvesFormAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyShelvesFormAuditBusiServiceImpl.class);
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private UccDealApprovalAtomService uccDealApprovalAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @Override
    public UccApplyShelvesFormAuditBusiRspBO auditApplyShelvesForm(UccApplyShelvesFormAuditBusiReqBO reqBO) {
        UccApplyShelvesFormAuditBusiRspBO rspBO = new UccApplyShelvesFormAuditBusiRspBO();
        ArrayList<UocApprovalLogPO> uocApprovalLogPOs = new ArrayList<UocApprovalLogPO>();
        try {
            reqBO.getApplyIds().forEach($ -> uocApprovalLogPOs.add(this.taskTodoWaitService.listApproval($)));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u5f85\u529e\u524d\u7f6e\u83b7\u53d6\u673a\u6784\u4fe1\u606f get stationId error:{}", (Throwable)e);
        }
        ArrayList<ApplyShelvesFormPO> list = new ArrayList<ApplyShelvesFormPO>();
        for (Long applyId : reqBO.getApplyIds()) {
            ApplyShelvesFormPO applyShelvesFormPo = new ApplyShelvesFormPO();
            applyShelvesFormPo.setApplyId(applyId);
            ApplyShelvesFormPO modelBy = this.applyShelvesFormMapper.getModelBy(applyShelvesFormPo);
            if (modelBy == null || !modelBy.getApplyStatus().equals(1)) continue;
            list.add(modelBy);
        }
        if (list.size() < reqBO.getApplyIds().size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u7533\u8bf7\u5355id\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
            return rspBO;
        }
        for (ApplyShelvesFormPO po : list) {
            UccDealApprovalAtomReqBO bo = new UccDealApprovalAtomReqBO();
            bo.setAuditAdvice(reqBO.getAuditAdvice());
            bo.setAuditResult(reqBO.getAuditType());
            bo.setStepId(po.getStepId());
            bo.setUserId(reqBO.getUserId());
            bo.setUserName(reqBO.getName());
            bo.setObjType(1);
            bo.setObjId(po.getApplyId());
            bo.setOrgName(reqBO.getOrgName());
            UccDealApprovalAtomRspBO dealApprovalAtomRspBO = this.uccDealApprovalAtomService.dealApproval(bo);
            if (!dealApprovalAtomRspBO.getRespCode().equals("0000")) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(dealApprovalAtomRspBO.getRespDesc());
                return rspBO;
            }
            if (!CollectionUtils.isEmpty(dealApprovalAtomRspBO.getAuditNoticeList())) {
                if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                    rspBO.setAuditNoticeList(dealApprovalAtomRspBO.getAuditNoticeList());
                } else {
                    rspBO.getAuditNoticeList().addAll(dealApprovalAtomRspBO.getAuditNoticeList());
                }
            }
            po.setStepId(dealApprovalAtomRspBO.getStepId());
            if (reqBO.getAuditType() == 0 && dealApprovalAtomRspBO.getFinish().booleanValue()) {
                po.setApplyStatus(Integer.valueOf(2));
                po.setAuditCommitTimeEnd(new Date());
                po.setAcceptStatus(Integer.valueOf(1));
            }
            if (reqBO.getAuditType() == 1) {
                po.setApplyStatus(Integer.valueOf(3));
                po.setAuditCommitTimeEnd(new Date());
                po.setAcceptStatus(Integer.valueOf(0));
            }
            this.applyShelvesFormMapper.updateByApplyId(po);
        }
        this.waitDone(uocApprovalLogPOs, reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void waitDone(List<UocApprovalLogPO> uocApprovalLogPOs, UccApplyShelvesFormAuditBusiReqBO reqBO) {
        try {
            Map<Long, List<UocApprovalLogPO>> collect = uocApprovalLogPOs.stream().collect(Collectors.groupingBy(UocApprovalLogPO::getObjId));
            reqBO.getApplyIds().forEach($ -> {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setObjId($);
                todoUccWaitAbilityReqBO.setBusiCode("2012");
                todoUccWaitAbilityReqBO.setBusiName("\u7533\u8bf7\u4e0a\u67b6\u5f85\u5ba1\u6279");
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("1");
                String nextStationId = ((UocApprovalLogPO)((List)collect.get($)).get(0)).getNextStationId();
                todoUccWaitAbilityReqBO.setStationId(nextStationId.toString());
                UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
                uccDealHandlerReqBO.setHandleName("productApplyHandler");
                this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            });
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u5f85\u529e - \u5546\u54c1\u7533\u8bf7\u4e0a\u67b6\u5ba1\u6279 error:{}", (Throwable)e);
        }
    }
}

