/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static AtomicInteger counter = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClient(String urladdr, String info) {
        String string = null;
        URL url = null;
        HttpURLConnection conn = null;
        BasicAuthenticator auth = new BasicAuthenticator("aimAdmin", "aimadmin");
        Authenticator.setDefault(auth);
        int connectTimeout = Integer.valueOf(System.getProperties().getProperty("http.connect.timeout", "10000"));
        int readTimeout = Integer.valueOf(System.getProperties().getProperty("http.read.timeout", "30000"));
        try {
            url = new URL(urladdr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            conn.getOutputStream().write(info.getBytes());
            conn.getOutputStream().flush();
            conn.getOutputStream().close();
            string = HttpUtil.readContents(conn);
        }
        catch (Exception e) {
            log.error("httpClient error\uff1a", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return string;
    }

    public static String readContents(HttpURLConnection httpurlconnection) {
        String string = "";
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(httpurlconnection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                string = string + inputLine;
            }
        }
        catch (IOException e) {
            log.error("readContents error\uff1a", (Throwable)e);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGetClient(String url) {
        String result = "";
        BufferedReader in = null;
        BasicAuthenticator auth = new BasicAuthenticator("aimAdmin", "aimadmin");
        Authenticator.setDefault(auth);
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.error("httpGetClient error\uff1a" + e2);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean httpDownload(String httpUpUrl, String saveFile) {
        int byteread = 0;
        URL url = null;
        try {
            url = new URL(httpUpUrl);
        }
        catch (MalformedURLException e1) {
            log.error("httpDownload error\uff1a" + e1);
            return false;
        }
        try (FileOutputStream fs = new FileOutputStream(saveFile);){
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream inStream = conn.getInputStream();
            byte[] buffer = new byte[1204];
            while ((byteread = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.flush();
            fs.close();
            inStream.close();
            if (conn != null) {
                conn.disconnect();
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error("httpDownload error" + e);
            return false;
        }
        catch (IOException e) {
            log.error("httpDownload error" + e);
            return false;
        }
    }

    public static String httpUploadByPath(String actionUrl, String path) throws Exception {
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        URL url = new URL(actionUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (path != null) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append(PREFFIX);
            sb1.append(BOUNDARY);
            sb1.append(LINEND);
            sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + path + "\"" + LINEND);
            sb1.append("Content-Type: application/octet-stream;chartset=" + CHARSET + LINEND);
            sb1.append(LINEND);
            outStream.write(sb1.toString().getBytes());
            try (FileInputStream is = new FileInputStream(path);){
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                outStream.write(LINEND.getBytes());
            }
        }
        byte[] end_data = (PREFFIX + BOUNDARY + PREFFIX + LINEND).getBytes();
        outStream.write(end_data);
        outStream.flush();
        outStream.close();
        int res = conn.getResponseCode();
        InputStream in = null;
        StringBuilder sb2 = new StringBuilder();
        if (res == 200) {
            int ch;
            in = conn.getInputStream();
            while ((ch = in.read()) != -1) {
                sb2.append((char)ch);
            }
        }
        if (conn != null) {
            conn.disconnect();
        }
        return sb2.toString();
    }

    public static String httpUpload(String actionUrl, String upFile) throws IOException {
        String operSystem = System.getProperties().getProperty("os.name");
        String fileName = "";
        File directory = new File(".");
        fileName = operSystem.indexOf("Windows") > 0 ? directory.getCanonicalPath() + "\\" + upFile : directory.getCanonicalPath() + "/" + upFile;
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        URL url = new URL(actionUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (fileName != null) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append(PREFFIX);
            sb1.append(BOUNDARY);
            sb1.append(LINEND);
            sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"" + LINEND);
            sb1.append("Content-Type: application/octet-stream;chartset=" + CHARSET + LINEND);
            sb1.append(LINEND);
            outStream.write(sb1.toString().getBytes());
            try (FileInputStream is = new FileInputStream(fileName);){
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                outStream.write(LINEND.getBytes());
            }
        }
        byte[] end_data = (PREFFIX + BOUNDARY + PREFFIX + LINEND).getBytes();
        outStream.write(end_data);
        outStream.flush();
        outStream.close();
        int res = conn.getResponseCode();
        InputStream in = null;
        StringBuilder sb2 = new StringBuilder();
        if (res == 200) {
            int ch;
            in = conn.getInputStream();
            while ((ch = in.read()) != -1) {
                sb2.append((char)ch);
            }
        }
        if (conn != null) {
            conn.disconnect();
        }
        return sb2.toString();
    }

    public static boolean deleteFile(String fileName) {
        File directory = new File(".");
        String operSystem = System.getProperties().getProperty("os.name");
        try {
            String filePath = operSystem.indexOf("Windows") > 0 ? directory.getCanonicalPath() + "\\" + fileName : directory.getCanonicalPath() + "/" + fileName;
            File file = new File(filePath);
            if (!file.exists()) {
                System.out.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + filePath + "\u4e0d\u5b58\u5728\uff01");
                return false;
            }
            if (file.isFile()) {
                if (file.delete()) {
                    System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u6210\u529f\uff01");
                    return true;
                }
                System.out.println("\u5220\u9664\u6587\u4ef6" + filePath + "\u5931\u8d25\uff01");
                return false;
            }
            return false;
        }
        catch (IOException e) {
            log.error("deleteFile error" + e);
            return false;
        }
    }

    public static String getFileName(String inStr, String splitStr) {
        ArrayList<String> a = new ArrayList<String>();
        String str = inStr;
        if (str.substring(str.length() - splitStr.length()).equals(splitStr)) {
            str = str.substring(0, str.length() - splitStr.length());
        }
        while (str != null) {
            String tmp;
            int idx = str.indexOf(splitStr);
            if (idx == -1) {
                tmp = str.substring(0, str.length());
                a.add(tmp);
                break;
            }
            tmp = str.substring(0, idx);
            a.add(tmp);
            str = str.substring(idx + splitStr.length());
        }
        return (String)a.get(a.size() - 1);
    }

    public static int genID() {
        int rid = counter.incrementAndGet();
        if (rid > 99999999) {
            counter.set(1);
        }
        return rid;
    }

    public static String getSequence(int id) {
        String sequence = String.valueOf(id);
        int iLength = sequence.length();
        int strLen = 8 - iLength;
        if (strLen <= 0) {
            return sequence.substring(0, 7);
        }
        String str = "";
        for (int i = 1; i <= strLen; ++i) {
            str = str + "0";
        }
        sequence = str + sequence;
        return sequence;
    }

    public static String doPost(String url, String body, String header) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        HashMap stringHeader = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            if (!StringUtils.isEmpty((Object)header)) {
                stringHeader = (HashMap)JSON.parseObject((String)header, HashMap.class);
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
            httpPost.setConfig(requestConfig);
            if (null != stringHeader) {
                Set entries = stringHeader.entrySet();
                for (Map.Entry entry : entries) {
                    httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(500000).setSocketTimeout(500000).setConnectTimeout(500000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error(url + "\uff1ahttp\u62a5\u9519" + ex);
        }
        return result;
    }

    public static class BasicAuthenticator
    extends Authenticator {
        String userName;
        String password;

        public BasicAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

