/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.common.ability.bo.UccBrandBatchDownSkuEsReqBO;
import com.tydic.commodity.dao.UccCatalogBrandVerifyEditMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccMdmCatalogVerificationConfirmService;
import com.tydic.commodity.estore.ability.bo.UccMdmCatalogVerificationEditReqBO;
import com.tydic.commodity.estore.ability.bo.UccMdmCatalogVerificationEditRspBO;
import com.tydic.commodity.po.UccCatalogBrandVerifyEditPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccMdmCatalogVerificationConfirmService"})
public class UccMdmCatalogVerificationConfirmServiceImpl
implements UccMdmCatalogVerificationConfirmService {
    private static final Logger log = LoggerFactory.getLogger(UccMdmCatalogVerificationConfirmServiceImpl.class);
    private UccCatalogBrandVerifyEditMapper uccCatalogBrandVerifyEditMapper;
    private UccEMdmCatalogMapper uccMdmCatalogMapper;
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="brandSkuDownProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${BRAND_SKU_DOWN_TOPIC:BRAND_SKU_DOWN_TOPIC}")
    private String topic;

    @PostMapping(value={"catalogVerificationConfirm"})
    public UccMdmCatalogVerificationEditRspBO catalogVerificationConfirm(@RequestBody UccMdmCatalogVerificationEditReqBO reqBO) {
        UccMdmCatalogVerificationEditRspBO rsp = new UccMdmCatalogVerificationEditRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        if (CheckUtil.isBlank((Object)reqBO.getEditId()) || CheckUtil.isBlank((Object)reqBO.getEditType())) {
            rsp.setRespCode("\u5931\u8d25");
            rsp.setRespDesc("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rsp;
        }
        switch (reqBO.getEditType()) {
            case 1: {
                UccCatalogBrandVerifyEditPO editPo = new UccCatalogBrandVerifyEditPO();
                editPo.setEditId(reqBO.getEditId());
                List list = this.uccCatalogBrandVerifyEditMapper.getList(editPo);
                ArrayList<UccCatalogBrandVerifyEditPO> syncSkuBrandVerifyList = new ArrayList<UccCatalogBrandVerifyEditPO>();
                int count = 0;
                for (UccCatalogBrandVerifyEditPO dbEditBo : list) {
                    UccEMdmCatalogPO uccMdmCatalogPo = this.uccMdmCatalogMapper.queryByCatId(dbEditBo.getCatalogId());
                    if (uccMdmCatalogPo == null || dbEditBo.getBrandVerify() == null) continue;
                    boolean ifEditStatus = false;
                    if (!dbEditBo.getBrandVerify().equals(uccMdmCatalogPo.getBrandVerify())) {
                        syncSkuBrandVerifyList.add(dbEditBo);
                        if (dbEditBo.getBrandVerify() == 1) {
                            ifEditStatus = true;
                        }
                    }
                    uccMdmCatalogPo.setBrandVerify(dbEditBo.getBrandVerify());
                    if (this.uccMdmCatalogMapper.updateCatalogInfo(uccMdmCatalogPo) != 1) continue;
                    ++count;
                    this.uccCatalogBrandVerifyEditMapper.deleteBy(dbEditBo);
                    if (!ifEditStatus) continue;
                    UccBrandBatchDownSkuEsReqBO esReqBO = new UccBrandBatchDownSkuEsReqBO();
                    esReqBO.setCatalogId(dbEditBo.getCatalogId());
                    esReqBO.setReason(reqBO.getName() + "\u5f00\u542f\u4e86\u7269\u6599\u5206\u7c7b" + uccMdmCatalogPo.getCatalogName() + "\u6821\u9a8c");
                    try {
                        log.info("\u8c03\u7528\u54c1\u724c\u6279\u91cfMQ\u63a5\u53e3\uff0c\u7269\u8d44\u7c7b\u522bID:{}", (Object)dbEditBo.getCatalogId());
                        this.proxyMessageProducer.send(new ProxyMessage(this.topic, "*", JSON.toJSONString((Object)esReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES{}MQ\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)"\u54c1\u724c\u5bf9\u5e94\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
                    }
                }
                if (count == list.size()) {
                    rsp.setRespCode("0000");
                    rsp.setRespDesc("\u6210\u529f");
                } else {
                    if (count == 0) {
                        rsp.setRespCode("\u5931\u8d25");
                    }
                    rsp.setRespDesc("\u66f4\u65b0\u76ee\u6807\u6761\u6570:" + list.size() + "\u5b9e\u9645\u66f4\u65b0\u6210\u529f\u6761\u6570:" + count);
                }
                if (syncSkuBrandVerifyList.size() <= 0) break;
                this.updateSkuCatalogId(syncSkuBrandVerifyList);
                break;
            }
            case 2: {
                UccCatalogBrandVerifyEditPO deletePo = new UccCatalogBrandVerifyEditPO();
                deletePo.setEditId(reqBO.getEditId());
                this.uccCatalogBrandVerifyEditMapper.deleteBy(deletePo);
                break;
            }
        }
        return rsp;
    }

    private void updateSkuCatalogId(List<UccCatalogBrandVerifyEditPO> list) {
        List catalogIds = list.stream().filter(a -> a.getCatalogId() != null).map(a -> a.getCatalogId()).distinct().collect(Collectors.toList());
        SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID);
        syncSceneCommodityToEsReqBO.setCategoryIds(catalogIds);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.UPDATE_BRAND_VERIFY);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5355\u54c1\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Autowired
    public void setUccCatalogBrandVerifyEditMapper(UccCatalogBrandVerifyEditMapper uccCatalogBrandVerifyEditMapper) {
        this.uccCatalogBrandVerifyEditMapper = uccCatalogBrandVerifyEditMapper;
    }

    @Autowired
    public void setUccMdmCatalogMapper(UccEMdmCatalogMapper uccMdmCatalogMapper) {
        this.uccMdmCatalogMapper = uccMdmCatalogMapper;
    }

    @Autowired
    public void setUccSkuMapper(UccSkuMapper uccSkuMapper) {
        this.uccSkuMapper = uccSkuMapper;
    }
}

